-- skip caution screen
function ScreenCautionBranch()
	return "ScreenSelectNumPlayers";
end;

-- skip screenstage
function GetSelectMusicNext()
	if SCREENMAN:GetTopScreen():GetGoToOptions() then
		return SelectFirstOptionsScreen()
	else
		return "ScreenGameplay"
	end
end

function ScreenPlayerOptionsNext()
	if SCREENMAN:GetTopScreen():GetGoToOptions() then
		return "ScreenSongOptions"
	else
		return "ScreenGameplay"
	end
end

function GetGameplayPrevScreen()
	-- on course mode, when we quit, go to eval.
	-- this currently causes crashes....
	if GAMESTATE:IsCourseMode() then
		return GAMESTATE:GetPlayMode() == 'PlayMode_Endless' and GetGameplayNextScreen() or "ScreenTitleMenu";
	end;
	return SongSelectionScreen();
end;

------------------------------------------------------------------------------------
local function GetEvaluationNextScreenInternal( sNextScreen, sFailedScreen, sEndScreen )
	Trace( "GetEvaluationNextScreen: " .. sNextScreen .. ", " .. sFailedScreen .. ", " .. sEndScreen )

	if GAMESTATE:IsEventMode() then
		Trace( "IsEventMode" )
		return sNextScreen
	end
	
	local bIsExtraStage = GAMESTATE:IsAnExtraStage()
	-- Not in event mode.  If failed, go to the game over screen.
	if STATSMAN:GetCurStageStats():AllFailed() and not bIsExtraStage then
		Trace( "Failed" )
		return sFailedScreen
	end

	local sIsStage = not GetTopScreenMetric( "Summary" ) and not GAMESTATE:IsCourseMode()
	if sIsStage then
		local bLastStage = GAMESTATE:GetSmallestNumStagesLeftForAnyHumanPlayer() <= 0
		if not bLastStage then
			Trace( "Another" )
			return sNextScreen
		end
	end

	Trace( "End" )
	return sEndScreen
end

function GetEvaluationSummaryNextScreen()
	return GetEvaluationNextScreenInternal( "ScreenNameEntry", "ScreenProfileSave", "ScreenNameEntry" );
end

function GetEvaluationNextScreen()
	-- then you have to make sure this is ok
	if GAMESTATE:IsEventMode() then
		return "ScreenProfileSave";
	end;

	local sFailedScreen;
	local sEndScreen;
	local append;
	local pm = GAMESTATE:GetPlayMode();
	if pm == "PlayMode_Regular" or pm == "PlayMode_Rave" then
		sFailedScreen = "ScreenProfileSave";
		sEndScreen = "ScreenEvaluationSummary";
	elseif pm == "PlayMode_Nonstop" or pm == "PlayMode_Oni"
		or pm == "PlayMode_Endless" then
		append = ToEnumShortString(pm)
		sFailedScreen = "ScreenEvaluation"..append;
		sEndScreen = "ScreenEvaluation"..append;
	else
		assert(false);
	end

	local sNextScreen;
	if IsNetSMOnline() then sNextScreen = "ScreenNetRoom"
	elseif( IsNetConnected() ) then sNextScreen = "ScreenNetSelectMusic"
	elseif pm == "PlayMode_Nonstop" or pm == "PlayMode_Oni" or pm == "PlayMode_Endless" then
		sNextScreen = "ScreenTitleMenu";
	else sNextScreen = SongSelectionScreen(); end
	
	return GetEvaluationNextScreenInternal( sNextScreen, sFailedScreen, sEndScreen );
end

function ScreenProfileSaveNextScreen()
	if GAMESTATE:IsCourseMode() then
		return "ScreenTitleMenu";
	elseif GAMESTATE:IsEventMode() then
		return SongSelectionScreen();
	end;
	return SelectEndingScreen();
end;