﻿<?xml version="1.0" encoding="UTF-8" ?>

<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:str="http://xsltsl.org/string">

	<!-- Global Definitions -->
	
	<xsl:output method="html" omit-xml-declaration="no" encoding="iso-8859-1" indent="no"/>

	<xsl:strip-space elements="*" />
		
	<xsl:attribute-set name="TopLevelTableAttr">
		<xsl:attribute name="cellpadding">4</xsl:attribute>
		<xsl:attribute name="cellspacing">1</xsl:attribute>
		<xsl:attribute name="border">0</xsl:attribute>
		<xsl:attribute name="width">100%</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="DataTableAttr">
		<xsl:attribute name="cellpadding">2</xsl:attribute>
		<xsl:attribute name="cellspacing">0</xsl:attribute>
		<xsl:attribute name="border">0</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="EntityTableAttr">
		<xsl:attribute name="cellpadding">3</xsl:attribute>
		<xsl:attribute name="cellspacing">1</xsl:attribute>
		<xsl:attribute name="border">0</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="CompactTableAttr">
		<xsl:attribute name="cellpadding">0</xsl:attribute>
		<xsl:attribute name="cellspacing">0</xsl:attribute>
		<xsl:attribute name="border">0</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="ToggleLinkAttr">
		<xsl:attribute name="onClick">JavaScript: toggleLinkClicked(event);</xsl:attribute>
		<xsl:attribute name="onSelectStart">JavaScript: return false;</xsl:attribute>
		<xsl:attribute name="onMouseOver">JavaScript: toggleLinkOnMouseOver(event);</xsl:attribute>
		<xsl:attribute name="onMouseOut">JavaScript: toggleLinkOnMouseOut(event);</xsl:attribute>
		<xsl:attribute name="style">cursor: hand;</xsl:attribute>		
	</xsl:attribute-set>




	

	<!-- Main Template -->

	<xsl:template match="/Stats">
		<html>
			<head>
				<title>StepMania Stats</title>		

				<script language="JavaScript">

					var imgOpenedSymbol = "images/arrow_down.gif";
					var imgClosedSymbol = "images/arrow_right.gif";
					
					function setDisplayAll( image ) {
						var elems = document.getElementsByName("toggleImage");
						for ( var i = 0; i &lt; elems.length; i++ ) {
							if ( elems[i].src != image ) {
								elems[i].src = image;
								toggleImageChanged( elems[i] );
							}
						}
					}
					function toggleLinkClicked(e) {
						var tg;
						if (!e) var e = window.event;
						if (e.target) tg = e.target;
						else if (e.srcElement) tg = e.srcElement;
						if (tg.nodeType == 3) // defeat Safari bug
							tg = targ.parentNode;
	
						var obj = tg;
						if ( obj.name != "toggleImage" ) {
							obj = obj.childNodes.item('toggleImage');
						}
						obj.src.search(imgOpenedSymbol) > -1 ? obj.src = imgClosedSymbol : obj.src = imgOpenedSymbol;
						toggleImageChanged(obj);
					}
					function toggleImageChanged(img) {
						var tg = img;
	
						var disp;
						tg.src.search(imgOpenedSymbol) > -1 ? disp = "" : disp = "none";
						var obj = tg.parentNode.parentNode.parentNode.parentNode;
						obj.rows[1].style.display = disp;
						
						var cell = img.parentNode;
						var spanOpen = cell.childNodes[1];
						spanOpen.style.display = disp;
						var spanClosed = cell.childNodes[2];
						spanClosed.style.display = (disp=="" ? "none" : "");
					}
					function toggleLinkOnMouseOver(e) {
						var tg;
						if (!e) var e = window.event;
						if (e.target) tg = e.target;
						else if (e.srcElement) tg = e.srcElement;
						if (tg.nodeType == 3) // defeat Safari bug
							tg = targ.parentNode;
	
						var obj = tg;
						obj.tagName == 'IMG' ? obj = obj.parentNode : null;
						if ( obj.className == 'main' ) {
							obj.style.backgroundColor = '#C0C1C4';
						} else {
							obj.style.backgroundColor = '#C0C1C4';
						}
					}
					function toggleLinkOnMouseOut(e) {
						var tg;
						if (!e) var e = window.event;
						if (e.target) tg = e.target;
						else if (e.srcElement) tg = e.srcElement;
						if (tg.nodeType == 3) // defeat Safari bug
							tg = targ.parentNode;
	
						var obj = tg;
						obj.tagName == 'IMG' ? obj = obj.parentNode : null;
						if ( obj.className == 'main' ) {
							obj.style.backgroundColor = '#DBE0E5';
						} else {
							obj.style.backgroundColor = '#DBE0E5';
						}
					}
					function setDisplaySummary() {
						var elems = document.getElementsByName("toggleImage");
						for ( var i = 0; i &lt; elems.length; i++ ) {
							var image;
							if ( elems[i].parentNode.parentNode.parentNode.parentNode.parentNode.parentNode.parentNode.parentNode.parentNode.parentNode.nodeName == "HTML" ) {
								image = imgOpenedSymbol;
							} else {
								image = imgClosedSymbol;
							}
							if ( elems[i].src != image ) {
								elems[i].src = image;
							}
							toggleImageChanged(elems[i]);
						}
					}
					function startItUp() {
						var elems = document.getElementsByName("navButton");
						elems[0].imagename = "expand";
						elems[1].imagename = "collapse";
						elems[2].imagename = "summary";
						for ( var i = 0; i &lt; elems.length; i++ ) {
							elems[i].onmouseover = navButtonMouseOver;
							elems[i].onmouseout = navButtonMouseOut;
							elems[i].onmousedown = navButtonMouseDown;
							elems[i].onmouseup = navButtonMouseUp;
						}
						setDisplayAll( imgClosedSymbol );
					}
					function navButtonMouseOver() {
						this.src = 'images/button_' + this.imagename + '_focus.gif';
					}
					function navButtonMouseOut() {
						this.src = 'images/button_' + this.imagename + '_up.gif';
					}
					function navButtonMouseDown() {
						this.src = 'images/button_' + this.imagename + '_down.gif';
					}
					function navButtonMouseUp() {
						this.src = 'images/button_' + this.imagename + '_focus.gif';
					}
				</script>
		        <link type="text/css" rel="stylesheet" href="Style.css"/>
			</head>


			<body topmargin="3" bottommargin="3" leftmargin="3" rightmargin="3" onLoad="JavaScript: startItUp();">

				<table cellpadding="0" cellspacing="0" border="0" width="100%" height="100%">
					<tr>
						<td colspan="3" class="pageheader">
							<table cellpadding="10" cellspacing="0" border="0" width="100%" >
								<tr>
									<td nowrap="nowrap" class="pageheader"><h1>StepMania Stats</h1></td>
									<td width="100%" class="pageheader"></td>
									<td nowrap="nowrap" class="pageheader"><h1>&lt; &lt; &lt; &lt; &lt;</h1></td>
								</tr>
							</table>
						</td>
					</tr>
					
					<tr>
						<td width="100%" height="100%" valign="top" name="masterContainer">
							<br />
							<table cellpadding="10" cellspacing="0" border="0" width="100%">
								<tr>
									<td nowrap="nowrap">
										<input type="button" value="Expand All" name="navButton" onClick="JavaScript:setDisplayAll( imgOpenedSymbol );" /><xsl:text> </xsl:text>
										<input type="button" value="Collapse All" name="navButton" onClick="JavaScript:setDisplayAll( imgClosedSymbol );" /><xsl:text> </xsl:text>
										<input type="button" value="Summary View" name="navButton" onClick="JavaScript:setDisplaySummary();" />
									</td>
									<td align="right" nowrap="nowrap" valign="top">
										<font class="titlename">Name: </font><font class="titlevalue"><xsl:value-of select="/Stats/GeneralData/DisplayName" /></font><br/>
										<font class="titlename">Last Played: </font><font class="titlevalue"><xsl:value-of select="/Stats/GeneralData/LastPlayedDate" /></font>
									</td>
								</tr>
								<tr>
									<td colspan="2">
										<xsl:call-template name="Instructions" />
										<xsl:apply-templates select="/Stats/GeneralData" />
										<xsl:apply-templates mode="Popularity" select="/Stats/SongScores | /Stats/CourseScores" />
										<xsl:apply-templates mode="TopScores" select="/Stats/SongScores | /Stats/CourseScores"/>
										<xsl:apply-templates mode="Completeness" select="/Stats/SongScores | /Stats/CourseScores"/>
										<xsl:apply-templates select="/Stats/ScreenshotData" />
										<xsl:apply-templates select="/Stats/CalorieData" />
										<xsl:apply-templates select="/Stats/RecentSongScores" />
										<xsl:apply-templates select="/Stats/RecentCourseScores" />
									</td>
								</tr>
							</table>
	
						</td>		
					</tr>

					<tr>
						<td colspan="3" class="pagefooter">
							<table cellpadding="10" cellspacing="0" border="0" width="100%" >
								<tr>
									<td nowrap="nowrap" class="pagefooter"><h1>&gt; &gt; &gt; &gt; &gt;</h1></td>
									<td width="100%" class="pagefooter"></td>
									<td nowrap="nowrap" class="pagefooter">generated by <a href="http://www.stepmania.com">StepMania</a></td>
								</tr>
							</table>
						</td>
					</tr>

				</table>
			</body>
		</html>
	</xsl:template>

	
	
	
	<!-- Instructions -->
	
	<xsl:template name="Instructions">
		<xsl:element name="table" use-attribute-sets="TopLevelTableAttr">
			<tr>
				<xsl:element name="th" use-attribute-sets="ToggleLinkAttr">
					<xsl:attribute name="class">main</xsl:attribute>
					<xsl:call-template name="ToggleDisplayImage" />
					<xsl:text> </xsl:text>Instructions	
				</xsl:element>
			</tr>
			<tr name="hide">
				<td style="background: #F4F6F7;">
					<h2>Overview</h2>
					<xsl:element name="table" use-attribute-sets="EntityTableAttr">
						<tr>
							<td>
								This directory contains all your game profile data. Please read these instructions before modifying or moving any files on your memory card. Modifying files may result in irreversible loss of your data.
							</td>
						</tr>
					</xsl:element>
					
					<xsl:call-template name="CollapseableTable">
						<xsl:with-param name="title">Description of Files</xsl:with-param>
						<xsl:with-param name="text">
							Edits/	 	Place edit step files in this directory. See the Edits section below for more details.
							Screenshots/	 	All screenshots that you take are saved in this directory.
							DontShare.sig	 	This is a secret file that you should never share with anyone else. See the Sharing Your Data section below for more details.
							Editable.ini	 	Holds preferences that you can edit offline using your home computer. This file is not digitally signed.
							Stats.html	 	You're looking at this file now. It contains a formatted view of all your saved data, plus some data from the last machine you played on.
							Stats.html.sig	 	The signature file for Stats.html.
							Stats.xml	 	This is the primary data file. It contains all the score data and statistics, and is read by the game when you join.
							Stats.xml.sig	 	The signature file for Stats.xml.
							Style.css	 	Contains style data used by Stats.html.
						</xsl:with-param>
					</xsl:call-template>

					<xsl:call-template name="CollapseableTable">
						<xsl:with-param name="title">Digital Signatures</xsl:with-param>
						<xsl:with-param name="text">
							Some files on your memory card have a corresponding digital signature. Digital signatures are used to verify that your files haven't been modified outside of the game. This prevents cheaters from changing their score data and then passing it off as real.
							Before the game reads your memory card data, it verifies that your data and digital signatures match. If the data and signatures don't match, then your data has been modified outside of the game. When the game detects this condition, it will completely ignore your tampered data. It is very important that you -do not- modify any file that has a digital signature because this will cause your data to be permanently unusable.
							If someone else shares their profile data with you, you can verify their score data using digital signatures. To verify their data, you'll need 3 things:
							- the Stats.xml data file
							- the digital signature file Stats.xml.sig
							- a small utility that will check data against a signature
						</xsl:with-param>
					</xsl:call-template>

					<xsl:call-template name="CollapseableTable">
						<xsl:with-param name="title">Editable Preferences</xsl:with-param>
						<xsl:with-param name="text">
							The file Editable.ini contains settings that you can modify using your home computer. If you're using a Windows PC, you can click here to open the file for editing. This file is not digitally signed and the game will import any changes you make to this file.
						</xsl:with-param>
					</xsl:call-template>

					<xsl:call-template name="CollapseableTable">
						<xsl:with-param name="title">Screenshots</xsl:with-param>
						<xsl:with-param name="text">
							The Screenshots/ directory contains all screenshots that you've captured while playing the game. See the Screenshots section later on this page to see thumbnails and more information captured at the time of the screenshot. The Screenshots section also lists an MD5 hash of the screenshot file. You can use the MD5 has to verify that the screenshot has not been modified since it was first saved.
							If your memory card is full, you may delete files from this directory or the move files to another disk. If you move a screenshot to another disk, you can still verify the screenshot file using the MD5 hash.
						</xsl:with-param>
					</xsl:call-template>

					<xsl:call-template name="CollapseableTable">
						<xsl:with-param name="title">Edits</xsl:with-param>
						<xsl:with-param name="text">
							The Edits/ directory contains edit step files that you've created yourself or downloaded from the internet. See here for more information about edit files.
						</xsl:with-param>
					</xsl:call-template>

					<xsl:call-template name="CollapseableTable">
						<xsl:with-param name="title">Sharing Your Data</xsl:with-param>
						<xsl:with-param name="text">
							You can share your score data with other players or submit it to a web site for an internet ranking contest. When sharing your data though, do -not- share the file DontShare.sig. DontShare.sig is private digital signature required by the game before loading memory card data. Without DontShare.sig, the person you're sharing data with can verify that your data is original, but can't load your data using their memory card or pass your scores off as their own.  
							If you do share your DontShare.sig with someone, then they can completely replicate your memory card and pass your scores off as their own.
						</xsl:with-param>
					</xsl:call-template>

					<xsl:call-template name="CollapseableTable">
						<xsl:with-param name="title">Backing Up Your Data</xsl:with-param>
						<xsl:with-param name="text">
							To make a backup of your data, copy the entire In The Groove/ directory on the root of your memory card to your local hard drive.
							To move your data from the current memory card to a new memory card, move the entire In The Groove/ directory on your current memory card to the root directory on the new memory card.
						</xsl:with-param>
					</xsl:call-template>

				</td>
			</tr>
		</xsl:element>
	</xsl:template>




	<!-- GeneralData-->
		
		
	<xsl:template match="/Stats/GeneralData">
		<xsl:element name="table" use-attribute-sets="TopLevelTableAttr">
			<tr>
				<xsl:element name="th" use-attribute-sets="ToggleLinkAttr">
					<xsl:attribute name="class">main</xsl:attribute>
					<xsl:call-template name="ToggleDisplayImage" />
					<xsl:text> </xsl:text><xsl:apply-templates select="." mode="title" />	
				</xsl:element>
			</tr>
			<tr name="hide">
				<td style="background: #F4F6F7;">
					<xsl:element name="table" use-attribute-sets="EntityTableAttr">
						<xsl:call-template name="DataTableGenerator">
							<xsl:with-param name="cols" select="2" />
							<xsl:with-param name="nodeset" select="*[text()]" />
						</xsl:call-template>
					</xsl:element>
					
					<hr/>
					
					<xsl:apply-templates select="/Stats/GeneralData/*[not(text())]" />
					
				</td>
			</tr>
		</xsl:element>
	</xsl:template>		
		

	
	<xsl:template match="/Stats/GeneralData/*[not(text())]">
		<xsl:element name="table" use-attribute-sets="EntityTableAttr">
			<tr>
				<xsl:element name="th" use-attribute-sets="ToggleLinkAttr">
					<xsl:attribute name="class">main</xsl:attribute>
					<xsl:call-template name="ToggleDisplayImage" />
					<xsl:text> </xsl:text><xsl:apply-templates select="." mode="title" />	
				</xsl:element>
			</tr>
			<tr name="hide">
				<td style="background: #F4F6F7;">
					<xsl:element name="table" use-attribute-sets="EntityTableAttr">
						<xsl:call-template name="DataTableGenerator">
							<xsl:with-param name="cols" select="2" />
							<xsl:with-param name="nodeset" select="*[text()]" />
						</xsl:call-template>
					</xsl:element>
				</td>
			</tr>
		</xsl:element>
	</xsl:template>		
		

	

	<!-- Popularity -->
	
	<xsl:template mode="Popularity" match="/Stats/SongScores | /Stats/CourseScores">
		<xsl:variable name="Type" select="translate(name(*[1]), ' ', ' ')" />
		<xsl:variable name="SubType" select="translate(name(*/*[1]), ' ', ' ')" />
		<xsl:element name="table" use-attribute-sets="TopLevelTableAttr">
			<tr>
				<xsl:element name="th" use-attribute-sets="ToggleLinkAttr">
					<xsl:attribute name="class">main</xsl:attribute>
					<xsl:call-template name="ToggleDisplayImage" />
					<xsl:text> </xsl:text><xsl:value-of select="$Type" /><xsl:text> Popularity</xsl:text>	
				</xsl:element>
			</tr>
			<tr name="hide">
				<td style="background: #F4F6F7;">
					

					<xsl:call-template name="CollapseableTable">
						<xsl:with-param name="title">Ranking</xsl:with-param>
						<xsl:with-param name="text">
							<xsl:element name="table" use-attribute-sets="DataTableAttr">
								<xsl:for-each select="Song | Course">
								<xsl:sort select="sum(*/HighScoreList/NumTimesPlayed)" order="descending"/>
									<tr>
										<td>
											<xsl:value-of select="position()"/>
										</td>
										<td>
											<xsl:variable name="Dir" select="@Dir" />
											<xsl:variable name="Path" select="@Path" />
											<xsl:value-of select="document('Catalog.xml')/Catalog/*[@Dir=$Dir or @Path=$Path]/MainTitle" />
											<xsl:text> </xsl:text>
											<xsl:value-of select="document('Catalog.xml')/Catalog/*[@Dir=$Dir or @Path=$Path]/SubTitle" />
										</td>
										<td>
											<xsl:value-of select="sum(*/HighScoreList/NumTimesPlayed)" />
										</td>
									</tr>
								</xsl:for-each>
							</xsl:element>
						</xsl:with-param>
					</xsl:call-template>
				
					<xsl:call-template name="CollapseableTable">
						<xsl:with-param name="title">Unplayed</xsl:with-param>
						<xsl:with-param name="text">
							<xsl:element name="table" use-attribute-sets="DataTableAttr">
								<xsl:for-each select="document('Catalog.xml')/Catalog/*[name(.)=$Type]">
								<xsl:sort select="sum(*/HighScoreList/NumTimesPlayed)" order="descending"/>
									<xsl:variable name="Dir" select="@Dir" />
									<xsl:variable name="Path" select="@Path" />
									<xsl:variable name="NumPlays" select="sum(document('Stats.xml')/Stats/*/*[@Dir=$Dir or @Path=$Path]/*/HighScoreList/NumTimesPlayed)" />
									<xsl:if test="$NumPlays = 0">
										<tr>
											<td>
												<xsl:value-of select="MainTitle"/><xsl:text> </xsl:text><xsl:value-of select="SubTitle"/>
											</td>
										</tr>
									</xsl:if>
								</xsl:for-each>
							</xsl:element>
						</xsl:with-param>
					</xsl:call-template>
				
					<xsl:call-template name="CollapseableTable">
						<xsl:with-param name="title"><xsl:value-of select="$SubType" /> Ranking</xsl:with-param>
						<xsl:with-param name="text">
							<xsl:element name="table" use-attribute-sets="DataTableAttr">
								<xsl:for-each select="*/*">
								<xsl:sort select="sum(HighScoreList/NumTimesPlayed)" order="descending"/>
									<xsl:variable name="Dir" select="../@Dir" />
									<xsl:variable name="Path" select="../@Path" />
									<xsl:variable name="MainTitle" select="document('Catalog.xml')/Catalog/*[@Dir=$Dir or @Path=$Path]/MainTitle" />
									<xsl:text> </xsl:text>
									<xsl:variable name="SubTitle" select="document('Catalog.xml')/Catalog/*[@Dir=$Dir or @Path=$Path]/SubTitle" />
									<tr>
										<td>
											<xsl:value-of select="position()" />
										</td>
										<td>
											<xsl:value-of select="$MainTitle" /><xsl:text> </xsl:text><xsl:value-of select="$SubTitle" />
										</td>
										<td>
											<xsl:value-of select="@Difficulty | @CourseDifficulty" />
										</td>
										<td>
											<xsl:value-of select="sum(HighScoreList/NumTimesPlayed)" />
										</td>
									</tr>
								</xsl:for-each>
							</xsl:element>
						</xsl:with-param>
					</xsl:call-template>
								
				</td>
			</tr>
		</xsl:element>
	</xsl:template>
	
	

	
	<!-- TopScores for SongScores and CourseScores -->
	
	<xsl:template mode="TopScores" match="/Stats/SongScores | /Stats/CourseScores">
		<xsl:variable name="Type" select="translate(name(*[1]), ' ', ' ')" />
		<xsl:variable name="SubType" select="translate(name(*/*[1]), ' ', ' ')" />
		<xsl:element name="table" use-attribute-sets="TopLevelTableAttr">
			<tr>
				<xsl:element name="th" use-attribute-sets="ToggleLinkAttr">
					<xsl:attribute name="class">main</xsl:attribute>
					<xsl:call-template name="ToggleDisplayImage" />
					<xsl:text> </xsl:text><xsl:value-of select="$Type" /><xsl:text> Top Scores</xsl:text>	
				</xsl:element>
			</tr>
			<tr name="hide">
				<td style="background: #F4F6F7;">
					<xsl:apply-templates mode="TopScores" select="Song | Course" />
				</td>
			</tr>
		</xsl:element>
	</xsl:template>		

	<xsl:template mode="TopScores" match="Song | Course">
		<xsl:variable name="Dir" select="@Dir" />
		<xsl:variable name="Path" select="@Path" />
		<xsl:variable name="MainTitle" select="document('Catalog.xml')/Catalog/*[@Dir=$Dir or @Path=$Path]/MainTitle" />
		<xsl:variable name="SubTitle" select="document('Catalog.xml')/Catalog/*[@Dir=$Dir or @Path=$Path]/SubTitle" />
		<xsl:element name="table" use-attribute-sets="EntityTableAttr">
			<tr>
				<xsl:element name="th" use-attribute-sets="ToggleLinkAttr">
					<xsl:attribute name="class">main</xsl:attribute>
					<xsl:call-template name="ToggleDisplayImage" />
					<xsl:text> </xsl:text><xsl:apply-templates select="$MainTitle" /><xsl:text> </xsl:text><xsl:apply-templates select="$SubTitle" />
				</xsl:element>
			</tr>
			<tr name="hide">
				<td style="background: #F4F6F7;">
					<xsl:apply-templates select="Steps | Trail" />
				</td>
			</tr>
		</xsl:element>
	</xsl:template>		
	
	<xsl:template match="Steps | Trail">
		<xsl:element name="table" use-attribute-sets="EntityTableAttr">
			<tr>
				<xsl:element name="th" use-attribute-sets="ToggleLinkAttr">
					<xsl:attribute name="class">main</xsl:attribute>
					<xsl:call-template name="ToggleDisplayImage" />
					<xsl:text> </xsl:text><xsl:apply-templates select="." mode="TitleGenerator" />
				</xsl:element>
			</tr>
			<tr name="hide">
				<td style="background: #F4F6F7;">
					<xsl:apply-templates select="HighScoreList" />
				</td>
			</tr>
		</xsl:element>
	</xsl:template>		

	
	<xsl:template match="HighScoreList">
		<xsl:element name="table" use-attribute-sets="EntityTableAttr">
			<xsl:call-template name="DataTableGenerator">
				<xsl:with-param name="cols" select="2" />
				<xsl:with-param name="nodeset" select="*[text()]" />
			</xsl:call-template>
		</xsl:element>
		<xsl:apply-templates select="HighScore" />
	</xsl:template>		

	<xsl:template match="HighScore">
	
		<xsl:element name="table" use-attribute-sets="EntityTableAttr">
			<tr>
				<xsl:element name="th" use-attribute-sets="ToggleLinkAttr">
					<xsl:attribute name="class">main</xsl:attribute>
					<xsl:call-template name="ToggleDisplayImage" />
					<xsl:text> </xsl:text><xsl:value-of select="PercentDP"/><xsl:text> </xsl:text><xsl:value-of select="Grade"/><xsl:text> </xsl:text><xsl:value-of select="Name"/>
				</xsl:element>
			</tr>
			<tr name="hide">
				<td style="background: #F4F6F7;">
					<xsl:element name="table" use-attribute-sets="EntityTableAttr">
						<xsl:call-template name="DataTableGenerator">
							<xsl:with-param name="cols" select="2" />
							<xsl:with-param name="nodeset" select="*[text()]" />
						</xsl:call-template>
					</xsl:element>
				</td>
			</tr>
		</xsl:element>
		
	</xsl:template>		

	
	

	<!-- Completeness -->
	
	<xsl:template mode="Completeness" match="/Stats/SongScores | /Stats/CourseScores">
		<xsl:variable name="ScoresName" select="translate(name(), ' ', ' ')" />
		<xsl:variable name="Type" select="translate(name(*[1]), ' ', ' ')" />
		<xsl:variable name="SubType" select="translate(name(*/*[1]), ' ', ' ')" />
		<xsl:variable name="DifficultiesToShowName">
			<xsl:if test="$Type = 'Song'">DifficultiesToShow</xsl:if>
			<xsl:if test="$Type = 'Course'">CourseDifficultiesToShow</xsl:if>
		</xsl:variable>
		<xsl:element name="table" use-attribute-sets="TopLevelTableAttr">
			<tr>
				<xsl:element name="th" use-attribute-sets="ToggleLinkAttr">
					<xsl:attribute name="class">main</xsl:attribute>
					<xsl:call-template name="ToggleDisplayImage" />
					<xsl:text> </xsl:text><xsl:value-of select="$Type" /> Completeness	
				</xsl:element>
			</tr>
			<tr name="hide">
				<td style="background: #F4F6F7;">
					
					<xsl:for-each select="document('Catalog.xml')/Catalog/StepsTypesToShow/*">
						<xsl:variable name="StepsType" select="." />

						<xsl:element name="table" use-attribute-sets="TopLevelTableAttr">
							<tr>
								<xsl:element name="th" use-attribute-sets="ToggleLinkAttr">
									<xsl:attribute name="class">main</xsl:attribute>
									<xsl:call-template name="ToggleDisplayImage" />
									<xsl:text> </xsl:text><xsl:value-of select="$StepsType" />
								</xsl:element>
							</tr>
							<tr name="hide">
								<td style="background: #F4F6F7;">
								

									<xsl:for-each select="document('Catalog.xml')/Catalog/*[name()=$DifficultiesToShowName]/*">
										<xsl:variable name="Difficulty" select="." />
										<h2><xsl:value-of select="$Difficulty"/></h2>
										<xsl:variable name="Actual" select="sum(document('Stats.xml')/Stats/*[name()=$ScoresName]/*/*[(@Difficulty=$Difficulty or @CourseDifficulty=$Difficulty) and @StepsType=$StepsType]/HighScoreList/HighScore[1]/PercentDP)" />
										<xsl:variable name="Possible" select="count(document('Catalog.xml')/Catalog/*[name()=$Type]/*[(@Difficulty=$Difficulty or @CourseDifficulty=$Difficulty) and @StepsType=$StepsType])" />
										<xsl:element name="table" use-attribute-sets="EntityTableAttr">
											<tr>
												<td>Actual: <xsl:value-of select="$Actual" /></td>
												<td>Possible: <xsl:value-of select="$Possible" /></td>
												<td>
													Percent: 
													<xsl:if test="$Possible = 0">0</xsl:if>
													<xsl:if test="$Possible != 0"><xsl:value-of select="$Actual div $Possible" /></xsl:if>
												</td>
											</tr>
										</xsl:element>							
										<hr />
									</xsl:for-each>

									<table>

										<tr>
											<td> </td>
											<xsl:for-each select="document('Catalog.xml')/Catalog/*[name()=$DifficultiesToShowName]/*">
												<xsl:variable name="Difficulty" select="." />
												<td><xsl:value-of select="$Difficulty"/></td>
											</xsl:for-each>
										</tr>
										
										<xsl:for-each select="document('Catalog.xml')/Catalog/*[name()=$Type]">
											<xsl:variable name="Dir" select="@Dir" />
											<xsl:variable name="Path" select="@Path" />
											<tr>
												<td><xsl:value-of select="MainTitle"/><xsl:text> </xsl:text><xsl:value-of select="SubTitle"/></td>
												<xsl:for-each select="document('Catalog.xml')/Catalog/*[name()=$DifficultiesToShowName]/*">
													<xsl:variable name="Difficulty" select="." />
													<xsl:variable name="Actual" select="sum(document('Stats.xml')/Stats/*/*[@Dir=$Dir or @Path=$Path]/Steps[(@Difficulty=$Difficulty or @CourseDifficulty=$Difficulty) and @StepsType=$StepsType]/HighScoreList/HighScore[1]/PercentDP)" />
													<xsl:variable name="Count" select="count(document('Catalog.xml')/Catalog/*[@Dir=$Dir or @Path=$Path]/*[(@Difficulty=$Difficulty or @CourseDifficulty=$Difficulty) and @StepsType=$StepsType])" />
													<xsl:variable name="Meter" select="document('Catalog.xml')/Catalog/*[@Dir=$Dir or @Path=$Path]/*[(@Difficulty=$Difficulty or @CourseDifficulty=$Difficulty) and @StepsType=$StepsType]/Meter" />
													<td>
														<xsl:if test="$Count &gt; 0">
															<xsl:value-of select="$Meter"/><xsl:text> </xsl:text><xsl:value-of select="$Actual"/>
														</xsl:if>
													</td>
												</xsl:for-each>
											</tr>
										</xsl:for-each>
									
									</table>
					

								</td>
							</tr>
						</xsl:element>
					</xsl:for-each>
				
				</td>
			</tr>
		</xsl:element>
	</xsl:template>
	
	


	<!-- RecentSongScores and RecentCourseScores -->
	
	<xsl:template match="/Stats/RecentSongScores | /Stats/RecentCourseScores">
		<xsl:element name="table" use-attribute-sets="TopLevelTableAttr">
			<tr>
				<xsl:element name="th" use-attribute-sets="ToggleLinkAttr">
					<xsl:attribute name="class">main</xsl:attribute>
					<xsl:call-template name="ToggleDisplayImage" />
					<xsl:text> </xsl:text><xsl:apply-templates select="."  mode="title" />	
				</xsl:element>
			</tr>
			<tr name="hide">
				<td style="background: #F4F6F7;">
					<xsl:apply-templates select="HighScoreForASongAndSteps | HighScoreForACourseAndTrail" />
				</td>
			</tr>
		</xsl:element>
	</xsl:template>		
	
	
	<xsl:template match="HighScoreForASongAndSteps | HighScoreForACourseAndTrail">
		<xsl:element name="table" use-attribute-sets="EntityTableAttr">
			<tr>
				<td>
					<xsl:variable name="Dir" select="*/@Dir" />
					<xsl:variable name="Path" select="*/@Path" />
					<xsl:value-of select="document('Catalog.xml')/Catalog/*[@Dir=$Dir or @Path=$Path]/MainTitle" />
					<xsl:text> </xsl:text>
					<xsl:value-of select="document('Catalog.xml')/Catalog/*[@Dir=$Dir or @Path=$Path]/SubTitle" />
				</td>
				<td>
					<xsl:value-of select="*/@StepsType" />
				</td>
				<td>
					<xsl:value-of select="*/@Difficulty" />
				</td>
			</tr>
		</xsl:element>
		<xsl:apply-templates select="HighScore" />
		<hr />
	</xsl:template>		
	




	
	<!-- ScreenshotData -->
		
		
	<xsl:template match="/Stats/ScreenshotData">
		<xsl:element name="table" use-attribute-sets="TopLevelTableAttr">
			<tr>
				<xsl:element name="th" use-attribute-sets="ToggleLinkAttr">
					<xsl:attribute name="class">main</xsl:attribute>
					<xsl:call-template name="ToggleDisplayImage" />
					<xsl:text> </xsl:text><xsl:apply-templates select="." mode="title" />	
				</xsl:element>
			</tr>
			<tr name="hide">
				<td style="background: #F4F6F7;">
					<xsl:for-each select="Screenshot">
						<xsl:sort select="HighScore/Time" order="descending"/>
						<xsl:apply-templates select="." />
					</xsl:for-each>
				</td>
			</tr>
		</xsl:element>
	</xsl:template>		
	
	<xsl:template match="Screenshot">
		<xsl:element name="table" use-attribute-sets="EntityTableAttr">
			<tr>
				<td style="background: #F4F6F7;">
					<img>
						<xsl:attribute name="src"><xsl:value-of select="concat('Screenshots/',FileName)" /></xsl:attribute>
						<xsl:attribute name="width">160</xsl:attribute>
						<xsl:attribute name="height">120</xsl:attribute>
					</img>
				</td>
				<td style="background: #F4F6F7;">
					<xsl:element name="table" use-attribute-sets="EntityTableAttr">
						<xsl:call-template name="DataTableGenerator">
							<xsl:with-param name="cols" select="2" />
							<xsl:with-param name="nodeset" select="*[text()]" />
						</xsl:call-template>
					</xsl:element>
					<xsl:apply-templates select="HighScore" />
				</td>
			</tr>
		</xsl:element>
	</xsl:template>		
	

	
	<!-- CalorieData -->
		
		
	<xsl:template match="/Stats/CalorieData">
		<xsl:element name="table" use-attribute-sets="TopLevelTableAttr">
			<tr>
				<xsl:element name="th" use-attribute-sets="ToggleLinkAttr">
					<xsl:attribute name="class">main</xsl:attribute>
					<xsl:call-template name="ToggleDisplayImage" />
					<xsl:text> </xsl:text><xsl:apply-templates select="." mode="title" />	
				</xsl:element>
			</tr>
			<tr name="hide">
				<td style="background: #F4F6F7;">
					
					<xsl:variable name="Cals" select="../GeneralData/TotalCaloriesBurned" />
					<xsl:variable name="NumSongs" select="sum(../GeneralData/NumSongsPlayedByPlayMode/*)" />
					<xsl:variable name="GameplaySeconds" select="../GeneralData/TotalGameplaySeconds" />
					<xsl:element name="table" use-attribute-sets="EntityTableAttr">
						<tr>
							<td>All time: <xsl:value-of select="$Cals" /></td>
							<td>Per Song: <xsl:value-of select="$Cals div $NumSongs" /></td>
							<td>Per Minute of Gameplay: <xsl:value-of select="$Cals div ($GameplaySeconds div 60)" /></td>
						</tr>
					</xsl:element>
					
					<hr/>

					<h2>By Week</h2>
					<xsl:variable name="firstDateJulian">
						<xsl:call-template name="calculate-julian-day2">
							<xsl:with-param name="date" select="/Stats/CalorieData/CaloriesBurned[1]/@Date" />
						</xsl:call-template>
					</xsl:variable>
					<xsl:variable name="lastDateJulian">
						<xsl:call-template name="calculate-julian-day2">
							<xsl:with-param name="date" select="/Stats/CalorieData/CaloriesBurned[last()]/@Date" />
						</xsl:call-template>
					</xsl:variable>
					<xsl:variable name="lastDateDayOfWeek">
						<xsl:call-template name="calculate-day-of-the-week2">
							<xsl:with-param name="date" select="/Stats/CalorieData/CaloriesBurned[last()]/@Date" />
						</xsl:call-template>
					</xsl:variable>
					<xsl:variable name="lastDateJulianRoundedToWeek" select="$lastDateJulian - $lastDateDayOfWeek" />
					<table>
						<tr>
							<td></td>
							<td>Sun</td>
							<td>Mon</td>
							<td>Tue</td>
							<td>Wed</td>
							<td>Thu</td>
							<td>Fri</td>
							<td>Sat</td>
						</tr>	
						<xsl:call-template name="PrintWeeksRecursive">
							<xsl:with-param name="beginDayJulian" select="$lastDateJulianRoundedToWeek" />
							<xsl:with-param name="stopDayJulian" select="$firstDateJulian" />
						</xsl:call-template>
					</table>
					
				</td>
			</tr>
		</xsl:element>
	</xsl:template>		
	
	
	<xsl:template name="PrintWeeksRecursive">
	    <xsl:param name="beginDayJulian" />
	    <xsl:param name="stopDayJulian" />
	    <xsl:variable name="endDayJulian" select="$beginDayJulian+6" />
	    <td>
			Week of 
			<xsl:call-template name="format-julian-day">
				<xsl:with-param name="julian-day" select="$beginDayJulian" />
			</xsl:call-template>
		</td>
	    <td>
	        <xsl:call-template name="CaloriesForJulianDay">
				<xsl:with-param name="dayJulian" select="$beginDayJulian+0" />
			</xsl:call-template>
		</td>
	    <td>
	        <xsl:call-template name="CaloriesForJulianDay">
				<xsl:with-param name="dayJulian" select="$beginDayJulian+1" />
			</xsl:call-template>
		</td>
	    <td>
	        <xsl:call-template name="CaloriesForJulianDay">
				<xsl:with-param name="dayJulian" select="$beginDayJulian+2" />
			</xsl:call-template>
		</td>
	    <td>
	        <xsl:call-template name="CaloriesForJulianDay">
				<xsl:with-param name="dayJulian" select="$beginDayJulian+3" />
			</xsl:call-template>
		</td>
	    <td>
	        <xsl:call-template name="CaloriesForJulianDay">
				<xsl:with-param name="dayJulian" select="$beginDayJulian+4" />
			</xsl:call-template>
		</td>
	    <td>
	        <xsl:call-template name="CaloriesForJulianDay">
				<xsl:with-param name="dayJulian" select="$beginDayJulian+5" />
			</xsl:call-template>
		</td>
	    <td>
	        <xsl:call-template name="CaloriesForJulianDay">
				<xsl:with-param name="dayJulian" select="$beginDayJulian+6" />
			</xsl:call-template>
		</td>
		<xsl:if test="$beginDayJulian &gt; $stopDayJulian">
			<xsl:variable name="nextBeginDayJulian" select="$beginDayJulian - 7" />
	        <xsl:call-template name="PrintWeeksRecursive">
				<xsl:with-param name="beginDayJulian" select="$nextBeginDayJulian" />
				<xsl:with-param name="stopDayJulian" select="$stopDayJulian" />
			</xsl:call-template>
	    </xsl:if>
	</xsl:template>
	
	<xsl:template name="CaloriesForJulianDay">
	    <xsl:param name="dayJulian" />
		<xsl:variable name="date">
			<xsl:call-template name="format-julian-day">
				<xsl:with-param name="julian-day" select="$dayJulian" />
			</xsl:call-template>
		</xsl:variable>
	    <xsl:value-of select="document('Stats.xml')/Stats/CalorieData/CaloriesBurned[@Date=$date]" />
	</xsl:template>
	
	
	<xsl:template name="calculate-julian-day2">
	    <xsl:param name="date"/><!--2004-04-20-->

		<xsl:variable name="year"><!--2004-->
			<xsl:value-of select="substring-before($date,'-')"/>
		</xsl:variable>	
		<xsl:variable name="month-day"><!--04-20-->
			<xsl:value-of select="substring-after($date,'-')"/>
		</xsl:variable>
		<xsl:variable name="month"><!--04-->
			<xsl:value-of select="substring-before($month-day,'-')"/>
		</xsl:variable>
		<xsl:variable name="day"><!--20-->
			<xsl:value-of select="substring-after($month-day,'-')"/>
		</xsl:variable>
		
		<xsl:call-template name="calculate-julian-day">
			<xsl:with-param name="year" select="$year"/>
			<xsl:with-param name="month" select="$month"/>
			<xsl:with-param name="day" select="$day"/>
		</xsl:call-template>
		
	</xsl:template>
		
	<xsl:template name="calculate-julian-day">
		<xsl:param name="year" /><!--2004-->
		<xsl:param name="month" /><!--04-->
		<xsl:param name="day" /><!--20-->
		
		<xsl:variable name="a" select="floor((14 - $month) div 12)"/>
		<xsl:variable name="y" select="$year + 4800 - $a"/>
		<xsl:variable name="m" select="$month + 12 * $a - 3"/>
		<xsl:value-of select="$day + floor((153 * $m + 2) div 5) + $y * 365 + floor($y div 4) - floor($y div 100) + floor($y div 400) - 32045"/>
	</xsl:template>

	<xsl:template name="format-julian-day">
		<xsl:param name="julian-day"/>
		<xsl:param name="format" select="'%Y-%m-%d'"/>

		<xsl:variable name="a" select="$julian-day + 32044"/>
		<xsl:variable name="b" select="floor((4 * $a + 3) div 146097)"/>
		<xsl:variable name="c" select="$a - floor(($b * 146097) div 4)"/>

		<xsl:variable name="d" select="floor((4 * $c + 3) div 1461)"/>
		<xsl:variable name="e" select="$c - floor((1461 * $d) div 4)"/>
		<xsl:variable name="m" select="floor((5 * $e + 2) div 153)"/>

		<xsl:variable name="day" select="$e - floor((153 * $m + 2) div 5) + 1"/>
		<xsl:variable name="month" select="$m + 3 - 12 * floor($m div 10)"/>
		<xsl:variable name="year" select="$b * 100 + $d - 4800 + floor($m div 10)"/>

		<xsl:call-template name="format-date-time">
			<xsl:with-param name="year" select="$year"/>
			<xsl:with-param name="month" select="$month"/>
			<xsl:with-param name="day" select="$day"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		
	</xsl:template>
	

	
  <xsl:template name="calculate-day-of-the-week">
    <xsl:param name="year"/>
    <xsl:param name="month"/>
    <xsl:param name="day"/>

    <xsl:variable name="a" select="floor((14 - $month) div 12)"/>
    <xsl:variable name="y" select="$year - $a"/>
    <xsl:variable name="m" select="$month + 12 * $a - 2"/>

    <xsl:value-of select="($day + $y + floor($y div 4) - floor($y div 100) + floor($y div 400) + floor((31 * $m) div 12)) mod 7"/>

  </xsl:template>


  <xsl:template name="calculate-day-of-the-week2">
	<xsl:param name="date"/><!--2004-04-20-->
	
	<xsl:variable name="month-day"><!--04-20-->
		<xsl:value-of select="substring-after($date,'-')"/>
	</xsl:variable>
	<xsl:variable name="month"><!--04-->
		<xsl:value-of select="substring-before($month-day,'-')"/>
	</xsl:variable>
	<xsl:variable name="day"><!--20-->
		<xsl:value-of select="substring-after($month-day,'-')"/>
	</xsl:variable>
	<xsl:variable name="year"><!--2004-->
		<xsl:value-of select="substring-before($date,'-')"/>
	</xsl:variable>	

    <xsl:variable name="a" select="floor((14 - $month) div 12)"/>
    <xsl:variable name="y" select="$year - $a"/>
    <xsl:variable name="m" select="$month + 12 * $a - 2"/>

    <xsl:value-of select="($day + $y + floor($y div 4) - floor($y div 100) + floor($y div 400) + floor((31 * $m) div 12)) mod 7"/>

  </xsl:template>



  <xsl:template name="get-day-of-the-week-name">
    <xsl:param name="day-of-the-week"/>

    <xsl:choose>
      <xsl:when test="$day-of-the-week = 0">Sunday</xsl:when>
      <xsl:when test="$day-of-the-week = 1">Monday</xsl:when>
      <xsl:when test="$day-of-the-week = 2">Tuesday</xsl:when>
      <xsl:when test="$day-of-the-week = 3">Wednesday</xsl:when>
      <xsl:when test="$day-of-the-week = 4">Thursday</xsl:when>
      <xsl:when test="$day-of-the-week = 5">Friday</xsl:when>
      <xsl:when test="$day-of-the-week = 6">Saturday</xsl:when>
      <xsl:otherwise>error: <xsl:value-of select="$day-of-the-week"/></xsl:otherwise>
    </xsl:choose>

  </xsl:template>



  <xsl:template name="get-day-of-the-week-abbreviation">
    <xsl:param name="day-of-the-week"/>

    <xsl:choose>
      <xsl:when test="$day-of-the-week = 0">Sun</xsl:when>
      <xsl:when test="$day-of-the-week = 1">Mon</xsl:when>
      <xsl:when test="$day-of-the-week = 2">Tue</xsl:when>
      <xsl:when test="$day-of-the-week = 3">Wed</xsl:when>
      <xsl:when test="$day-of-the-week = 4">Thu</xsl:when>
      <xsl:when test="$day-of-the-week = 5">Fri</xsl:when>
      <xsl:when test="$day-of-the-week = 6">Sat</xsl:when>
      <xsl:otherwise>error: <xsl:value-of select="$day-of-the-week"/></xsl:otherwise>
    </xsl:choose>

  </xsl:template>



  <xsl:template name="get-month-abbreviation">
    <xsl:param name="month"/>

    <xsl:choose>
      <xsl:when test="$month = 1">Jan</xsl:when>
      <xsl:when test="$month = 2">Feb</xsl:when>
      <xsl:when test="$month = 3">Mar</xsl:when>
      <xsl:when test="$month = 4">Apr</xsl:when>
      <xsl:when test="$month = 5">May</xsl:when>
      <xsl:when test="$month = 6">Jun</xsl:when>
      <xsl:when test="$month = 7">Jul</xsl:when>
      <xsl:when test="$month = 8">Aug</xsl:when>
      <xsl:when test="$month = 9">Sep</xsl:when>
      <xsl:when test="$month = 10">Oct</xsl:when>
      <xsl:when test="$month = 11">Nov</xsl:when>
      <xsl:when test="$month = 12">Dec</xsl:when>
      <xsl:otherwise>error: <xsl:value-of select="$month"/></xsl:otherwise>
    </xsl:choose>

  </xsl:template>



  <xsl:template name="get-month-name">
    <xsl:param name="month"/>

    <xsl:choose>
      <xsl:when test="$month = 1">January</xsl:when>
      <xsl:when test="$month = 2">February</xsl:when>
      <xsl:when test="$month = 3">March</xsl:when>
      <xsl:when test="$month = 4">April</xsl:when>
      <xsl:when test="$month = 5">May</xsl:when>
      <xsl:when test="$month = 6">June</xsl:when>
      <xsl:when test="$month = 7">July</xsl:when>
      <xsl:when test="$month = 8">August</xsl:when>
      <xsl:when test="$month = 9">September</xsl:when>
      <xsl:when test="$month = 10">October</xsl:when>
      <xsl:when test="$month = 11">November</xsl:when>
      <xsl:when test="$month = 12">December</xsl:when>
      <xsl:otherwise>error: <xsl:value-of select="$month"/></xsl:otherwise>
    </xsl:choose>

  </xsl:template>



  <xsl:template name="calculate-week-number">
    <xsl:param name="year"/>
    <xsl:param name="month"/>
    <xsl:param name="day"/>

    <xsl:variable name="J">
      <xsl:call-template name="calculate-julian-day">
        <xsl:with-param name="year" select="$year"/>
        <xsl:with-param name="month" select="$month"/>
        <xsl:with-param name="day" select="$day"/>
      </xsl:call-template>
    </xsl:variable>

    <xsl:variable name="d4" select="($J + 31741 - ($J mod 7)) mod 146097 mod 36524 mod 1461"/>
    <xsl:variable name="L" select="floor($d4 div 1460)"/>
    <xsl:variable name="d1" select="(($d4 - $L) mod 365) + $L"/>

    <xsl:value-of select="floor($d1 div 7) + 1"/>

  </xsl:template>



  <xsl:template name="format-date-time">
    <xsl:param name="year"/>
    <xsl:param name="month"/>
    <xsl:param name="day"/>
    <xsl:param name="hour"/>
    <xsl:param name="minute"/>
    <xsl:param name="second"/>
    <xsl:param name="time-zone"/>
    <xsl:param name="format" select="'%Y-%m-%dT%H:%M:%S%z'"/>

    <xsl:value-of select="substring-before($format, '%')"/>

    <xsl:variable name="code" select="substring(substring-after($format, '%'), 1, 1)"/>

    <xsl:choose>

      <!-- Abbreviated weekday name -->
      <xsl:when test="$code='a'">
        <xsl:variable name="day-of-the-week">
          <xsl:call-template name="calculate-day-of-the-week">
            <xsl:with-param name="year" select="$year"/>
            <xsl:with-param name="month" select="$month"/>
            <xsl:with-param name="day" select="$day"/>
          </xsl:call-template>
        </xsl:variable>
        <xsl:call-template name="get-day-of-the-week-abbreviation">
          <xsl:with-param name="day-of-the-week" select="$day-of-the-week"/>
        </xsl:call-template>
      </xsl:when>

      <!-- Full weekday name -->
      <xsl:when test="$code='A'">
        <xsl:variable name="day-of-the-week">
          <xsl:call-template name="calculate-day-of-the-week">
            <xsl:with-param name="year" select="$year"/>
            <xsl:with-param name="month" select="$month"/>
            <xsl:with-param name="day" select="$day"/>
          </xsl:call-template>
        </xsl:variable>
        <xsl:call-template name="get-day-of-the-week-name">
          <xsl:with-param name="day-of-the-week" select="$day-of-the-week"/>
        </xsl:call-template>
      </xsl:when>

      <!-- Abbreviated month name -->
      <xsl:when test="$code='b'">
        <xsl:call-template name="get-month-abbreviation">
          <xsl:with-param name="month" select="$month"/>
        </xsl:call-template>
      </xsl:when>

      <!-- Full month name -->
      <xsl:when test="$code='B'">
        <xsl:call-template name="get-month-name">
          <xsl:with-param name="month" select="$month"/>
        </xsl:call-template>
      </xsl:when>

      <!-- Date and time representation appropriate for locale -->
      <xsl:when test="$code='c'">
        <xsl:text>[not implemented]</xsl:text>
      </xsl:when>

      <!-- Day of month as decimal number (01 - 31) -->
      <xsl:when test="$code='d'">
        <xsl:if test="$day &lt; 10">0</xsl:if>
        <xsl:value-of select="number($day)"/>
      </xsl:when>

      <!-- Hour in 24-hour format (00 - 23) -->
      <xsl:when test="$code='H'">
        <xsl:if test="$hour &lt; 10">0</xsl:if>
        <xsl:value-of select="number($hour)"/>
      </xsl:when>

      <!-- Hour in 12-hour format (01 - 12) -->
      <xsl:when test="$code='I'">
        <xsl:choose>
          <xsl:when test="$hour = 0">12</xsl:when>
          <xsl:when test="$hour &lt; 10">0<xsl:value-of select="$hour - 0"/></xsl:when>
          <xsl:when test="$hour &lt; 13"><xsl:value-of select="$hour - 0"/></xsl:when>
          <xsl:when test="$hour &lt; 22">0<xsl:value-of select="$hour - 12"/></xsl:when>
          <xsl:otherwise><xsl:value-of select="$hour - 12"/></xsl:otherwise>
        </xsl:choose>
      </xsl:when>

      <!-- Day of year as decimal number (001 - 366) -->
      <xsl:when test="$code='j'">
        <xsl:text>[not implemented]</xsl:text>
      </xsl:when>

      <!-- Month as decimal number (01 - 12) -->
      <xsl:when test="$code='m'">
        <xsl:if test="$month &lt; 10">0</xsl:if>
        <xsl:value-of select="number($month)"/>
      </xsl:when>

      <!-- Minute as decimal number (00 - 59) -->
      <xsl:when test="$code='M'">
        <xsl:if test="$minute &lt; 10">0</xsl:if>
        <xsl:value-of select="number($minute)"/>
      </xsl:when>

      <!-- Current locale's A.M./P.M. indicator for 12-hour clock -->
      <xsl:when test="$code='p'">
        <xsl:choose>
          <xsl:when test="$hour &lt; 12">AM</xsl:when>
          <xsl:otherwise>PM</xsl:otherwise>
        </xsl:choose>
      </xsl:when>

      <!-- Second as decimal number (00 - 59) -->
      <xsl:when test="$code='S'">
        <xsl:if test="$second &lt; 10">0</xsl:if>
        <xsl:value-of select="number($second)"/>
      </xsl:when>

      <!-- Week of year as decimal number, with Sunday as first day of week (00 - 53) -->
      <xsl:when test="$code='U'">
        <!-- add 1 to day -->
        <xsl:call-template name="calculate-week-number">
          <xsl:with-param name="year" select="$year"/>
          <xsl:with-param name="month" select="$month"/>
          <xsl:with-param name="day" select="$day + 1"/>
        </xsl:call-template>
      </xsl:when>

      <!-- Weekday as decimal number (0 - 6; Sunday is 0) -->
      <xsl:when test="$code='w'">
        <xsl:call-template name="calculate-day-of-the-week">
          <xsl:with-param name="year" select="$year"/>
          <xsl:with-param name="month" select="$month"/>
          <xsl:with-param name="day" select="$day"/>
        </xsl:call-template>
      </xsl:when>

      <!-- Week of year as decimal number, with Monday as first day of week (00 - 53) -->
      <xsl:when test="$code='W'">
        <xsl:call-template name="calculate-week-number">
          <xsl:with-param name="year" select="$year"/>
          <xsl:with-param name="month" select="$month"/>
          <xsl:with-param name="day" select="$day"/>
        </xsl:call-template>
      </xsl:when>

      <!-- Date representation for current locale -->
      <xsl:when test="$code='x'">
        <xsl:text>[not implemented]</xsl:text>
      </xsl:when>

      <!-- Time representation for current locale -->
      <xsl:when test="$code='X'">
        <xsl:text>[not implemented]</xsl:text>
      </xsl:when>

      <!-- Year without century, as decimal number (00 - 99) -->
      <xsl:when test="$code='y'">
        <xsl:text>[not implemented]</xsl:text>
      </xsl:when>

      <!-- Year with century, as decimal number -->
      <xsl:when test="$code='Y'">
        <xsl:value-of select="concat(substring('000', string-length(number($year))), $year)"/>
      </xsl:when>

      <!-- Time-zone name or abbreviation; no characters if time zone is unknown -->
      <xsl:when test="$code='z'">
        <xsl:value-of select="$time-zone"/>
      </xsl:when>

      <!-- Percent sign -->
      <xsl:when test="$code='%'">
        <xsl:text>%</xsl:text>
      </xsl:when>

    </xsl:choose>

    <xsl:variable name="remainder" select="substring(substring-after($format, '%'), 2)"/>

    <xsl:if test="$remainder">
      <xsl:call-template name="format-date-time">
        <xsl:with-param name="year" select="$year"/>
        <xsl:with-param name="month" select="$month"/>
        <xsl:with-param name="day" select="$day"/>
        <xsl:with-param name="hour" select="$hour"/>
        <xsl:with-param name="minute" select="$minute"/>
        <xsl:with-param name="second" select="$second"/>
        <xsl:with-param name="time-zone" select="$time-zone"/>
        <xsl:with-param name="format" select="$remainder"/>
      </xsl:call-template>
    </xsl:if>

  </xsl:template>
  
	<!-- Main Categories End - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
	
	
	
	
	
	
	

	
	
	<!-- General Name Templates -->	
	
	<xsl:template match="*" mode="name" priority="-1"><xsl:value-of select="translate(name(), '_', ' ')" /></xsl:template>
	<xsl:template match="*" mode="title" priority="-1"><xsl:value-of select="translate(name(), '_', ' ')" /></xsl:template>

	

	
	
	


	<!-- DataTable Elements -->
	
	<xsl:template match="*" mode="DataTableElement" priority="-1">
		<xsl:param name="nowrap" />
		<xsl:if test="descendant::text()">
			<tr>
				<xsl:element name="td">
					<xsl:attribute name="class">valuename</xsl:attribute>										
					<xsl:if test="$nowrap != ''">
						<xsl:attribute name="nowrap">nowrap</xsl:attribute>
					</xsl:if>
					<xsl:apply-templates select="." mode="name" />
				</xsl:element>
				<td>&#160;</td>
				<xsl:element name="td">
					<xsl:attribute name="class">dyndata</xsl:attribute>										
					<xsl:if test="$nowrap != ''">
						<xsl:attribute name="nowrap">nowrap</xsl:attribute>
					</xsl:if>
					<xsl:apply-templates select="." />
				</xsl:element>
				<td>&#160;&#160;&#160;</td>
			</tr>
		</xsl:if>
	</xsl:template>




	

	<!-- Value Handlers and Formatters -->
	
	<xsl:template name="DoubleValueHandler">
		<xsl:param name="value" select="1" />
		<xsl:param name="base" select="1" />
		<xsl:param name="exp" select="1" />
		<xsl:param name="unit" select="1" />
		<xsl:choose>
			<xsl:when test="$base = 10 and $exp = 0">
				<xsl:value-of select="format-number($value, '0.0')" />&#160;<xsl:value-of select="$unit" />
			</xsl:when>
			<xsl:when test="$base = 10 and $exp = 6 and $unit = 'Hz'">
				<xsl:value-of select="format-number($value, '0.0')" />&#160;MHz
			</xsl:when>
			<xsl:when test="$base = 10 and $exp = 9 and $unit = 'Hz'">
				<xsl:value-of select="format-number($value, '0.0')" />&#160;GHz
			</xsl:when>
			<xsl:when test="$base = 2 and $exp = 0 and $unit = 'B'">
				<xsl:value-of select="format-number($value, '0')" />&#160;B
			</xsl:when>
			<xsl:when test="$base = 2 and $exp = 10 and $unit = 'B'">
				<xsl:value-of select="format-number($value, '0')" />&#160;KB
			</xsl:when>
			<xsl:when test="$base = 2 and $exp = 20 and $unit = 'B'">
				<xsl:value-of select="format-number($value, '0')" />&#160;MB
			</xsl:when>
			<xsl:when test="$base = 2 and $exp = 30 and $unit = 'B'">
				<xsl:value-of select="format-number($value, '0.00')" />&#160;GB
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$value" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="DoubleValue">
		<xsl:choose>
			<xsl:when test="@base = 16 and @unit = 'B'">
				<xsl:call-template name="DoubleValueHandler">
					<xsl:with-param name="value">
						<xsl:call-template name="power">
							<xsl:with-param name="base" select="2" />
							<xsl:with-param name="exp" select="(@exp * 4) mod 10" />
							<xsl:with-param name="factor" select="." />
						</xsl:call-template>
					</xsl:with-param>
					<xsl:with-param name="base" select="2" />
					<xsl:with-param name="exp" select="(@exp * 4) - ( (@exp * 4) mod 10 )" />
					<xsl:with-param name="unit" select="@unit" />
				</xsl:call-template>
			</xsl:when>			
			<xsl:otherwise>
				<xsl:call-template name="DoubleValueHandler">
					<xsl:with-param name="value" select="." />
					<xsl:with-param name="base" select="@base" />
					<xsl:with-param name="exp" select="@exp" />
					<xsl:with-param name="unit" select="@unit" />
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="IntValue">
		<xsl:choose>
			<xsl:when test="@base = 10 and @exp = 0">
				<xsl:value-of select="format-number(., '0')" />&#160;<xsl:value-of select="@unit" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="." />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="EnumValue">
		<xsl:apply-templates select="String" />				
	</xsl:template>



	
	

	<!-- Table Generator -->

	<xsl:template name="TableGenerator">
		<xsl:param name="cols" select="2" />
		<xsl:param name="nodeset" />
		<xsl:param name="nodecounter" select="1" />
		<xsl:param name="trid" />
		<tr name="{$trid}">
			<xsl:apply-templates select="$nodeset[position() >= $nodecounter and position() &lt; $nodecounter + $cols]" mode="TableGeneratorColumn">
				<xsl:with-param name="rownode" select="$nodecounter" />
				<xsl:with-param name="total" select="count($nodeset)" />
			</xsl:apply-templates>
			<xsl:if test="$nodecounter > 1 and ( $nodecounter + $cols > count($nodeset) ) and count($nodeset) mod $cols != 0">
				<xsl:apply-templates select="$nodeset[1]" mode="TableGeneratorColumn">
					<xsl:with-param name="emptycounter" select="$cols - ( count($nodeset) mod $cols )" />
				</xsl:apply-templates>
			</xsl:if>
		</tr>
		<xsl:if test="$nodecounter + $cols &lt;= count($nodeset)">
			<xsl:call-template name="TableGenerator">
				<xsl:with-param name="cols" select="$cols" />
				<xsl:with-param name="nodecounter" select="$nodecounter + $cols" />
				<xsl:with-param name="nodeset" select="$nodeset" />
				<xsl:with-param name="trid" select="$trid" />
			</xsl:call-template>
		</xsl:if>
	</xsl:template>

	<xsl:template match="*" mode="TableGeneratorColumn">
		<xsl:param name="emptycounter" select="0" />
		<xsl:param name="rownode" select="1" />
		<xsl:param name="total" select="1" />
		<xsl:variable name="current" select="$rownode + position() - 1" />
		<td>
			<xsl:choose>
				<xsl:when test="$emptycounter > 0">
					&#160;
				</xsl:when>
				<xsl:otherwise>
					<xsl:apply-templates select=".">
						<xsl:with-param name="current" select="$current" />
						<xsl:with-param name="total" select="$total" />
					</xsl:apply-templates>
				</xsl:otherwise>
			</xsl:choose>
		</td>
		<xsl:if test="$emptycounter > 1">
			<xsl:apply-templates select="." mode="TableGeneratorColumn">
				<xsl:with-param name="emptycounter" select="$emptycounter - 1" />
			</xsl:apply-templates>
		</xsl:if>
	</xsl:template>
	
	
	
	
	
	


	<!-- Title Generator -->

	<xsl:template mode="TitleGenerator" match="*">
		<xsl:apply-templates select="@*"/>
	</xsl:template>

	<xsl:template match="@*">
		<xsl:value-of select="."/><xsl:text> </xsl:text>
	</xsl:template>
  

	<!-- DataTable Generator -->

	<xsl:template name="DataTableGenerator">
		<xsl:param name="cols" select="2" />
		<xsl:param name="nodeset" />
		<xsl:param name="nodecounter" select="1" />
		<xsl:variable name="skip" select="ceiling( count($nodeset) div $cols )" />
		<td valign="top">
			<xsl:element name="table" use-attribute-sets="DataTableAttr">
				<xsl:apply-templates select="$nodeset[(position() >= $nodecounter) and (position() &lt; ($nodecounter + $skip))]" mode="DataTableElement" />
			</xsl:element>
		</td>
		<xsl:if test="($nodecounter + $skip) &lt;= count($nodeset)">
			<xsl:call-template name="DataTableGenerator">
				<xsl:with-param name="cols" select="$cols" />
				<xsl:with-param name="nodecounter" select="$nodecounter + $skip" />
				<xsl:with-param name="nodeset" select="$nodeset" />
				<xsl:with-param name="skip" select="$skip" />
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	
	
	
	<!-- CollapseableTable -->
		
	<xsl:template name="CollapseableTable">
		<xsl:param name="title" />
		<xsl:param name="text" />
		<xsl:element name="table" use-attribute-sets="EntityTableAttr">
			<tr>
				<xsl:element name="th" use-attribute-sets="ToggleLinkAttr">
					<xsl:attribute name="class">main</xsl:attribute>
					<xsl:call-template name="ToggleDisplayImage" />
					<xsl:text> </xsl:text><xsl:value-of select="$title" />
				</xsl:element>
			</tr>
			<tr name="hide">
				<td>
					<xsl:element name="table" use-attribute-sets="DataTableAttr">
						<tr>
							<td>
								<xsl:copy-of select="$text" />
							</td>
						</tr>
					</xsl:element>
				</td>
			</tr>
		</xsl:element>
	</xsl:template>
	
	
	
	
	<!-- Link for hiding & displaying data -->
		
	<xsl:template name="ToggleDisplayImage">
		<img name="toggleImage" align="absmiddle" class="hidden" /><span>▼</span><span>►</span>
	</xsl:template>



		
	<!-- Template for calculating power -->
	
	<xsl:template name="power">
		<xsl:param name="base" select="1" />
		<xsl:param name="exp" select="1" />
		<xsl:param name="factor" select="1" />
		<xsl:param name="result" select="$base" />

		<xsl:choose>
			<xsl:when test="$exp > 1">
				<xsl:call-template name="power">
					<xsl:with-param name="base" select="$base" />
					<xsl:with-param name="exp" select="$exp - 1" />
					<xsl:with-param name="factor" select="$factor" />
					<xsl:with-param name="result" select="$result * $base" />
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$exp = 1">
				<xsl:value-of select="$result * $factor"/>
			</xsl:when>
			
			<xsl:when test="$exp &lt; -1">
				<xsl:call-template name="power">
					<xsl:with-param name="base" select="$base" />
					<xsl:with-param name="exp" select="$exp + 1" />
					<xsl:with-param name="factor" select="$factor" />
					<xsl:with-param name="result" select="$result * $base" />
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$exp = -1">
				<xsl:value-of select="( 1 div $result ) * $factor"/>
			</xsl:when>	
			
			<xsl:when test="$exp = 0">
				<xsl:value-of select="$factor"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>

	

	

	<!-- That's it -->
	
</xsl:stylesheet>

