﻿/* RageDisplay_D3D - Direct3D renderer. */

#ifndef RAGE_DISPLAY_D3D_H
#define RAGE_DISPLAY_D3D_H

class RageDisplay_D3D: public RageDisplay
{
public:
	RageDisplay_D3D();
	~RageDisplay_D3D() override;
	RString Init( const VideoModeParams &p, bool bAllowUnacceleratedRenderer ) override;

	RString GetApiDescription() const override { return "D3D"; }
	virtual void GetDisplayResolutions( DisplayResolutions &out ) const;
	void ResolutionChanged() override;
	const RagePixelFormatDesc *GetPixelFormatDesc(RagePixelFormat pf) const override;

	bool BeginFrame() override;	
	void EndFrame() override;
	const VideoModeParams* GetActualVideoModeParams() const override;
	void SetBlendMode( BlendMode mode ) override;
	bool SupportsTextureFormat( RagePixelFormat pixfmt, bool realtime=false ) override;
	bool SupportsThreadedRendering() override;
	bool SupportsPerVertexMatrixScale() override { return false; }
	unsigned CreateTexture( 
		RagePixelFormat pixfmt, 
		RageSurface* img, 
		bool bGenerateMipMaps ) override;
	void UpdateTexture( 
		unsigned iTexHandle, 
		RageSurface* img,
		int xoffset, int yoffset, int width, int height 
		) override;
	void DeleteTexture( unsigned iTexHandle ) override;
	void ClearAllTextures() override;
	int GetNumTextureUnits() override;
	void SetTexture( TextureUnit tu, unsigned iTexture ) override;
	void SetTextureMode( TextureUnit tu, TextureMode tm ) override;
	void SetTextureWrapping( TextureUnit tu, bool b ) override;
	int GetMaxTextureSize() const override;
	void SetTextureFiltering( TextureUnit tu, bool b ) override;
	bool IsZWriteEnabled() const override;
	bool IsZTestEnabled() const override;
	void SetZWrite( bool b ) override;
	void SetZBias( float f ) override;
	void SetZTestMode( ZTestMode mode ) override;
	void ClearZBuffer() override;
	void SetCullMode( CullMode mode ) override;
	void SetAlphaTest( bool b ) override;
	void SetMaterial( 
		const RageColor &emissive,
		const RageColor &ambient,
		const RageColor &diffuse,
		const RageColor &specular,
		float shininess
		) override;
	void SetLighting( bool b ) override;
	void SetLightOff( int index ) override;
	void SetLightDirectional( 
		int index, 
		const RageColor &ambient, 
		const RageColor &diffuse, 
		const RageColor &specular, 
		const RageVector3 &dir ) override;

	unsigned CreateRenderTarget(const RenderTargetParam &param, int &iTextureWidthOut, int &iTextureHeightOut) override;
	unsigned GetRenderTarget() override;
	void SetRenderTarget(unsigned uTexHandle, bool bPreserveTexture) override;

	void SetSphereEnvironmentMapping( TextureUnit tu, bool b ) override;
	void SetCelShaded( int stage ) override;

	bool IsD3DInternal() override;

	RageCompiledGeometry* CreateCompiledGeometry() override;
	void DeleteCompiledGeometry( RageCompiledGeometry* p ) override;

protected:
	void DrawQuadsInternal( const RageSpriteVertex v[], int iNumVerts ) override;
	void DrawQuadStripInternal( const RageSpriteVertex v[], int iNumVerts ) override;
	void DrawFanInternal( const RageSpriteVertex v[], int iNumVerts ) override;
	void DrawStripInternal( const RageSpriteVertex v[], int iNumVerts ) override;
	void DrawTrianglesInternal( const RageSpriteVertex v[], int iNumVerts ) override;
	void DrawSymmetricQuadStripInternal( const RageSpriteVertex v[], int iNumVerts ) override;
	void DrawCompiledGeometryInternal( const RageCompiledGeometry *p, int iMeshIndex ) override;

	RString TryVideoMode( const VideoModeParams &p, bool &bNewDeviceOut ) override;
	RageSurface* CreateScreenshot() override;
	RageMatrix GetOrthoMatrix( float l, float r, float b, float t, float zn, float zf ) override;

	void RecoverFromDeviceLoss();
	void SendCurrentMatrices();
};

class RenderTarget
{
public:
	virtual ~RenderTarget() = default;

	virtual void Create(const RenderTargetParam &param, int &iTextureWidthOut, int &iTextureHeightOut) = 0;

	virtual unsigned GetTexture() const = 0;

	/* Render to this RenderTarget. */
	virtual void StartRenderingTo() = 0;

	/* Stop rendering to this RenderTarget.  Update the texture, if necessary, and
	* make it available. */
	virtual void FinishRenderingTo() = 0;

	virtual bool InvertY() const { return false; }

	const RenderTargetParam &GetParam() const { return m_Param; }

protected:
	RenderTargetParam m_Param;
};

#endif

/*
 * Copyright (c) 2001-2004 Chris Danford, Glenn Maynard
 * All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, and/or sell copies of the Software, and to permit persons to
 * whom the Software is furnished to do so, provided that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the Software and that both the above copyright notice(s) and this
 * permission notice appear in supporting documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT
 * OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
 * OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */
