Branch.Init = function()
	if ProductID() == "StepMania 5 TE" then
		return "ScreenPreview1"
	else
		return "ScreenIncompatible"
	end
end

Branch.PostStyle = function() return "ScreenProfileLoad" end

Branch.PostProfileLoad = function()
	if SONGMAN:GetNumCourses() == 0 then
		-- no courses; go straight to selmusic, don't pass go, don't collect C200
		return "ScreenSelectMusic"
	elseif SONGMAN:GetNumSongs() == 0 then
		-- no songs at all. go back to title menu.
		return Branch.TitleMenu()
	else
		-- both songs and courses are installed.
		return "ScreenSelectPlayMode"
	end
end

Branch.GameStart = function()
	local autoSetStyle = ThemePrefs.Get("AutoSetStyle")
	if not autoSetStyle then
		local game = GAMESTATE:GetCurrentGame():GetName()
		if game == "kb7" then
			-- hm. we need to join whatever the master player is, I don't know.
			return "ScreenSelectStyle"
		else
			return "ScreenSelectStyle"
		end
	else
		return "ScreenSelectNumPlayers"
	end
end

Branch.PlayerOptions = function()
	if SCREENMAN:GetTopScreen():GetGoToOptions() then
		if GAMESTATE:IsCourseMode() then
			local isOni = GAMESTATE:GetPlayMode() == "PlayMode_Oni"
			return isOni and "ScreenStageInformation" or "ScreenPlayerOptionsCourse"
		else
			return "ScreenPlayerOptions"
		end
	end

	return "ScreenStageInformation"
end

Branch.PostPlayerOptions = function()
	if GAMESTATE:IsCourseMode() then
		return "ScreenStageInformation"
	else
		-- normal
		if SCREENMAN:GetTopScreen():GetGoToOptions() then
			return "ScreenSongOptions"
		else
			return "ScreenStageInformation"
		end
	end
end

Branch.AfterGameplay = function()
	local numPlayers = GAMESTATE:GetNumPlayersEnabled()
	if numPlayers == 1 then return "ScreenEvaluation1P"
	elseif numPlayers == 2 then return "ScreenEvaluation2P"
	end

	-- fallback omg wtf are you do!
	return "ScreenEvaluationNormal"
end

Branch.ProfileDataMenu = function()
	-- if no profiles are on machine, die in fire.
	if PROFILEMAN:GetNumLocalProfiles() < 1 then
		return "ScreenDataMain"
	end

	return "ScreenDataProfile"
end
