function InitGameEnvs()
	-- used for disabling the no profile message from appearing multiple times
	-- in a single session (since that will get annoying fast.)
	setenv("NoProfileMessageP1",false)
	setenv("NoProfileMessageP2",false)

	-- profile editing stuff
	setenv("DataPlayerProfile",nil)		-- profile data to view
	setenv("SpeedModProfile",nil)		-- profile speed mods to edit
end

local function OptionNameString(str) return THEME:GetString('OptionNames',str) end

local Prefs =
{
	AutoSetStyle =
	{
		Default = false,
		Choices = { OptionNameString('Off'), OptionNameString('On') },
		Values = { false, true }
	},
	GameplayFooter =
	{
		Default = "On",
		Choices = { OptionNameString('On'), OptionNameString('ScoreOnly'), OptionNameString('Off') },
		Values = { "On", "ScoreOnly", "Off" }
	},
	ArrowPosition =
	{
		Default = "Normal",
		Choices = { OptionNameString('Normal'), OptionNameString('ITG') },
		Values = { "Normal", "ITG" }
	},
	-- judgment style (global)
	JudgeStyle =
	{
		Default = "Normal",
		Choices = { "Normal", "sm-ssc", "Classic", "Groovy" },
		Values = { "Normal", "sm-ssc", "Classic", "Groovy" },
	},
	-- judgment ticks (global)
	JudgeTicks =
	{
		Default = false,
		Choices = { OptionNameString('Off'), OptionNameString('On') },
		Values = { false, true }
	},
}
ThemePrefs.InitAll(Prefs)

-- since these prefs are per-player, I can't use the new ThemePrefs system;
-- it doesn't (yet) have support for profile-specific preferences.
local function ScreenFilterChoices()
	return { "Off", "25%", "50%", "75%", "100%" }
end
local DefaultScreenFilterPercent = 0.0 -- don't show

PlayerPrefs = {
	ScreenFilterRow = {
		Name="ScreenFilter",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = false,
		ExportOnChange = false,
		Choices = ScreenFilterChoices(),
		LoadSelections = function(self,list,pn)
			local ut = GetUserTable(pn)
			if ut then
				if not ut.Global then ut.Global = {} end
				if ut.Global.ScreenFilter then
					local val = tonumber(ut.Global.ScreenFilter)
					if     val == 0.00 then list[1] = true
					elseif val == 0.25 then list[2] = true
					elseif val == 0.50 then list[3] = true
					elseif val == 0.75 then list[4] = true
					elseif val == 1.00 then list[5] = true
					else					list[1] = true -- fallback
					end
				else
					-- no value, default to off.
					list[1] = true
					ut.Global.ScreenFilter = 0
				end
			else -- no usertable, check for envs
				local envName = "ScreenFilter"..pname(pn)
				if getenv(envName) then
					local val = getenv(envName)
					if     val == 0.00 then list[1] = true
					elseif val == 0.25 then list[2] = true
					elseif val == 0.50 then list[3] = true
					elseif val == 0.75 then list[4] = true
					elseif val == 1.00 then list[5] = true
					else					list[1] = true -- fallback
					end
				else
					-- no env set
					list[1] = true
					setenv(envName,0)
				end
			end
		end,
		SaveSelections = function(self,list,pn)
			local val
			if     list[1] then val = 000
			elseif list[2] then val = 0.25
			elseif list[3] then val = 0.50
			elseif list[4] then val = 0.75
			elseif list[5] then val = 1.00
			end

			local ut = GetUserTable(pn)
			if ut then ut.Global.ScreenFilter = val
			else -- no usertable, set env
				local envName = "ScreenFilter"..pname(pn)
				local val
				if     list[1] then val = 000
				elseif list[2] then val = 0.25
				elseif list[3] then val = 0.50
				elseif list[4] then val = 0.75
				elseif list[5] then val = 1.00
				end
				setenv(envName,val)
			end
		end,
	},
}

function ScreenFilterOptionRow()
	local t = PlayerPrefs.ScreenFilterRow
	setmetatable(t,t)
	return t
end

local NoteYPos = {
	Normal = {
		Standard = -144,
		Reverse = 128
	},
	ITG = {
		Standard = -125,
		Reverse = 129
	},
}

function GetNotePosition(posType)
	local arrowPos = ThemePrefs.Get("ArrowPosition")
	return NoteYPos[arrowPos][posType]
end

local judgeCommands = {
	Normal = { -- sm5te
		W1		= cmd(finishtweening;diffusealpha,1;zoom,1.15;glow,color("1,1,1,0.5");bounceend,0.15;zoom,1;glow,color("1,1,1,0");sleep,1;linear,0.25;diffusealpha,0),
		W2		= cmd(finishtweening;diffusealpha,1;zoom,1.15;glow,color("1,1,1,0.25");bounceend,0.15;zoom,1;glow,color("1,1,1,0");sleep,1;linear,0.25;diffusealpha,0),
		W3		= cmd(finishtweening;diffusealpha,1;zoom,1.15;glow,color("1,1,1,0.125");bounceend,0.15;zoom,1;linear,0.15;glow,color("1,1,1,0");sleep,1;linear,0.25;diffusealpha,0),
		W4		= cmd(finishtweening;diffusealpha,1;zoom,1.15;bounceend,0.15;zoom,1;linear,0.15;sleep,1;linear,0.25;diffusealpha,0),
		W5		= cmd(finishtweening;diffusealpha,1;zoom,1.15;bounceend,0.15;zoom,1;linear,0.15;sleep,1;linear,0.25;diffusealpha,0),
		Miss	= cmd(finishtweening;diffusealpha,1;zoom,1.15;bounceend,0.15;zoom,1;linear,0.15;sleep,1;linear,0.25;diffusealpha,0),
	},
	["sm-ssc"] = { -- v1.2.5
		W1		= cmd(finishtweening;y,0;diffusealpha,1;zoom,1.3;linear,0.05;zoom,1;sleep,0.8;linear,0.1;zoomy,0.5;zoomx,2;diffusealpha,0;glowblink;effectperiod,0.05;effectcolor1,color("1,1,1,0");effectcolor2,color("1,1,1,0.8")),
		W2		= cmd(finishtweening;y,0;diffusealpha,1;zoom,1.3;linear,0.05;zoom,1;sleep,0.5;linear,0.1;zoomy,0.5;zoomx,2;diffusealpha,0),
		W3		= cmd(finishtweening;y,0;diffusealpha,1;zoom,1.2;linear,0.05;zoom,1;sleep,0.5;linear,0.1;zoomy,0.5;zoomx,2;diffusealpha,0;),
		W4		= cmd(finishtweening;y,0;diffusealpha,1;zoom,1.1;linear,0.05;zoom,1;sleep,0.5;linear,0.1;zoomy,0.5;zoomx,2;diffusealpha,0;),
		W5		= cmd(finishtweening;y,0;diffusealpha,1;zoom,1.0;vibrate;effectmagnitude,1,2,2;sleep,0.5;linear,0.1;zoomy,0.5;zoomx,2;diffusealpha,0),
		Miss	= cmd(finishtweening;y,0;diffusealpha,1;zoom,1;y,-20;linear,0.8;y,20;sleep,0.5;linear,0.1;zoomy,0.5;zoomx,2;diffusealpha,0),
	},
	Classic = { -- stepmania 3.9 (without dumb shadows)
		W1		= cmd(diffusealpha,1;zoom,1.3;linear,0.05;zoom,1;sleep,0.8;linear,0;diffusealpha,0;glowblink;effectperiod,0.05;effectcolor1,color("1,1,1,0");effectcolor2,color("1,1,1,0.8")),
		W2		= cmd(diffusealpha,1;zoom,1.3;linear,0.05;zoom,1;sleep,0.8;linear,0;diffusealpha,0),
		W3		= cmd(diffusealpha,1;zoom,1.2;linear,0.05;zoom,1;sleep,0.8;linear,0;diffusealpha,0),
		W4		= cmd(diffusealpha,1;zoom,1.1;linear,0.05;zoom,1;sleep,0.8;linear,0;diffusealpha,0),
		W5		= cmd(diffusealpha,1;zoom,1.0;vibrate;effectmagnitude,4,8,8;sleep,0.8;linear,0;diffusealpha,0),
		Miss	= cmd(diffusealpha,1;zoom,1;y,-20;linear,0.8;y,20;sleep,0.8;linear,0;diffusealpha,0),
	},
	Groovy = { -- eye tee gee
		-- xxx: we don't have the even/odd rotation stuff going.
		W1		= cmd(diffusealpha,1;zoomx,1.3;zoomy,1.7;decelerate,0.1;zoom,1;sleep,1;accelerate,0.2;zoom,0;glowshift;effectperiod,0.05;effectcolor1,1,1,1,0;effectcolor2,1,1,1,0.5),
		W2		= cmd(diffusealpha,1;zoomx,1.3;zoomy,1.7;decelerate,0.1;zoom,1;sleep,1;accelerate,0.2;zoom,0),
		W3		= cmd(diffusealpha,1;zoomx,1.3;zoomy,1.7;decelerate,0.1;zoom,1;sleep,1;accelerate,0.2;zoom,0),
		W4		= cmd(diffusealpha,1;zoomx,1.3;zoomy,1.7;decelerate,0.1;zoom,1;sleep,1;accelerate,0.2;zoom,0),
		W5		= cmd(diffusealpha,1;zoomx,1.3;zoomy,1.7;decelerate,0.1;zoom,1;sleep,1;accelerate,0.2;zoom,0),
		Miss	= cmd(diffusealpha,1;zoomx,1.3;zoomy,1.7;decelerate,0.1;zoom,1;sleep,1;accelerate,0.2;zoom,0),
	}
}
function GetJudgmentCommand(tw)
	local judgeType = "Normal"
	if ThemePrefs.Get("JudgeStyle") ~= nil then
		judgeType = ThemePrefs.Get("JudgeStyle")
	end
	return judgeCommands[judgeType][tw]
end