#include "global.h"
#include "Character.h"
#include "IniFile.h"
#include "RageUtil.h"
#include "RageTextureID.h"
#include "ActorUtil.h"

RString GetRandomFileInDir( RString sDir );

Character::Character(): m_sCharDir(""), m_sCharacterID(""),
	m_sDisplayName(""), m_iPreloadRefcount(0) {}

bool Character::Load( RString sCharDir )
{
	// Save character directory
	if( sCharDir.Right(1) != "/" )
		sCharDir += "/";
	m_sCharDir = sCharDir;

	// save ID
	{
		vector<RString> as;
		split( sCharDir, "/", as );
		m_sCharacterID = as.back();
	}

	// Save attacks
	IniFile ini;
	if( !ini.ReadFile( sCharDir+"character.ini" ) )
		return false;

	for( int i=0; i<NUM_ATTACK_LEVELS; i++ )
	{
		for( int j=0; j<NUM_ATTACKS_PER_LEVEL; j++ )
			ini.GetValue( "Character", ssprintf("Level%dAttack%d",i+1,j+1), m_sAttacks[i][j] );
	}

	// get optional display name
	ini.GetValue( "Character", "DisplayName", m_sDisplayName );

	// get optional InitCommand
	RString s;
	ini.GetValue( "Character", "InitCommand", s );
	m_cmdInit = ActorUtil::ParseActorCommands( s );

	return true;
}

void Character::DemandGraphics()
{
}

void Character::UndemandGraphics()
{
}

// lua start
#include "LuaBinding.h"

/** @brief Allow Lua to have access to the Character. */ 
class LunaCharacter: public Luna<Character>
{
public:
	static int GetCharacterDir( T* p, lua_State *L )			{ lua_pushstring(L, p->m_sCharDir ); return 1; }
	static int GetCharacterID( T* p, lua_State *L )			{ lua_pushstring(L, p->m_sCharacterID ); return 1; }
	static int GetDisplayName( T* p, lua_State *L )			{ lua_pushstring(L, p->GetDisplayName() ); return 1; }

	LunaCharacter()
	{
		ADD_METHOD( GetCharacterDir );
		ADD_METHOD( GetCharacterID );
		ADD_METHOD( GetDisplayName );
	}
};

LUA_REGISTER_CLASS( Character )
// lua end

/*
 * (c) 2003 Chris Danford
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, and/or sell copies of the Software, and to permit persons to
 * whom the Software is furnished to do so, provided that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the Software and that both the above copyright notice(s) and this
 * permission notice appear in supporting documentation.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT
 * OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
 * OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */
