#ifndef NetworkSyncManager_H
#define NetworkSyncManager_H

// todo: find out what we really need here
#include "PlayerNumber.h"
#include "Difficulty.h"

#include <queue>
#include "NetworkPacket.h"
#include "NetworkProtocol.h"

class LoadingWindow; // needed for startup

/* Welcome to the new NetworkSyncManager for SM5TE. It is meant to be used only
 * with the SMO-SSC server; it will NOT work with legacy StepMania Online servers.
 * The protocol has not yet been completed, so this is subject to change.
 */

const int DefaultPort = 48040;

// this could/should probably be a map<RString,RString> instead.
struct NetServerInfo
{
	RString Name;
	RString Address;
};

enum StartupStatus
{
	StartupStatus_NotTried = 0,
	StartupStatus_Success,
	StartupStatus_Failed,
	NUM_StartupStatus
};

struct LoginData
{
	int Side;
	RString Username;
	RString Password;
};

// old shit!
const int NETNUMTAPSCORES=8;

struct EndOfGame_PlayerData
{
	int name;
	int score;
	int grade;
	Difficulty difficulty;
	int tapScores[NETNUMTAPSCORES];	//This will be a const soon enough
	RString playerOptions;
};

// ok pay attention starting here again; this is old, but important.
class EzSockets;

/** @brief Uses ezsockets for primitive song syncing and score reporting. */
class NetworkSyncManager 
{
public:
	NetworkSyncManager( LoadingWindow *ld = NULL );
	~NetworkSyncManager();

	void SendPacket(NetworkPacket *p);

	bool TryConnection( const RString& serverAddr );
	bool Connect( const RString& addr, unsigned short port );
	void OnConnect();
	void CloseConnection();

	void Update( float fDeltaTime );

	RString GetServerName();
	int GetSMOnlineSalt();
	RString MD5Hex( const RString &sInput );

	void DisplayStartupStatus();	// Notify user if connect attempt was successful or not.

	bool m_NetConnected;	// previously useSMserver
	bool m_OnlineServer;	// previously isSMOnline

	// everything below this line is up for grabs. -freem

	bool isSMOLoggedIn[NUM_PLAYERS]; // per-side thing. that's dumb.

	// legacy-specific:
	void ReportNSSOnOff( int i );	// Report song selection screen on/off
	// If "useSMserver" then send score to server
	void ReportScore( int playerID, int step, int score, int combo, float offset );
	void ReportSongOver();
	void ReportStyle(); // Report style, players, and names
	void StartRequest( short position );	// Request a start; Block until granted.

	// (Legacy) SMOnline stuff;
	void SendSMOnline();
	NetworkPacket	m_SMOnlinePacket;

	int m_playerLife[NUM_PLAYERS];	// Life (used for sending to server)

	// (legacy) user list:
	vector<int> m_PlayerStatus;
	int m_ActivePlayers;
	vector<int> m_ActivePlayer;
	vector<RString> m_PlayerNames;

	// (Legacy) Used for ScreenNetEvaluation
	vector<EndOfGame_PlayerData> m_EvalPlayerData;

	// (Legacy but likely common) Used for chatting
	void SendChat(const RString& message);
	RString m_WaitingChat;
	RString m_sChatText;	// chatroom text buffer

	// (Legacy) Used for options
	void ReportPlayerOptions();

	// (Legacy) Used for song checking/changing
	RString m_sMainTitle;
	RString m_sArtist;
	RString m_sSubTitle;
	int m_iSelectMode;
	void SelectUserSong();

private:
	void CheckCommandLine(); // previously StartUp
	bool GetServerStatus(); // determines if joinable or not
	bool SendHello();
	bool SendLogin(int iPlayerSide, RString sUsername, RString sPlainPassword);

	// todo: make a SendBlocking? idk -f

	void ProcessInput();
	void HandleCommand(int command);

	// core of the networking experience
	EzSockets *m_PlayerSocket; // previously NetPlayerClient
	NetworkPacket m_Packet;

	RString m_ServerVersion;
	RString m_ServerName;
	int m_ServerProtocolVersion;

	int m_StartupStatus;	// Used to see if attempt was successful or not.
	int m_iSalt;	// Legacy, but keep it around just in case.
	// everything after this is hearsay -freem
};

extern NetworkSyncManager *NSMAN;
 
#endif
 
/*
 * (c) 2012 AJ Kelly
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, and/or sell copies of the Software, and to permit persons to
 * whom the Software is furnished to do so, provided that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the Software and that both the above copyright notice(s) and this
 * permission notice appear in supporting documentation.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT
 * OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
 * OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */
