/* libmpg123 is available from http://www.mpg123.de/ */

#include "global.h"
#include "RageSoundReader_MP3.h"
#include "RageLog.h"
#include "RageUtil.h"

#include <cstdio>
#include <cerrno>
#include <map>

// [TE] TODO XXX: vc builds need the mpg123.h from ports/MSVC++/ folder.
#include <mpg123.h>

// [TE] the lib file should have been exported to extern/mpg123/lib/.
/*
#ifdef _MSC_VER
#pragma comment(lib, "libmpg123.lib")
#endif //_MSC_VER
*/

/** RageSoundReader_MP3 *******************************************************/

// Handle first-stage decoding: extracting the MP3 frame data.
// see play_frame in mpg123.c (app)
int RageSoundReader_MP3::do_mpg123_frame_decode( bool headers_only )
{
	unsigned char *audio;
	int mc;
	size_t bytes;
	// the first call will not decode anything; it will return MPG123_NEW_FORMAT
	// framenum is just "current frame offset"
	mc = mpg123_decode_frame(mh, &m_frameNum, &audio, &bytes);
	if(bytes)
	{
		// do stuff, namely checking the number of frames remaining,
		// and flushing the data.
		if( m_frameNum > -1 ) --m_framesLeft;
	}

	// error handling, special actions
	if(mc != MPG123_OK)
	{
		if(mc == MPG123_ERR || mc == MPG123_DONE)
		{
			if(mc == MPG123_ERR)
			{
				//error1("...in decoding next frame: %s", mpg123_strerror(mh));
			}
			return 0;
		}
		if(mc == MPG123_NO_SPACE)
		{
			SetError("Not enough output space.");
			return -1;
		}
		if(mc == MPG123_NEW_FORMAT)
		{
			long rate;
			int format;
			mpg123_getformat(mh, &rate, &Channels, &format);

			// not implemented yet
			//reset_audio(rate, Channels, format);
		}
	}

	return 1;
}

/* Seek to a byte in the file. If you're going to put the file position back
 * when you're done, and not going to read any data,
 * you don't have to use this. */
int RageSoundReader_MP3::seek_stream_to_byte( int byte )
{
	if( m_pFile->Seek(byte) == -1 )
	{
		SetError( strerror(errno) );
		return 0;
	}

	// do stuff


	return 1;
}

RageSoundReader_MP3::RageSoundReader_MP3()
{
	int ret;
	if(mpg123_init() != MPG123_OK)
	{
		// can't open mpg123! that's not good.
		return;
	}

	// apparently i'm supposed to do some shit with params here?

	mh = mpg123_new(NULL, &ret);

	if( mh == NULL )
	{
		// bad news brown
		RString sError = ssprintf("Unable to create mpg123 handle: %s\n", mpg123_plain_strerror(ret));
		LOG->Warn( "%s",sError.c_str() );
	}

	m_frameNum = 0;
	m_framesLeft = -1;
	m_bAccurateSync = false;
}

RageSoundReader_MP3::~RageSoundReader_MP3()
{
	mpg123_close(mh);
	mpg123_delete(mh);
	mpg123_exit();
}

// OPEN MP3 FILE!! this is step fuckin' 1
RageSoundReader_FileReader::OpenResult RageSoundReader_MP3::Open( RageFileBasic *pFile )
{
	m_pFile = pFile;

	// mpg123_open_feed(mh)
	//if( mpg123_open(mh,m_pFile->GetDisplayPath()) != MPG123_OK )
	if( mpg123_open_handle(mh,m_pFile) != MPG123_OK )
	{
		SetError( ssprintf("Cannot open %s: %s",m_pFile->GetDisplayPath().c_str(),mpg123_strerror(mh)) );
		return OPEN_FATAL_ERROR;
	}

	if(mpg123_scan(mh) == MPG123_ERR)
	{
		SetError(ssprintf("Cannot scan %s: %s",m_pFile->GetDisplayPath().c_str(),mpg123_strerror(mh)));
		return OPEN_FATAL_ERROR;
	}

	long rate = 0;
	int  channels = 0, encoding = 0;
	if( mpg123_getformat(mh, &rate, &channels, &encoding) != MPG123_OK )
	{
		SetError(ssprintf("Cannot get format of %s: %s",m_pFile->GetDisplayPath().c_str(),mpg123_strerror(mh)));
		return OPEN_FATAL_ERROR;
	}
	Channels = channels;
	SampleRate = rate;

	// todo: handle rate here

	int ret = do_mpg123_frame_decode();
	// handle mpg123 errors, freem
	/*
	switch(ret)
	{
	case 0:
		SetError( "Failed to read any data at all" );
		return OPEN_UNKNOWN_FILE_FORMAT;
	case -1:
		SetError( GetError() + " (not an MP3 stream?)" );
		return OPEN_UNKNOWN_FILE_FORMAT;
	}
	*/

	/* Store the bitrate of the frame we just got? */
	int infoRet = mpg123_info(mh,mi);
	SampleRate = mi->rate;

	// length fixing if -1?

	return OPEN_OK;
}


RageSoundReader_MP3 *RageSoundReader_MP3::Copy() const
{
	RageSoundReader_MP3 *ret = new RageSoundReader_MP3;

	ret->m_pFile = m_pFile->Copy();
	ret->m_pFile->Seek( 0 );
	ret->m_bAccurateSync = m_bAccurateSync;
	ret->mi = mi;
	ret->SampleRate = SampleRate;
	ret->Channels = Channels;

	return ret;
}

int RageSoundReader_MP3::Read( float *buf, int iFrames )
{
	size_t bytesRead = 0;
	int result = mpg123_read(mh,(unsigned char *)buf,(size_t)iFrames,&bytesRead);

	switch (result)
	{
		case MPG123_DONE:
			return END_OF_FILE;
		case MPG123_OK:
			return (int)bytesRead;
	}
	return ERROR;
}

/* Methods of seeking:
 *
 * 1. We can jump based on a TOC.  We potentially have two; the Xing TOC and our
 *    own index.  The Xing TOC is only accurate to 1/256th of the file size,
 *    so it's unsuitable for precise seeks.  Our own TOC is byte-accurate.
 *    (SetPosition_toc)
 *
 * 2. We can jump based on the bitrate.  This is fast, but not accurate.
 *    (SetPosition_estimate)
 *
 * 3. We can seek from any position to any higher position by decoding headers.
 *    (SetPosition_hard)
 *
 * Both 1 and 2 will leave the position behind the actual requested position; 
 * combine them with 3 to catch up. Never do 3 alone in "fast" mode, since it's
 * slow if it ends up seeking from the beginning of the file.  Never do 2 in
 * "precise" mode.
 */

/* Returns actual position on success, 0 if past EOF, -1 on error. */
int RageSoundReader_MP3::SetPosition_toc( int iFrame, bool Xing )
{
	return 1;
}

int RageSoundReader_MP3::SetPosition_hard( int iFrame )
{
	return 1;
}

/* Do a seek based on the bitrate. */
int RageSoundReader_MP3::SetPosition_estimate( int iFrame )
{
	/* This doesn't leave us accurate. */

	return 1;
}

int RageSoundReader_MP3::SetPosition( int iFrame )
{
	if( m_bAccurateSync )
	{
		/* Seek using our own internal (accurate) TOC. */
		int ret = SetPosition_toc( iFrame, false );
		if( ret <= 0 )
			return ret; /* it set the error */
		
		/* Align exactly. */
		return SetPosition_hard( iFrame );
	}
	else
	{
		/* Rewinding is always fast and accurate, and SetPosition_estimate is bad at 0. */
		if( !iFrame )
		{
			// rewind
			return 1; /* ok */
		}

		// return the relevant SetPosition(iFrame) instead
		return 1;
	}
}

bool RageSoundReader_MP3::SetProperty( const RString &sProperty, float fValue )
{
	if( sProperty == "AccurateSync" )
	{
		m_bAccurateSync = (fValue > 0.001f);
		return true;
	}

	return RageSoundReader_FileReader::SetProperty( sProperty, fValue );
}

int RageSoundReader_MP3::GetNextSourceFrame() const
{
	return 1;
}

// [TE] xxx: expects milliseconds; currently returns samples.
int RageSoundReader_MP3::GetLengthInternal( bool fast )
{
	off_t estLength, scanLength;
	estLength = mpg123_length(mh);
	if(fast)
		return estLength;
	mpg123_scan(mh);
	scanLength = mpg123_length(mh);
	return scanLength;
}

int RageSoundReader_MP3::GetLengthConst( bool fast ) const
{
	RageSoundReader_MP3 *pCopy = this->Copy();

	int iLength = pCopy->GetLengthInternal( fast );

	delete pCopy;
	return iLength;
}

/*
 * Copyright (c) 2012 freem incorporado
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

