/* ScreenMapControllers2 - Maps device input to game buttons. */
// NEW VERSION 2012 04 -freem

#ifndef SCREEN_MAP_CONTROLLERS2_H
#define SCREEN_MAP_CONTROLLERS2_H

#include "ScreenWithMenuElements.h"
#include "BitmapText.h"
#include "InputMapper.h"
#include "ActorScroller.h"
#include "RageSound.h"
#include "EnumHelper.h"
#include "ThemeMetric.h"

/* old inputmapper consts:
const int NUM_GAME_TO_DEVICE_SLOTS	= 5;	// five device inputs may map to one game input
const int NUM_SHOWN_GAME_TO_DEVICE_SLOTS = 3;
const int NUM_USER_GAME_TO_DEVICE_SLOTS = 2;
*/

/* ScreenMapControllers2: the freem edition
 * There are two types of controls that matter in StepMania:
 * Menu/System controls and Game controls.
 *
 * [Menu] Up, Down, Left, Right, Start, Select, Back, Operator
 * The game controls change by gametype, but they use custom buttons.
 *
 * {Choices} Map All,Menu,Game,Default,"Save & Exit"
 * Map All allows the player to map all the choices at once.
 * Menu and Game edit their respective mappings. Game is a bit more complex.
 * Default is there if you fuck up. "Save & Exit" is obvious.
 *
 * Only one set of controls is allowed per player for all controls.
 * For this reason, players should be allowed to have distinct playstyles (e.g
 * index, spread, controller, etc.) without having to re-map the keys each time.
 * This may require per-Profile key mappings.
 * Some of this (e.g. solo) is handled in different gametypes.
 *
 * When editing Game mappings, there will be a list of options corresponding to
 * the specific style inputs. For example, dance will have "normal" and "solo",
 * while pump will have "normal" and "halfdouble".
 */

class ScreenMapControllers2 : public ScreenWithMenuElements
{
public:
	ScreenMapControllers2();
	virtual void Init();
	virtual void BeginScreen();
	//virtual void EndScreen();

	virtual void Update( float fDeltaTime );
	virtual void Input( const InputEventPlus &input );

	virtual void MenuUp( const InputEventPlus &input );
	virtual void MenuDown( const InputEventPlus &input );
	virtual void MenuStart( const InputEventPlus &input );
	virtual void TweenOnScreen();

	//int GetNumInputs(){ return m_KeysToMap.size(); }

	// Lua
	//virtual void PushSelf( lua_State *L );

protected:
	virtual void HandleMessage( const Message &msg );

	void ChangeInputSelection(int iDir);
	void UpdateMappingScrollers();

	void BeforeChangeFocus();
	void AfterChangeFocus();
	void Refresh();

	RageTimer m_WaitingForPress;
	DeviceInput m_DeviceIToMap;

	/*
	struct KeyToMap
	{
		GameButton	m_GameButton;
		BitmapText*	m_textLabel;
	};
	vector<KeyToMap> m_KeysToMap;
	*/

	BitmapText m_textDevices;
	//vector<BitmapText> m_textMappingLabels[NUM_PLAYERS];
	//BitmapText m_textAddMapping[NUM_PLAYERS];

	RageSound m_soundChange;
	RageSound m_soundDelete;
};

#endif

/*
 * copyfreem 2000
 * Copyright (c) 2012 freemco
 * [Authors: freem]
 * All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, and/or sell copies of the Software, and to permit persons to
 * whom the Software is furnished to do so, provided that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the Software and that both the above copyright notice(s) and this
 * permission notice appear in supporting documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT
 * OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
 * OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */
