/* Area for testing. Throw whatever you're working on in here. If you don't
 * want stuff in here to be wiped out by the next guy who works on something,
 * make a separate screen; this one's just a scratchpad.
 *
 * AJ says: This is a decent template for a Screen. You should probably use it
 * for reference if creating an entirely new screen. You'll need to handle a bit
 * more for a typical screen, however.
 */

#include "global.h"
#include "ScreenSandbox.h"
#include "ThemeManager.h"
#include "RageDisplay.h"
#include "RageLog.h"

// 2012/05/11: testing TextBox
#include "ActorUtil.h"
#include "RageInput.h"
#include "InputEventPlus.h"

REGISTER_SCREEN_CLASS( ScreenSandbox );

void ScreenSandbox::Init()
{
	Screen::Init();

	m_iSelection = 0;

	m_TextBox.SetName("TextBox");
	m_TextBox.Load("TextBoxTest");
	LOAD_ALL_COMMANDS_AND_SET_XY( m_TextBox );
	this->AddChild( &m_TextBox );
}

void ScreenSandbox::HandleScreenMessage( const ScreenMessage SM )
{
	Screen::HandleScreenMessage( SM );
}

void ScreenSandbox::Input( const InputEventPlus &input )
{
	if( m_TextBox.GetInputFocus() )
	{
		if( input.DeviceI == DeviceInput(DEVICE_KEYBOARD, KEY_BACK) )
		{
			switch( input.type )
			{
				case IET_FIRST_PRESS:
				case IET_REPEAT:
					m_TextBox.Backspace();
				default:
					break;
			}
		}
		else if( input.DeviceI == DeviceInput(DEVICE_KEYBOARD, KEY_ENTER))
		{
			// change answer
			if( input.type == IET_FIRST_PRESS )
			{
				m_TextBox.End(false);
			}
		}
		else if( input.DeviceI == DeviceInput(DEVICE_KEYBOARD, KEY_ESC))
		{
			// cancel answer
			if( input.type == IET_FIRST_PRESS )
			{
				m_TextBox.End(true);
			}
		}
		else if( input.type == IET_FIRST_PRESS )
		{
			wchar_t c = INPUTMAN->DeviceInputToChar(input.DeviceI,true);
			if( c >= L' ' ) 
			{
				m_TextBox.TryAppendToAnswer( WStringToRString(wstring()+c) );
			}
		}
	}
	else
	{
		if( input.DeviceI == DeviceInput(DEVICE_KEYBOARD, KEY_ENTER) &&
			input.type == IET_FIRST_PRESS )
		{
			m_TextBox.SetInputFocus(true);
		}
	}

	Screen::Input( input );
}

void ScreenSandbox::Update( float fDeltaTime )
{
	Screen::Update(fDeltaTime);
	m_TextBox.UpdateAnswerText();
}

void ScreenSandbox::DrawPrimitives()
{
	Screen::DrawPrimitives();
}

/*
 * (c) 2004 Chris Danford
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, and/or sell copies of the Software, and to permit persons to
 * whom the Software is furnished to do so, provided that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the Software and that both the above copyright notice(s) and this
 * permission notice appear in supporting documentation.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT
 * OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
 * OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */
