#include "global.h"
#include "ScreenSelectGame.h"
#include "Game.h"
#include "ScreenManager.h"
#include "StepMania.h"
#include "GameManager.h"
#include "Foreach.h"
#include "ThemeManager.h"
#include "InputEventPlus.h"

static void GameChoices( vector<const Game*> &aGames, vector<RString> &out )
{
	FOREACH( const Game*, aGames, g )
	{
		RString sGameName = (*g)->m_szName;
		// [TE] don't let the player play lights.
		if(sGameName != "lights") out.push_back( sGameName );
	}
}

REGISTER_SCREEN_CLASS( ScreenSelectGame );
void ScreenSelectGame::Init()
{
	// init our variables
	m_iCurChoice = 0;
	GAMEMAN->GetEnabledGames( m_aGames );
	GameChoices(m_aGames,m_sGames);

	LOOP_SCROLLER.Load( m_sName, "LoopScroller" );
	SCROLLER_SECONDS_PER_ITEM.Load( m_sName, "ScrollerSecondsPerItem" );
	SCROLLER_NUM_ITEMS_TO_DRAW.Load( m_sName, "ScrollerNumItemsToDraw" );
	SCROLLER_TRANSFORM.Load( m_sName, "ScrollerTransform" );

	// hand things off to SWME
	ScreenWithMenuElements::Init();

	// then back to us again
	m_vsprScroll.resize( m_sGames.size() );

	{
		// load scroller choices in here
		for( unsigned g=0; g < m_sGames.size(); g++ )
		{
			RString sGameName = m_sGames[g];
			LuaThreadVariable var( "GameName", LuaReference::Create(sGameName) );
			m_vsprScroll[g].Load( THEME->GetPathG(m_sName,"Scroll") );
			RString sName = "Scroll" "Choice" + sGameName;
			m_vsprScroll[g]->SetName( sName );
			m_Scroller.AddChild( m_vsprScroll[g] );
		}
	}

	// set up the game scroller. (gonna be a lot of duping from SelMaster here)
	m_Scroller.SetLoop( LOOP_SCROLLER );
	m_Scroller.SetNumItemsToDraw( SCROLLER_NUM_ITEMS_TO_DRAW );
	m_Scroller.Load2();
	m_Scroller.SetTransformFromReference( SCROLLER_TRANSFORM );
	m_Scroller.SetSecondsPerItem( SCROLLER_SECONDS_PER_ITEM );
	m_Scroller.SetNumSubdivisions( 1 );
	m_Scroller.SetName( "Scroller" );
	LOAD_ALL_COMMANDS_AND_SET_XY( m_Scroller );
	this->AddChild( &m_Scroller );

	// xxx: this should be in something like BeginScreen idfk
	m_vsprScroll[m_iCurChoice]->PlayCommand("GainFocus");
}

void ScreenSelectGame::Update( float fDelta )
{
	ScreenWithMenuElements::Update( fDelta );
}

// movement stuff.
void ScreenSelectGame::Move(int dir)
{
	int oldChoice = m_iCurChoice;
	if( dir < 0 )
	{
		if( m_iCurChoice == 0 )
			m_iCurChoice = m_sGames.size()-1;
		else
			m_iCurChoice -= 1;
	}
	else if(dir > 0)
	{
		if( (unsigned)m_iCurChoice == m_sGames.size()-1 )
			m_iCurChoice = 0;
		else
			m_iCurChoice += 1;
	}

	ChangeSelection(dir, oldChoice);
}

void ScreenSelectGame::ChangeSelection(int dir, int oldChoice)
{
	m_Scroller.SetDestinationItem( (float)m_iCurChoice );

	m_vsprScroll[oldChoice]->PlayCommand("LoseFocus");
	m_vsprScroll[m_iCurChoice]->PlayCommand("GainFocus");
}

void ScreenSelectGame::MenuLeft( const InputEventPlus &input )
{
	if( m_fLockInputSecs > 0 )
		return;
	if( input.type == IET_RELEASE )
		return;

	Move(-1);
}
void ScreenSelectGame::MenuRight( const InputEventPlus &input )
{
	if( m_fLockInputSecs > 0 )
		return;
	if( input.type == IET_RELEASE )
		return;

	Move(1);
}
void ScreenSelectGame::MenuUp( const InputEventPlus &input )
{
	if( m_fLockInputSecs > 0 )
		return;
	if( input.type == IET_RELEASE )
		return;

	Move(-1);
}
void ScreenSelectGame::MenuDown( const InputEventPlus &input )
{
	if( m_fLockInputSecs > 0 )
		return;
	if( input.type == IET_RELEASE )
		return;

	Move(1);
}

void ScreenSelectGame::MenuStart( const InputEventPlus &input )
{
	if( input.type != IET_FIRST_PRESS )
		return;
	if( m_fLockInputSecs > 0 )
		return;

	// Load the new game
	StepMania::ChangeCurrentGame( m_aGames[m_iCurChoice] );
	THEME->ReloadMetrics();

	StartTransitioningScreen( SM_GoToNextScreen ); // and get out.
}

void ScreenSelectGame::MenuBack( const InputEventPlus &input )
{
	if( input.type != IET_FIRST_PRESS )
		return;

	Cancel( SM_GoToPrevScreen );
}

/*
 * copyfreem 2000
 * Copyright (c) 2012 freemco
 * [Authors: freem]
 * All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, and/or sell copies of the Software, and to permit persons to
 * whom the Software is furnished to do so, provided that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the Software and that both the above copyright notice(s) and this
 * permission notice appear in supporting documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT
 * OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
 * OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */
