#ifndef SCREEN_SERVER_CONNECT_H
#define SCREEN_SERVER_CONNECT_H

#include "ScreenWithMenuElements.h"
#include "ScreenSelectMaster.h"
#include "JsonUtil.h"

struct ServerEntry
{
	RString name;
	RString address;

	ServerEntry(): name(""), address("") {}
	ServerEntry(RString _name, RString _addr): name(_name), address(_addr) {}
};

class ScreenServerConnect : public ScreenWithMenuElements
{
public:
	ScreenServerConnect();
	virtual void Init();
	virtual void BeginScreen();

	virtual void MenuUp( const InputEventPlus &input );
	virtual void MenuDown( const InputEventPlus &input );
	virtual void MenuStart( const InputEventPlus &input );
	virtual void MenuSelect( const InputEventPlus &input );
	virtual void MenuBack( const InputEventPlus &input );

	virtual void TweenOnScreen();
	virtual void TweenOffScreen();

	virtual void HandleScreenMessage( const ScreenMessage SM );
	virtual bool AllowLateJoin() const { return false; }

	// Lua
	//virtual void PushSelf( lua_State *L );

protected:
	int m_iChoice; // shared selection

	ThemeMetric<bool>	WRAP_SCROLLER;
	ThemeMetric<bool>	LOOP_SCROLLER;
	ThemeMetric<bool>	ALLOW_REPEATING_INPUT;
	ThemeMetric<float>	SCROLLER_SECONDS_PER_ITEM;
	ThemeMetric<float>	SCROLLER_NUM_ITEMS_TO_DRAW;
	ThemeMetric<LuaReference> SCROLLER_TRANSFORM;
	ThemeMetric<int>	SCROLLER_SUBDIVISIONS;

	vector<GameCommand>	m_aGameCommands;
	vector<AutoActor> m_vScrollList;
	ActorScroller	m_ServerScroller;

	virtual int GetSelectionIndex( PlayerNumber pn );
	virtual void UpdateSelectableChoices();

	bool Move( PlayerNumber pn, MenuDir dir );
	bool ChangeSelection( PlayerNumber pn, MenuDir dir, int iNewChoice );
	virtual bool ProcessMenuStart( PlayerNumber pn ) { return true; }

	Json::Value m_jServerList;				// server.json list
	vector<ServerEntry> m_ServerEntries;	// servers for scroller
	bool LoadServersFromJson();
	bool AddServerToList(RString sName, RString sAddr);
	bool SaveServerList();

	RString m_sNewServerName;
	RString m_sNewServerAddress;
	void ResetNewServerValues(){ m_sNewServerName = ""; m_sNewServerAddress = ""; }

	GameButton m_TrackingRepeatingInput;
};

#endif

/*
 * (c) 2012 AJ Kelly
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, and/or sell copies of the Software, and to permit persons to
 * whom the Software is furnished to do so, provided that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the Software and that both the above copyright notice(s) and this
 * permission notice appear in supporting documentation.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT
 * OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
 * OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */
