#include "global.h"
#include "Foreach.h"
#include "ScreenServerLogin.h"
#include "NetworkSyncManager.h"
#include "ScreenManager.h"
#include "InputEventPlus.h"
#include "GameState.h"
#include "PlayerState.h"
#include "ActorUtil.h"
#include "LocalizedString.h"

// todo: add localized strings here
//static LocalizedString LOCAL_STRING_NAME( "ScreenServerLogin","" );
static LocalizedString LOGIN_FAILED_GENERIC( "ScreenServerLogin","LoginFailed" );
static LocalizedString LOGIN_FAILED_BLANK_NAME( "ScreenServerLogin","LoginFailedBlankName" );
static LocalizedString LOGIN_FAILED_BLANK_PASSWORD( "ScreenServerLogin","LoginFailedBlankPassword" );

REGISTER_SCREEN_CLASS( ScreenServerLogin );

ScreenServerLogin::ScreenServerLogin()
{
	m_iSelectionIndex = 0;
	m_iPrevSelectionIndex = 0;
	FOREACH_PlayerNumber(p)
		m_bLoggedIn[p] = false;
}

ScreenServerLogin::~ScreenServerLogin()
{
	// close screen down here... not sure what I'd need to do.
}

void ScreenServerLogin::Init()
{
	ScreenWithMenuElements::Init();

	LoginStatusErrorColor	.Load( m_sName,"LoginStatusErrorColor" );
	LoginStatusSuccessColor	.Load( m_sName,"LoginStatusSuccessColor" );

	FOREACH_EnabledPlayer( p )
	{
		// Username Textbox
		{
			RString sElement = "UserName" + ssprintf("P%d",p+1);
			m_tbUserName[p].SetName( sElement );
			m_tbUserName[p].Load( m_sName+" "+sElement );
			this->AddChild( &m_tbUserName[p] );
			LOAD_ALL_COMMANDS_AND_SET_XY( m_tbUserName[p] );
		}

		// Password Textbox
		{
			RString sElement = "Password" + ssprintf("P%d",p+1);
			m_tbPassword[p].SetName( sElement );
			m_tbPassword[p].Load( m_sName+" "+sElement );
			this->AddChild( &m_tbPassword[p] );
			LOAD_ALL_COMMANDS_AND_SET_XY( m_tbPassword[p] );
		}

		// Login item
		{
			RString sElement = "Login" + ssprintf("P%d",p+1);
			m_sLoginItem[p].Load( THEME->GetPathG(m_sName,sElement) );
			m_sLoginItem[p]->SetName( sElement );
			this->AddChild( m_sLoginItem[p] );
			LOAD_ALL_COMMANDS_AND_SET_XY( m_sLoginItem[p] );
		}

		// Login status
		{
			//m_tLoginStatus
			RString sElement = "LoginStatus" + ssprintf("P%d",p+1);
			m_tLoginStatus[p].LoadFromFont( THEME->GetPathF(m_sName, "LoginStatus") );
			m_tLoginStatus[p].SetName( sElement );
			this->AddChild( &m_tLoginStatus[p] );
			LOAD_ALL_COMMANDS_AND_SET_XY( m_tLoginStatus[p] );
		}
	}

	// if only the second player is joined, we should set the
	// selection indices properly.
	if( GAMESTATE->GetNumSidesJoined() == 1 && !GAMESTATE->m_bSideIsJoined[PLAYER_1] )
	{
		m_iSelectionIndex = 3;
		m_iPrevSelectionIndex = 3;
	}
}

void ScreenServerLogin::BeginScreen()
{
	UpdateItemFocus();
	ScreenWithMenuElements::BeginScreen();
}

void ScreenServerLogin::Update( float fDelta )
{
	ScreenWithMenuElements::Update(fDelta);
}

void ScreenServerLogin::Input( const InputEventPlus &input )
{
	bool bTextBoxGotInput = false;
	if( AnyTextBoxHasFocus() )
	{
		// handle any possible textbox input.
		TextBox *tb = TextBoxWithFocus();
		bTextBoxGotInput = tb->Input(input);
	}

	// pass down if we're not handling it.
	if( !bTextBoxGotInput )
		ScreenWithMenuElements::Input(input);
}

void ScreenServerLogin::HandleScreenMessage( const ScreenMessage SM )
{
	if( SM == SM_BeginFadingOut )	// Screen is starting to tween out.
	{
		ASSERT( !IsTransitioning() );
		StartTransitioningScreen( SM_GoToNextScreen );
	}

	ScreenWithMenuElements::HandleScreenMessage(SM);
}

void ScreenServerLogin::HandleMessage( const Message &msg )
{
	// todo: write me
	ScreenWithMenuElements::HandleMessage(msg);
}

bool ScreenServerLogin::AnyTextBoxHasFocus()
{
	return ( m_tbUserName[PLAYER_1].GetInputFocus() ||
		m_tbPassword[PLAYER_1].GetInputFocus() ||
		m_tbUserName[PLAYER_2].GetInputFocus() ||
		m_tbPassword[PLAYER_2].GetInputFocus() );
}

TextBox* ScreenServerLogin::TextBoxWithFocus()
{
	switch(m_iSelectionIndex)
	{
		case 0: return &m_tbUserName[PLAYER_1];
		case 1: return &m_tbPassword[PLAYER_1];
		case 3: return &m_tbUserName[PLAYER_2];
		case 4: return &m_tbPassword[PLAYER_2];
		default: return NULL;
	}
	return NULL;
}

void ScreenServerLogin::UpdateItemFocus()
{
	switch(m_iPrevSelectionIndex)
	{
		case 0: m_tbUserName[PLAYER_1].LoseFocus(); break;
		case 1: m_tbPassword[PLAYER_1].LoseFocus(); break;
		case 2: m_sLoginItem[PLAYER_1]->PlayCommand("LoseFocus"); break;
		case 3: m_tbUserName[PLAYER_2].LoseFocus(); break;
		case 4: m_tbPassword[PLAYER_2].LoseFocus(); break;
		case 5: m_sLoginItem[PLAYER_2]->PlayCommand("LoseFocus"); break;
	}
	switch(m_iSelectionIndex)
	{
		case 0: m_tbUserName[PLAYER_1].GainFocus(); break;
		case 1: m_tbPassword[PLAYER_1].GainFocus(); break;
		case 2: m_sLoginItem[PLAYER_1]->PlayCommand("GainFocus"); break;
		case 3: m_tbUserName[PLAYER_2].GainFocus(); break;
		case 4: m_tbPassword[PLAYER_2].GainFocus(); break;
		case 5: m_sLoginItem[PLAYER_2]->PlayCommand("GainFocus"); break;
	}
}

/* I would like to make this up to the themer, but I need to get this code
 * done before I can even think about theming, so here's how it maps out
 * at the moment:
 * 0 = Username P1; 1 = Password P1; 2 = Login P1;
 * 3 = Username P2; 4 = Password P2; 5 = Login P2;
 */
void ScreenServerLogin::MenuUp( const InputEventPlus &input )
{
	if( !GAMESTATE->m_bSideIsJoined[input.pn] )
		return;

	m_iPrevSelectionIndex = m_iSelectionIndex;
	switch(m_iSelectionIndex)
	{
		case 0: m_iSelectionIndex = 2; break;
		case 1: m_iSelectionIndex = 0; break;
		case 2: m_iSelectionIndex = 1; break;
		case 3: m_iSelectionIndex = 5; break;
		case 4: m_iSelectionIndex = 3; break;
		case 5: m_iSelectionIndex = 4; break;
		default: break;
	}
	UpdateItemFocus();
}
void ScreenServerLogin::MenuDown( const InputEventPlus &input )
{
	if( !GAMESTATE->m_bSideIsJoined[input.pn] )
		return;

	m_iPrevSelectionIndex = m_iSelectionIndex;
	switch(m_iSelectionIndex)
	{
		case 0: m_iSelectionIndex = 1; break;
		case 1: m_iSelectionIndex = 2; break;
		case 2: m_iSelectionIndex = 0; break;
		case 3: m_iSelectionIndex = 4; break;
		case 4: m_iSelectionIndex = 5; break;
		case 5: m_iSelectionIndex = 3; break;
		default: break;
	}
	UpdateItemFocus();
}

// xxx: MenuLeft and MenuRight are the same in my proposed layout.
void ScreenServerLogin::MenuSideInput( const InputEventPlus &input )
{
	// only do this if the other player is joined
	if( GAMESTATE->m_bSideIsJoined[ OPPOSITE_PLAYER[input.pn] ] )
	{
		m_iPrevSelectionIndex = m_iSelectionIndex;
		switch(m_iSelectionIndex)
		{
			case 0: m_iSelectionIndex = 3; break;
			case 1: m_iSelectionIndex = 4; break;
			case 2: m_iSelectionIndex = 5; break;
			case 3: m_iSelectionIndex = 0; break;
			case 4: m_iSelectionIndex = 1; break;
			case 5: m_iSelectionIndex = 2; break;
			default: break;
		}
		UpdateItemFocus();
	}
}

void ScreenServerLogin::MenuLeft( const InputEventPlus &input )
{
	if( !GAMESTATE->m_bSideIsJoined[input.pn] )
		return;

	MenuSideInput(input);
}
void ScreenServerLogin::MenuRight( const InputEventPlus &input )
{
	if( !GAMESTATE->m_bSideIsJoined[input.pn] )
		return;

	MenuSideInput(input);
}

bool ScreenServerLogin::TryLogin( PlayerNumber pn, RString &sStatusOut )
{
	if( m_tbUserName[pn].GetRstrAnswer().empty() )
	{
		sStatusOut = LOGIN_FAILED_BLANK_NAME;
		return false;
	}

	if( m_tbPassword[pn].GetRstrAnswer().empty() )
	{
		sStatusOut = LOGIN_FAILED_BLANK_PASSWORD;
		return false;
	}

	// this function is private:
	//return NSMAN->SendLogin( pn, m_tbUserName[pn].GetRstrAnswer(), m_tbPassword[pn].GetRstrAnswer() );

	sStatusOut = LOGIN_FAILED_GENERIC;
	return false;
}

void ScreenServerLogin::SetStatusText( PlayerNumber pn, RString sText )
{
	m_tLoginStatus[pn].SetText(sText);
}

void ScreenServerLogin::MenuStart( const InputEventPlus &input )
{
	if( !GAMESTATE->m_bSideIsJoined[input.pn] )
		return;
	if( input.type != IET_FIRST_PRESS )
		return;
	if( m_fLockInputSecs > 0 )
		return;

	// todo: only make the proper player's start button activate the next step?
	switch(m_iSelectionIndex)
	{
		case 0: m_tbUserName[PLAYER_1].SetInputFocus(true); break;
		case 1: m_tbPassword[PLAYER_1].SetInputFocus(true); break;
		case 2:
			{
				RString sStatus;
				m_bLoggedIn[PLAYER_1] = TryLogin(PLAYER_1,sStatus);
				SetStatusText(PLAYER_1,sStatus);
			}
			break;
		case 3: m_tbUserName[PLAYER_2].SetInputFocus(true); break;
		case 4: m_tbPassword[PLAYER_2].SetInputFocus(true); break;
		case 5:
			{
				RString sStatus;
				m_bLoggedIn[PLAYER_2] = TryLogin(PLAYER_2,sStatus);
				SetStatusText(PLAYER_2,sStatus);
			}
			break;
		default: break;
	}
}
void ScreenServerLogin::MenuBack( const InputEventPlus &input )
{
	if( !GAMESTATE->m_bSideIsJoined[input.pn] )
		return;

	// todo: something for real?
	if(AnyTextBoxHasFocus())
		return;

	Cancel( SM_GoToPrevScreen );
}

/*
 * (c) 2012 AJ Kelly
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, and/or sell copies of the Software, and to permit persons to
 * whom the Software is furnished to do so, provided that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the Software and that both the above copyright notice(s) and this
 * permission notice appear in supporting documentation.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT
 * OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
 * OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */
