/* ScreenServerLogin - Login screen. */
#ifndef SCREEN_SERVER_LOGIN_H
#define SCREEN_SERVER_LOGIN_H

#include "ScreenWithMenuElements.h"
#include "ScreenMessage.h"
#include "TextBox.h"

class ScreenServerLogin : public ScreenWithMenuElements
{
public:
	ScreenServerLogin();
	~ScreenServerLogin();

	virtual void Init();
	virtual void BeginScreen();

	virtual void Update( float fDelta );
	virtual void Input( const InputEventPlus &input );
	virtual void HandleScreenMessage( const ScreenMessage SM );
	virtual void HandleMessage( const Message &msg );

	void UpdateItemFocus();
	bool AnyTextBoxHasFocus();
	TextBox* TextBoxWithFocus();

	bool TryLogin( PlayerNumber pn, RString &sStatusOut );
	void SetStatusText( PlayerNumber pn, RString sText );

	void MenuSideInput( const InputEventPlus &input );
	virtual void MenuLeft( const InputEventPlus &input );
	virtual void MenuRight( const InputEventPlus &input );
	virtual void MenuUp( const InputEventPlus &input );
	virtual void MenuDown( const InputEventPlus &input );
	virtual void MenuStart( const InputEventPlus &input );
	virtual void MenuBack( const InputEventPlus &input );

	virtual bool AllowLateJoin() const { return false; }

protected:
	TextBox		m_tbUserName[NUM_PLAYERS];
	TextBox		m_tbPassword[NUM_PLAYERS];
	AutoActor	m_sLoginItem[NUM_PLAYERS];
	BitmapText	m_tLoginStatus[NUM_PLAYERS];

	int			m_iSelectionIndex;
	int			m_iPrevSelectionIndex;
	bool		m_bLoggedIn[NUM_PLAYERS];

	// theme metrics (todo: allow themers to use commands instead?)
	ThemeMetric<RageColor> LoginStatusErrorColor;
	ThemeMetric<RageColor> LoginStatusSuccessColor;
};

#endif

/*
 * (c) 2012 AJ Kelly
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, and/or sell copies of the Software, and to permit persons to
 * whom the Software is furnished to do so, provided that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the Software and that both the above copyright notice(s) and this
 * permission notice appear in supporting documentation.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT
 * OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
 * OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */
