#include "global.h"
#include "ScreenSongOptions.h"
#include "RageLog.h"
#include "GameState.h"
#include "ThemeManager.h"
#include "PrefsManager.h"
#include "PlayerState.h"

REGISTER_SCREEN_CLASS( ScreenSongOptions );

void ScreenSongOptions::Init()
{
	ScreenOptionsMaster::Init();

	m_sprDisqualify.Load( THEME->GetPathG(m_sName,"disqualify") );
	m_sprDisqualify->SetName( "Disqualify" );
	LOAD_ALL_COMMANDS_AND_SET_XY( m_sprDisqualify );
	m_sprDisqualify->SetVisible( false );	// unhide later if handicapping options are discovered
	m_sprDisqualify->SetDrawOrder( 2 );
	m_frameContainer.AddChild( m_sprDisqualify );

	m_bRowCausesDisqualified.resize( m_pRows.size(), false );

	/* Hack: If we're coming in from "press start for more options", we need a different
	 * fade in. */
	if( PREFSMAN->m_ShowSongOptions == Maybe_ASK )
	{
		m_In.Load( THEME->GetPathB("ScreenSongOptions","option in") );
		m_In.StartTransitioning();
	}
}

void ScreenSongOptions::BeginScreen()
{
	ON_COMMAND( m_sprDisqualify );
	ScreenOptionsMaster::BeginScreen();

	// okay look; in the default theme, every one of the song options is locked
	// for both players. if one player changes it, it changes for the other.
	// if you make a theme that doesn't follow this, then you're fucked. sorry.
	// -freem, StepMania 5 Tournament Edition.
	for( unsigned r=0; r<m_pRows.size(); r++ )
		UpdateDisqualified( r );
}

void ScreenSongOptions::Input( const InputEventPlus &input )
{
	ScreenOptionsMaster::Input( input );

	// UGLY: Update m_Disqualified whenever we switch options
	PlayerNumber pn = input.pn;
	if( GAMESTATE->IsHumanPlayer(pn) &&
		(input.MenuI == GAME_BUTTON_MENULEFT ||
		input.MenuI == GAME_BUTTON_MENURIGHT)
		)
	{
		int row = m_iCurrentRow[pn];
		UpdateDisqualified( row );
	}
}

// this doesn't quite work yet and I don't know why.
void ScreenSongOptions::UpdateDisqualified( int row )
{
	// todo: grab song options, check if they disqualify, etc.
	SongOptions soOrig = GAMESTATE->m_SongOptions.GetPreferred();

	// Find out if the current row when exported causes disqualification.
	// Exporting the row will fill GAMESTATE->m_SongOptions.
	SO_GROUP_CALL( GAMESTATE->m_SongOptions, ModsLevel_Preferred, Init );
	vector<PlayerNumber> v;
	v.push_back( GAMESTATE->GetMasterPlayerNumber() );
	ExportOptions( row, v );

	bool bRowDisqualifies = GAMESTATE->CurrentSongOptionsDisqualify();
	m_bRowCausesDisqualified[row] = bRowDisqualifies;

	bool bShowDisqualify = false;
	FOREACH_CONST( bool, m_bRowCausesDisqualified, b )
	{
		if( *b )
		{
			bShowDisqualify = true;
			break;
		}
	}
	m_sprDisqualify->SetVisible( bShowDisqualify );

	// restore previous song options in case the user escapes back after this
	GAMESTATE->m_SongOptions.Assign( ModsLevel_Preferred, soOrig );
}

void ScreenSongOptions::ExportOptions( int iRow, const vector<PlayerNumber> &vpns )
{
	//PlayerNumber pn = GAMESTATE->GetMasterPlayerNumber();
	//PlayerState *pPS = GAMESTATE->m_pPlayerState[pn];

	ScreenOptionsMaster::ExportOptions( iRow, vpns );
}

/*
 * (c) 2001-2004 Chris Danford
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, and/or sell copies of the Software, and to permit persons to
 * whom the Software is furnished to do so, provided that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the Software and that both the above copyright notice(s) and this
 * permission notice appear in supporting documentation.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT
 * OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
 * OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */
