/* TextBox - A combined label and textbox. */
#ifndef TEXTBOX_H
#define TEXTBOX_H

#include "ActorFrame.h"
#include "AutoActor.h"
#include "BitmapText.h"
#include "ThemeMetric.h"

class InputEventPlus;

class TextBox: public ActorFrame
{
public:
	TextBox();
	void Load( const RString &sMetricsGroup );

	void GainFocus();
	void LoseFocus();
	bool GetInputFocus(){ return m_bHasInputFocus; }
	void SetInputFocus(bool bFocus);

	wstring GetAnswer(){ return m_sAnswer; }
	RString GetRstrAnswer(){ return WStringToRString(m_sAnswer); }
	RString GetAnswerSafe();
	wstring GetPrevAnswer(){ return m_sPrevAnswer; }

	bool Input( const InputEventPlus &input ); // returns true if input was handled.

	void Backspace();
	void TryAppendToAnswer( RString s );
	void UpdateAnswerText();

	void End( bool bCanceled );

	virtual TextBox *Copy() const;

	// Lua
	void PushSelf( lua_State *L );

private:
	RString		m_sMetricsGroup;
	bool		m_bHasInputFocus;	// does this TextBox have input focus?
	wstring		m_sAnswer;
	wstring		m_sPrevAnswer;

	AutoActor	m_Background;
	AutoActor	m_Label;
	BitmapText	m_InputText;

	ThemeMetric<bool>		m_bPassword;	// filters the input
	ThemeMetric<RString>	m_sFilterChar;	// filter character
};

#endif

/*
 * (c) 2012 AJ Kelly
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, and/or sell copies of the Software, and to permit persons to
 * whom the Software is furnished to do so, provided that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the Software and that both the above copyright notice(s) and this
 * permission notice appear in supporting documentation.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT
 * OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
 * OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */
