--[[
USW Noteskin.lua Version V2
Made for Version Stepmania 5 Preview 4

I am the bone of my noteskin
Arrows are my body, and explosions are my blood
I have created over a thousand noteskins
Unknown to death
Nor known to life
Have withstood pain to create many noteskins
Yet these hands will never hold anything
So as I pray, Unlimited Stepman Works

If you want to know the list of lua commands you can use here is the main page for help http://kki.ajworld.net/lua/sm5/Lua.xml
--]]

--[[
SkyBlader07 (formerly Patchy-kun in VM, now Reiuji-kun) was here
My notes are those marked with an asterisk
so you'll know what I did to make some functions work.

Stay Sexy.
Don't use redirects.
Eat at Marisa's Mushroom Grill.
5-star meals at affordable prices.
Bring either Alice or Patchouli for 100% discount
For delivery please dial MASTERSPARK (62783777275)
--]]
local ret = ... or {};

--I always had the problem were I wrote var instead of Var, which really iritated me wondering why a code wouldnt work
--You can edit it out if you want, But I'm just gonna leave it here so incase a person wants to make a noteskin
--And gets the same problem as me were you use var instead of Var, atleast this should make it still work
--But its best to use Var, And make sure to check all your code for little mistakes while you write ;)
local var = Var;

--[[
This is the general redirect table, Not the general redirect code, We use this if we are lazy ;)
Or if we cant a directon of a noteskin use the exact same files as another direction
The most re used direction in this case is "Down"
You can add and remove values if you want, It works for every game type,
If you want an easy way to know how all directions are called go in to stepmaniaoptions and change gametype
Then if you go to key configure look at the names for the keys, They are the same names that are used in the noteskin.lua
--]]
ret.RedirTable =
{
	Up = "Down",
	Down = "Down",
	Left = "Down",
	Right = "Down",
	UpLeft = "UpLeft",
	UpRight = "UpLeft",
};

--[[
This is the general redirect code, We use this if we want to redirect parts of noteskins to other parts
Because unlike the ret.RedirTable which redirects everything to the defined direction.
Here we can add redirects for seperate elements which means we can use separate images if we want
--]]
local OldRedir = ret.Redir;
ret.Redir = function(sButton, sElement)
	sButton, sElement = OldRedir(sButton, sElement);
	
	--This is were we call the ret.RedirTable and define it as sButton
	--So it get called when we return sButton including the code under here

	--*Make Fake Notes fallback onto Tap Notes
	if sElement == "Tap Fake"
	then
		sElement = "Tap Note";
	end
	
	--*I want the diagonal arrows to fall back on a different file
	--*Having to rotate UpLeft would be stupid, since it also rotates the Hold Underlay
	--*That's why we need to make seperate hold heads for UpLeft and UpRight
	--*And heck yes, I'm vain about the graphics
	sButton = ret.RedirTable[sButton];
	if string.find(sElement, "Hold") or string.find(sElement, "Roll") then
 	if string.find(sElement, "Head") then
  	if string.find(sElement, "Inactive") then
		if Var "Button" == "UpLeft" then sButton = "UpLeft"; end
		if Var "Button" == "UpRight" then sButton = "UpRight"; end
   		sElement = "Hold Head Inactive";
  	end
	
	--*If I would use the typical "Hold Head Active = Tap Note" thing, I would run to some problems 
	--*I don't want to use TopCap graphics as I'll be forced to use redirects that will mess up the cleanliness of the directory
	--*So to prevent that, make the Inactive and Active Hold Heads the same
 	if string.find(sElement, "Active") then
		if Var "Button" == "UpLeft" then sButton = "UpLeft"; end
		if Var "Button" == "UpRight" then sButton = "UpRight"; end
   		sElement = "Hold Head Active";
 	end
 	end
	end
	
	
	--*Ok. Same concept, different output. I want the diagonal notes to use a different hold body
	--*If you notice here, (Var "Button" == "UpRight" then sButton = "UpLeft")
	--*I made it so since the bottomcaps are the same anyways.
	if string.find(sElement, "Roll") then
 	if string.find(sElement, "Bottomcap") then
  	if string.find(sElement, "Inactive") then
		if Var "Button" == "UpLeft" then sButton = "UpLeft"; end
		if Var "Button" == "UpRight" then sButton = "UpLeft"; end
   		sElement = "Hold Bottomcap Inactive";
  	end
	
	
	--*Need I say more?
 	if string.find(sElement, "Active") then
		if Var "Button" == "UpLeft" then sButton = "UpLeft"; end
		if Var "Button" == "UpRight" then sButton = "UpLeft"; end
   		sElement = "Hold Bottomcap Active";
 	end
 	end
	end
	
	
	--*Making Sure all head graphics just use one graphic
	if  sElement == "Roll Head Inactive" then sElement = "Hold Head Inactive"; end 
	if  sElement == "Roll Head Active" then sElement = "Hold Head Active"; end
	
	
	--*Ok. I don't want to make a redirect for Down Hold Head Inactive
	if string.find(sElement, "Hold") then
	if string.find(sElement, "Head") then
	if string.find(sElement, "Inactive") then
		if Var "Button" == "Down" then sButton = "Down"; end
		sElement = "Hold Head Active";
	end
	end
	end
	
	--Since Roll Explosion is the same as Hold Explosion
	if  sElement == "Roll Explosion" then sElement = "Hold Explosion"; end
	
	
	--Since Down Hold and Roll explosion fall unto Tap Dim Explosion
	if sElement == "Hold Explosion" or
		sElement == "Roll Explosion"
	then
   	sElement = "Tap Explosion Dim";
	end;
	
	
	--*Avoiding extra files...
	--*This has to be placed here... you can't place it on top since there some hierarchy of sorts
	if string.find(sElement, "Tap") then
	if string.find(sElement, "Explosion") then
	if string.find(sElement, "Dim") then
		if Var "Button" == "UpLeft" then sButton = "Down"; end
		if Var "Button" == "UpRight" then sButton = "Down"; end
		sElement = "Tap Explosion Dim";
	end
	
	if string.find(sElement, "Bright") then
		if Var "Button" == "UpLeft" then sButton = "Down"; end
		if Var "Button" == "UpRight" then sButton = "Down"; end
		sElement = "Tap Explosion Bright";
	end
	end
	end
	
	--Define that every direction uses Tap Mine from Down
	if Var "Element" == "Tap Mine" then sButton = "Down"; end
	
	return sButton, sElement;
end

--[[
This is the general function code
In here we can define how we want the stuff to act
Which basicly means instead of using a load of lua files for just some effect
We can just use code in here so we need to use less files
Which is nice if you want to save up space ;)
Only problem is that the Hold/Roll parts are written down in the code as sprite files
Which is the original old 3.9 code, Which basicly means that their code doesnt work in here

Also unlike the general redirect code which has sElement and sButton defined in the common noteskin
They need to be defined here manualy which can be done with 
local sElement = Var "Element";
local sButton = Var "Button";
To make it easier for everyone I already added them
The reason we use local to define the stuff is for when a code doesnt accept the full code
Like for example if we did string.find(Var "Element", "Down") it wouldnt work
--]]
local OldFunc = ret.Load;
function ret.Load()
	local t = OldFunc();
	local sElement = Var "Element";
	local sButton = Var "Button";

	--Explosion should not be rotated; it calls other actors.
	if Var "Element" == "Explosion" then
		t.BaseRotationZ = nil;
	end
	
	if Var "Element" == "Tap Mine" then
		t.BaseRotationZ =nil;
	end
	
	
	--We define that we dont want the hold heads for UpLeft and UpRight to be rotated because we rotate them in a lua file
		if Var "Button" == "UpLeft" and string.find(sElement, "Head") then t.BaseRotationZ = nil; end
		if Var "Button" == "UpRight" and string.find(sElement, "Head") then t.BaseRotationZ = nil; end

	--*Define that only the Dim Tap Explosions for UpLeft and UpRight are rotated
		if Var "Button" == "UpLeft" and string.find(sElement, "Tap Explosion Dim")then t.BaseRotationZ = 135; end
		if Var "Button" == "UpRight" and string.find(sElement, "Tap Explosion Dim")then t.BaseRotationZ = -135; end
		
	--*Define Hold and Roll Explosion have the same rotation
		if string.find(sElement, "Hold Explosion") or string.find(sElement, "Roll Explosion") then
		if Var "Button" == "UpLeft" then t.BaseRotationZ = 135; end
		if var "Button" == "UpRight" then t.BaseRotationZ = -135; end
		end
			

		
	return t;
end
-- >


--Define which parts of noteskins which we want to rotate
ret.PartsToRotate =
{
	["Receptor"] = true,
	["Tap Explosion Bright"] = true,
	["Tap Explosion Dim"] = true,
	["Tap Note"] = true,
	["Tap Fake"] = true,
	["Tap Lift"] = true,
	["Tap Addition"] = true,
	["Hold Explosion"] = true,
	["Hold Head Active"] = true,
	["Hold Head Inactive"] = true,
	["Roll Explosion"] = true,
	["Roll Head Active"] = true,
	["Roll Head Inactive"] = true,
};
--Defined the parts to be rotated at which degree
ret.Rotate =
{
	Up = 180,
	Down = 0,
	Left = 90,
	Right = -90,
	UpLeft = 0,
	UpRight = 90,
};

--Parts that should be Redirected to _Blank.png
--you can add/remove stuff if you want
ret.Blank =
{
	["Hold Topcap Active"] = true,
	["Hold Topcap Inactive"] = true,
	["Roll Topcap Active"] = true,
	["Roll Topcap Inactive"] = true,
	["Hold Tail Active"] = true,
	["Hold Tail Inactive"] = true,
	["Roll Tail Active"] = true,
	["Roll Tail Inactive"] = true,
};

--dont forget to close the ret cuz else it wont work ;>
return ret;
