-- Replacement for the default song rate option row.
return function()
	-- Procedurally generate all the tiny little speed increments
	-- so that the option row may use them
	local function theChoices()
		local ret = {}
		
		for i=0.1,3.1,0.1 do
			ret[#ret+1] = tostring(i) .. "x"
		end
		
		return ret
	end
	
	return {
		Name="Rate",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = true,
		ExportOnChange = true,
		Choices = theChoices(),
		LoadSelections = function(self, list, pn)
			local theRate = GAMESTATE:GetSongOptionsObject("ModsLevel_Preferred"):MusicRate()
			local val = scale(theRate,0.1,3,1,#list)
			if list[val] ~= nil then
				list[val] = true
			else
				list[10] = true
			end
		end,
		SaveSelections = function(self, list, pn)
			for i=1,#list do
				if list[i] == true then
					local val = scale(i,1,#list,0.1,3)
					GAMESTATE:GetSongOptionsObject("ModsLevel_Preferred"):MusicRate(val)
					break
				end
			end
		end
	}
end
