# UI Framework

This collection of modules has been designed to ease the development of UI-centric elements on a theme for OutFox.

## List of Modules

[UI.ButtonBox.lua](Docs/UI.ButtonBox.md) - Creates a quad with a border that can be tied to a player for specific colors, or can become a metatable to provide further functionality with reactive elements.

[UI.ButtonChooser.lua](Docs/UI.ButtonChooser.md) - An item set that allows the user to choose from an array of items provided.

[UI.ClickArea.lua](Docs/UI.ClickArea.md) - Automatic, absolute-positioned mouse calculation.

[UI.DropDown.lua]() - A dropdown menu that can be player-dependant. Also can interact with engine-side elements by filtering engine input when needed.

[UI.GenerateUIWithButtonAction.lua]() - Creates a button that can contain the flare of [UI.ButtonBox.lua](Docs/UI.ButtonBox.md), while also allowing for extra actors on top of it for visual elements.

[UI.MouseDetect.lua](Docs/UI.MouseDetect.md) - The backbones of [UI.ClickArea.lua](Docs/UI.ClickArea.md).

[UI.OptionList.lua](Docs/UI.OptionList.md) - A complete, mouse / touch compatible option area that supports a recursive method to use menus. Can be player dependant, and support player mods, engine options, and Project OutFox preferences.

[UI.OptionWithDropdown.lua]()

[UI.Slider.lua](Docs/UI.Slider.md) - A draggable slider.

[UIHelper.OptionList.lua]() - Helper commands to ease creation of the list for [UI.OptionList.lua](Docs/UI.OptionList.md).