if not Branch then Branch = {}; end;

--[[ post-load ]]
function SelectStyleScreen()
	-- need to reload metrics to take gametypes into account
	THEME:ReloadMetrics()

	if GetAutoSetStyle() then return "ScreenSelectNumPlayers" end

	-- todo: handle different gametypes here if not already AutoSetStyle'd
	return "ScreenSelectStyle"
end

function ScreenCautionBranch()
	if PREFSMAN:GetPreference("ShowCaution") then return "ScreenCaution" end
	return SelectStyleScreen()
end

Branch.AfterCaution = function()
	return SelectStyleScreen()
end;

Branch.AfterGameplay = function()
	-- xxx: players may be connected but playing offline
	if IsNetConnected() then return "ScreenNetEvaluation" end
	local pm = GAMESTATE:GetPlayMode()
	if( pm == "PlayMode_Regular" )	then return "ScreenEvaluationStage" end
	if( pm == "PlayMode_Nonstop" )	then return "ScreenEvaluationNonstop" end
	if( pm == "PlayMode_Oni" )		then return "ScreenEvaluationOni" end
	if( pm == "PlayMode_Endless" )	then return "ScreenEvaluationEndless" end
	if( pm == "PlayMode_Rave" )		then return "ScreenEvaluationRave" end
	if( pm == "PlayMode_Battle" )	then return "ScreenEvaluationBattle" end
end

function ScreenSelectStyleNextScreen()
	if IsNetConnected() then ReportStyle() end
	if IsNetSMOnline() or IsNetConnected() then
		-- if we're online, only normal works.
		GAMESTATE:ApplyGameCommand("playmode,regular");
		return SMOnlineScreen()
	end
	return "ScreenSelectPlayMode"
end;

function SelectMusicOrCourse()
	local pm = GAMESTATE:GetPlayMode()

	if pm ~= "PlayMode_Regular" and IsNetConnected()	then
		SCREENMAN:SystemMessage( THEME:GetString("NetworkSyncManager","Not Supported") )
	end

	if pm == "PlayMode_Nonstop"	then return "ScreenSelectCourseNonstop" end
	if pm == "PlayMode_Oni"		then return "ScreenSelectCourseOni" end
	if pm == "PlayMode_Endless"	then return "ScreenSelectCourseEndless" end
	if IsNetConnected() then ReportStyle() end
	if IsNetSMOnline() then return SMOnlineScreen() end
	if IsNetConnected() then return "ScreenNetSelectMusic" end
	return "ScreenSelectMusic"
end

function ScreenEvalNextScreen()
	-- Always save profile after eval
	-- (todo: unless it's the final stage, where saving happens after summary)
	return "ScreenProfileSave"
end