function RateMods( s )
	local modList = rateMods
	if s then modList = rateModsEdit end
	local t = {
		Name = "Music Rate",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = true,
		ExportOnChange = false,
		Choices = modList,
	   
		LoadSelections = function(self, list, pn)
			for n = 1, table.getn(modList) do
				if GAMESTATE:PlayerIsUsingModifier(pn,modList[n]..'music') then list[n] = true; s = string.gsub(modList[n],'x','') modRate = tonumber(s) else list[n] = false end
			end
		end,

		SaveSelections = function(self, list, pn)
			for n = 1, table.getn(modList) do
				if list[n] then s = modList[n] end
			end
			s = string.gsub(s,'x','')
			modRate = tonumber(s)
			GAMESTATE:ApplyGameCommand('mod,'..s..'xmusic',pn+1)
			ApplyRateAdjust()
			MESSAGEMAN:Broadcast('RateModChanged')
		end
	   
	}
	setmetatable(t, t)
	return t
end






function SetFromScreenMachineOptions( actor )
	Trace( "SetFromScreenMachineOptions" )

	local JudgeDifficulty = GAMESTATE:GetCurrentJudgeDifficulty();
	local LifeDifficulty = GAMESTATE:GetCurrentLifeDifficulty();
	local text = ""
	if JudgeDifficulty then
		text = GetJudgeDifficultyTitle()
	end
	if LifeDifficulty  then
		text = Life:GetLifeDifficultyTitle() .. " - " .. text;
	
	end
t = nil
print (t[0])
	actor:settext( text )
end






function GetRateModHelper( rate )
	return GAMESTATE:PlayerIsUsingModifier(0, rate) or GAMESTATE:PlayerIsUsingModifier(1, rate)
end

function GetRateMod()
	if GetRateModHelper('0.1xmusic') then return '0.1x Rate' end
	if GetRateModHelper('0.2xmusic') then return '0.2x Rate' end
	if GetRateModHelper('0.3xmusic') then return '0.3x Rate' end
	if GetRateModHelper('0.4xmusic') then return '0.4x Rate' end
	if GetRateModHelper('0.5xmusic') then return '0.5x Rate' end
	if GetRateModHelper('0.6xmusic') then return '0.6x Rate' end
	if GetRateModHelper('0.7xmusic') then return '0.7x Rate' end
	if GetRateModHelper('0.8xmusic') then return '0.8x Rate' end
	if GetRateModHelper('0.9xmusic') then return '0.9x Rate' end
	if GetRateModHelper('1.0xmusic') then return '' end
	if GetRateModHelper('1.1xmusic') then return '1.1x Rate' end
	if GetRateModHelper('1.2xmusic') then return '1.2x Rate' end
	if GetRateModHelper('1.3xmusic') then return '1.3x Rate' end
	if GetRateModHelper('1.4xmusic') then return '1.4x Rate' end
	if GetRateModHelper('1.5xmusic') then return '1.5x Rate' end
	if GetRateModHelper('1.6xmusic') then return '1.6x Rate' end
	if GetRateModHelper('1.7xmusic') then return '1.7x Rate' end
	if GetRateModHelper('1.8xmusic') then return '1.8x Rate' end
	if GetRateModHelper('1.9xmusic') then return '1.9x Rate' end
	if GetRateModHelper('2.0xmusic') then return '2.0x Rate' end
	return '(Unknown rate mod)'
end
