function PlayerColor( pn )
	if pn == PLAYER_1 then return color("#FFDE00") end	-- oranged yellow
	if pn == PLAYER_2 then return color("#14FF00") end	-- green
	return color("1,1,1,1")
end
local DifficultyColors = {
	Difficulty_Beginner	= color("0.0,0.9,1.0,1"),	-- light blue
	Difficulty_Easy		= color("0.9,0.9,0.0,1"),	-- yellow
	Difficulty_Medium	= color("1.0,0.1,0.1,1"),	-- light red
	Difficulty_Hard		= color("0.2,1.0,0.2,1"),	-- light green
	Difficulty_Challenge	= color("0.2,0.6,1.0,1"),	-- blue
	Difficulty_Edit		= color("0.8,0.8,0.8,1"),	-- gray
}
function DifficultyColor( dc ) return DifficultyColors[dc] end

-- Added from SVN --
local CourseDifficultyColors = {
	Difficulty_Beginner	= color("0.0,0.9,1.0,1"),	-- light blue
	Difficulty_Easy		= color("0.9,0.9,0.0,1"),	-- yellow
	Difficulty_Medium	= color("1.0,0.1,0.1,1"),	-- light red
	Difficulty_Hard		= color("0.2,1.0,0.2,1"),	-- light green
	Difficulty_Challenge	= color("0.2,0.6,1.0,1"),	-- blue
};
local StageColors = {
	Stage_1st	= color("#00ffc7"),
	Stage_2nd	= color("#58ff00"),
	Stage_3rd	= color("#f400ff"),
	Stage_4th	= color("#00ffda"),
	Stage_5th	= color("#ed00ff"),
	Stage_6th	= color("#73ff00"),
	Stage_Next	= color("#73ff00"),
	Stage_Final	= color("#ff0707"),
	Stage_Extra1	= color("#fafa00"),
	Stage_Extra2	= color("#ff0707"),
	Stage_Nonstop	= color("#FFFFFF"),
	Stage_Oni	= color("#FFFFFF"),
	Stage_Endless	= color("#FFFFFF"),
	Stage_Event	= color("#FFFFFF"),
	Stage_Demo	= color("#FFFFFF"),
};
function StageToColor( stage )
	local c = StageColors[stage];
	if c then return c end
	return color("#000000");
end
local JudgmentLineColors = {
	JudgmentLine_W1		= color("#00ffc7"),
	JudgmentLine_W2		= color("#f6ff00"),
	JudgmentLine_W3		= color("#00ff78"),
	JudgmentLine_W4		= color("#34bfff"),
	JudgmentLine_W5		= color("#e44dff"),
	JudgmentLine_Held	= color("#FFFFFF"),
	JudgmentLine_Miss	= color("#ff3c3c"),
	JudgmentLine_MaxCombo	= color("#ffc600"),
};
function JudgmentLineToColor( i )
	local c = JudgmentLineColors[i];
	if c then return c end
	return color("#000000");
end