--[[ player colors ]]
function PlayerColor( pn )
	if pn == PLAYER_1 then return color("1,0.8,0,1") end		-- yellow
	if pn == PLAYER_2 then return color("1,0.58,0.32,1") end	-- orange
	return color("1,1,1,1")
end

function PlayerMidColor( pn )
	local c = PlayerColor(pn);
	return { c[1]/1.5, c[2]/1.5, c[3]/1.5, c[4] };
end;

function PlayerDarkColor( pn )
	local c = PlayerColor(pn);
	return { c[1]/2, c[2]/2, c[3]/2, c[4] };
end;
--[[ /player colors ]]

--[[ song length colors ]]
-- todo: change
SongLengthColors = {
	Normal   = color("#FFFFFF"),
	Long     = color("#FFEEEE"),
	Marathon = color("#EEEEFF"),
};
--[[ /song length colors ]]

--[[ for grade colors, see Graphics/MusicWheelItem grades/default.lua ]]

--[[ difficulty colors ]]
-- kill off DifficultyColors in an attempt to find places where it's used.
DifficultyColors = nil;

-- generic colors that are re-used
local cGenericBeginner = color("#12D7FF"); -- light blue
local cGenericEasy = color("#12FF39"); -- green
local cGenericMedium = color("#FF12D7"); -- pink/purple
local cGenericHard = color("#FF3912"); -- red
local cGenericChallenge = color("#3912FF"); -- blue
local cGenericEdit = color("#888888"); -- gray

DifficultyAndStepsTypeInfo = {
	--[[ dance mode ]]
	-- single
	{ difficulty = "Difficulty_Beginner", stepsType = "StepsType_Dance_Single", color = cGenericBeginner },
	{ difficulty = "Difficulty_Easy", stepsType = "StepsType_Dance_Single", color = cGenericEasy },
	{ difficulty = "Difficulty_Medium", stepsType = "StepsType_Dance_Single", color = cGenericMedium },
	{ difficulty = "Difficulty_Hard", stepsType = "StepsType_Dance_Single", color = cGenericHard },
	{ difficulty = "Difficulty_Challenge", stepsType = "StepsType_Dance_Single", color = cGenericChallenge },
	{ difficulty = "Difficulty_Edit", stepsType = "StepsType_Dance_Single", color = cGenericEdit },
	-- double
	{ difficulty = "Difficulty_Beginner", stepsType = "StepsType_Dance_Double", color = cGenericBeginner },
	{ difficulty = "Difficulty_Easy", stepsType = "StepsType_Dance_Double", color = cGenericEasy },
	{ difficulty = "Difficulty_Medium", stepsType = "StepsType_Dance_Double", color = cGenericMedium },
	{ difficulty = "Difficulty_Hard", stepsType = "StepsType_Dance_Double", color = cGenericHard },
	{ difficulty = "Difficulty_Challenge", stepsType = "StepsType_Dance_Double", color = cGenericChallenge },
	{ difficulty = "Difficulty_Edit", stepsType = "StepsType_Dance_Double", color = cGenericEdit },
	
	--[[ pump mode ]]
	{ difficulty = "Difficulty_Beginner", stepsType = "StepsType_Pump_Single", color = cGenericBeginner },
	{ difficulty = "Difficulty_Easy", stepsType = "StepsType_Pump_Single", color = cGenericEasy },
	{ difficulty = "Difficulty_Medium", stepsType = "StepsType_Pump_Single", color = cGenericMedium },
	{ difficulty = "Difficulty_Hard", stepsType = "StepsType_Pump_Single", color = cGenericHard },
	{ difficulty = "Difficulty_Challenge", stepsType = "StepsType_Pump_Single", color = cGenericChallenge },
	{ difficulty = "Difficulty_Edit", stepsType = "StepsType_Pump_Single", color = cGenericEdit },
	--[[ todo:
	* Half doubles (Medium / Pump_Halfdouble) [#04feba in pro; unknown here]
	* freestyle (Medium / Pump_Double) [#fe04f5 in pro; will probably be orange]
	* nightmare (Hard / Pump_Double) [#04c6fe in pro; will probably be darker gray]
	]]
	{ difficulty = "Difficulty_Edit", stepsType = "StepsType_Pump_Halfdouble", color = cGenericEdit },
	{ difficulty = "Difficulty_Edit", stepsType = "StepsType_Pump_Double", color = cGenericEdit },
};

function StepsOrTrailToColor(StepsOrTrail)
	if not StepsOrTrail then return color("#000000"); end
	if lua.CheckType("Trail", StepsOrTrail) then return TrailColor() end

	local dc = StepsOrTrail:GetDifficulty();
	local st = StepsOrTrail.GetStepsType and StepsOrTrail:GetStepsType();
	return DifficultyAndStepsTypeToColor( dc, st );
end

function DifficultyAndStepsTypeToIndex( difficulty, stepsType )
	for idx, entry in ipairs(DifficultyAndStepsTypeInfo) do
		if entry.difficulty == difficulty and entry.stepsType == stepsType then 
			return idx;
		end
	end
	return nil;
end

function DifficultyAndStepsTypeToColor( difficulty, stepsType )
	local idx = DifficultyAndStepsTypeToIndex( difficulty, stepsType );
	if not idx then return color("#000000"); end
	return DifficultyAndStepsTypeInfo[idx].color;
end

--[[ /difficulty colors ]]

--[[ old code ]]
local DifficultyColors = {
	Difficulty_Beginner		= color("#12D7FF"),	-- light blue
	Difficulty_Easy			= color("#12FF39"),	-- green
	Difficulty_Medium		= color("#FF12D7"),	-- pink/purple
	Difficulty_Hard			= color("#FF3912"),	-- red
	Difficulty_Challenge	= color("#3912FF"),	-- blue
	Difficulty_Edit			= color("#888888"),	-- dark gray
}
function DifficultyColor( dc ) return DifficultyColors[dc] end

function DifficultyLightColor( dc )
	local c = DifficultyColor(dc);
	return { c[1]+(c[1]/2), c[2]+(c[2]/2), c[3]+(c[3]/2), c[4] };
end;

function DifficultyDarkColor( dc )
	local c = DifficultyColor(dc);
	return { c[1]/2, c[2]/2, c[3]/2, c[4] };
end;
--[[ /old code ]]