-- departure emblem system

--[[ shared functions -DO NOT TOUCH- ]]
function ReturnPathSong(filename)
	return THEME:GetPathG("_emblems","default/Songs/"..filename);
end;

function ReturnPathGroup(filename)
	return THEME:GetPathG("_emblems","default/Groups/"..filename);
end;

function ReturnPathCourse(filename)
	return THEME:GetPathG("_emblems","default/Courses/"..filename);
end;
--[[ end share functions -DO NOT TOUCH- ]]

--[[ song emblems ]]
local SongEmblems = {
	{ Title = "be in my paradise", Filename = "_beinmyparadise", },
	{ Title = "diving money", Filename = "_divingmoney", },
	{ Title = "the earth light", Filename = "_earthlight", },
	{ Title = "gentle stress", Filename = "_gentlestress-original", },
	{ Title = "gentle stress (amd sexual mix)", Filename = "_gentlestress-amdsexual", },
	{ Title = "kind lady", Filename = "_kindlady", },
	{ Title = "make it better", Filename = "_makeitbetter", },
	{ Title = "max 300", Filename = "_max300", },
	{ Title = "my fire (uks remix)", Filename = "_makeitbetter", },
	{ Title = "paranoia", Filename = "_paranoia-180", },
	{ Title = "rugged ash", Filename = "_ruggedash", },
	{ Title = "so deep (perfect sphere remix)", Filename = "_sodeep_psm", },
	{ Title = "sp-trip machine (jungle mix)", Filename = "_sp-tripmachine", },
	{ Title = "tubthumping", Filename = "_tubthumping", },
	{ Title = "v(for extreme)", Filename = "_v-extreme", },
	{ Title = "xenon", Filename = "_xenon", },
	-- default
	default = { Title = "Default", Filename = "_default", },
};

-- GetEmblemFromSongTitle(SongTitle)
-- This function takes in a song title and runs through the SongEmblems
-- table looking for any title matches. If worse comes to worse, it returns
-- the default.
function GetEmblemFromSongTitle(SongTitle)
	SongTitle = string.lower(SongTitle);
	for songIdx, songTable in pairs(SongEmblems) do
		if( SongTitle == SongEmblems[songIdx]['Title'] ) then
			return ReturnPathSong(SongEmblems[songIdx]['Filename']);
		end;
	end;
	return ReturnPathSong(SongEmblems['default']['Filename']);
end;

--[[ group emblems ]]
-- Warning: People tend to group songs differently. The makers of the emblem
-- system do not guarantee 100% that the emblem list will match up with your
-- song collection. If you wish to add a line, please feel free to do so
-- by copying one of the examples, and make sure to change things accordingly.
local GroupEmblems = {
	-- ddr extreme
	{ Title = "DDR Extreme", Filename = "_ddr-8extreme" },
	{ Title = "Dance Dance Revolution 8th Mix -Extreme-", Filename = "_ddr-8extreme" },
	-- default
	default = { Title = "Default", Filename = "_default" },
};

-- GetEmblemFromGroupTitle(GroupTitle)
-- This function takes in a song title and runs through the SongEmblems
-- table looking for any title matches. If worse comes to worse, it returns
-- the default.
function GetEmblemFromGroupTitle(GroupTitle)
	for groupIdx, groupTable in pairs(GroupEmblems) do
		if( GroupTitle == GroupEmblems[groupIdx]['Title'] ) then
			return ReturnPathGroup(GroupEmblems[groupIdx]['Filename']);
		end;
	end;
	return ReturnPathGroup(GroupEmblems['default']['Filename']);
end;

--[[ course emblems ]]
local CourseEmblems = {
	default = { Title = "Default", Filename = "_default", },
};

--[[
Copyright  2008 AJ Kelly
All rights reserved.

This code is licensed under AJ's Generic Use of Code License.
An up to date copy can be found at the following address:
http://kki.ajworld.net/wiki/AJ%27s_Generic_Use_of_Code_License
However, keep in mind that the code in this file is bound to the exact
specifications found in this file.
That is to say, changes are not retroactive.

When using parts of this code in your theme, you agree to the following points:

1. Not hide/require registration for any theme that uses the code from the
public IF there is a public release. (This means private themes and themes for
commercial games can use the code without worry.)

2. Not compile the code down to bytecode (if the code is Lua) in a public
theme. (Yes, it can be reversed, but regardless, this hinders openness and
sharing.)

3. This code is a unique/nontrivial creation, therefore, credit should be
given to the creator of the code if used in another theme.
]]