-- ProductivityHelpers:
-- for when you don't want to type "x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y"
-- every time you need to center something.

--[[ Actor commands ]]

-- Center()
-- Centers an actor using SCREEN_CENTER_X and SCREEN_CENTER_Y.
function Actor:Center()
	self:x(SCREEN_CENTER_X);
	self:y(SCREEN_CENTER_Y);
end;

-- MaskSource()
-- Sets an actor up as the source for a mask.
function Actor:MaskSource()
	self:clearzbuffer(true);
	self:zwrite(true);
	self:blend('BlendMode_NoEffect');
end;

-- MaskDest()
-- Sets an actor up to be masked by anything with MaskSource().
function Actor:MaskDest()
	self:ztest(true);
end;

--[[ BitmapText commands ]]

function BitmapText:PixelFont()
	self:SetTextureFiltering(false);
end;

-- this code is public domain because anyone could've come up with it.