function PlayerColor( pn )
	if pn == PLAYER_1 then return color("#ff00c6") end		-- pnik (sic)
	if pn == PLAYER_2 then return color("#cc00ff") end	-- purple
	return color("1,1,1,1")
end

function PlayerMidColor( pn )
	local c = PlayerColor(pn);
	return { c[1]/1.5, c[2]/1.5, c[3]/1.5, c[4] };
end;

function PlayerDarkColor( pn )
	local c = PlayerColor(pn);
	return { c[1]/2, c[2]/2, c[3]/2, c[4] };
end;

-- todo: customize meee [names with * are customized]
local DifficultyColors = {
	Difficulty_Beginner	= color("0.0,0.9,1.0,1"),	-- light blue
	Difficulty_Easy		= color("0,0.8,0,1"),	-- green*
	Difficulty_Medium	= color("1,0.8,0,1"),	-- orange-ish*
	Difficulty_Hard		= color("1,0,0,1"),	-- red*
	Difficulty_Challenge	= color("0,0,1,1"),	-- blue*
	Difficulty_Edit		= color("0.5,0.5,0.5,1"),	-- dark gray*
}
function DifficultyColor( dc ) return DifficultyColors[dc] end

function DifficultyLightColor( dc )
	local c = DifficultyColor(dc);
	return { c[1]+(c[1]/2), c[2]+(c[2]/2), c[3]+(c[3]/2), c[4] };
end;

function DifficultyDarkColor( dc )
	local c = DifficultyColor(dc);
	return { c[1]/2, c[2]/2, c[3]/2, c[4] };
end;

local JudgeColors = {
	TapNoteScore_W1 = color("#FFFFCC"),   -- Marvelous / light goldish
	TapNoteScore_W2 = color("#FFDD00"),   -- Perfect / gold
	TapNoteScore_W3 = color("#00DD00"),   -- Great / green
	TapNoteScore_W4 = color("#00C0FF"),   -- Good / aj blue
	TapNoteScore_W5 = color("#CC00FF"),   -- Boo / purple
	TapNoteScore_Miss = color("#DB2122"), -- Miss / red
};
function JudgeColor( jc ) return JudgeColors[jc] end

-- (c) 2005-2008 Chris Danford, AJ 187
-- All rights reserved.
-- 
-- see some other file for the copyright notice