local function GetEvaluationNextScreenInternal( sNextScreen, sFailedScreen, sEndScreen )

	if GAMESTATE:IsEventMode() then
		return sNextScreen
	end
	
	local bIsExtraStage = GAMESTATE:IsAnExtraStage()
	-- Not in event mode.  If failed, go to the game over screen.
	if STATSMAN:GetCurStageStats():AllFailed() and not bIsExtraStage then
		return sFailedScreen
	end

	local sIsStage = not GetTopScreenMetric( "Summary" ) and not GAMESTATE:IsCourseMode()
	if sIsStage then
		local bLastStage = GAMESTATE:GetSmallestNumStagesLeftForAnyHumanPlayer() <= 0
		if not bLastStage then
			return sNextScreen
		end
	end

	return sEndScreen
end

function ScreenSelectStyleNextScreen()
	if IsNetConnected() then ReportStyle() end
	if IsNetSMOnline() or IsNetConnected() then return ScreenNetSelectPlayMode() end
	return "ScreenSelectPlayMode"
end;

function ScreenNetSelectPlayMode()
	if IsNetSMOnline() then return SMOnlineScreen() end
	if IsNetConnected() then return "ScreenNetSelectMusic" end
	return "ScreenSelectMusic"
end;

function ScreenProfileSaveNextScreen()
	local sNextScreen;
	local sFailedScreen = "ScreenTitleMenu";
	local sEndScreen = "ScreenTitleMenu";
	
	-- dunno why i am doing online stuff at all
	if IsNetSMOnline() then sNextScreen = "ScreenNetRoom"
	elseif( IsNetConnected() ) then sNextScreen = "ScreenNetSelectMusic"
	else sNextScreen = SongSelectionScreen()
	end;
	
	return GetEvaluationNextScreenInternal( sNextScreen, sFailedScreen, sEndScreen );
end

function ScreenEvalNextScreen()
	-- Always save profile because you can!!
	return "ScreenProfileSave"
end

function SongSelectionScreen()
	local pm = GAMESTATE:GetPlayMode()

	if pm ~= "PlayMode_Regular" and IsNetConnected()	then
		SCREENMAN:SystemMessage( THEME:GetString("NetworkSyncManager","Not Supported") )
	end

	if pm == "PlayMode_Nonstop"	then return "ScreenSelectCourseNonstop" end
	if pm == "PlayMode_Oni"		then return "ScreenSelectCourseOni" end
	if pm == "PlayMode_Endless"	then return "ScreenSelectCourseEndless" end
	if IsNetConnected() then ReportStyle() end
	if IsNetSMOnline() then return SMOnlineScreen() end
	if IsNetConnected() then return "ScreenNetSelectMusic" end
	return "ScreenSelectMusic"
end

-- [v1.4] fix things by returning to the title menu instead of moving on
-- and making versus/doubles the only options. Now why is that?
function NextNetworkScreen()
	return "ScreenTitleMenu"
end