--[[ pre-load ]]

-- version check
function InitialScreen()
	return VersionCheck() and "ScreenTitleMenu" or "ScreenVersionMismatch";
end;

--[[ post-load ]]

function ScreenCautionBranch()
	if PREFSMAN:GetPreference("ShowCaution") then return "ScreenCaution" end

	-- then check to see if AutoSetStyle is on
	if GetAutoSetStyle() == true then
		-- todo: account for alternate play modes as well.
		GAMESTATE:ApplyGameCommand("playmode,regular");
		return SongSelectionScreen();
	else
		-- game requires styles
		return "ScreenSelectStyle"
	end;
	-- go here if we don't know what to do
	return "ScreenSelectStyle"
end

--[[===========================================================================]]

--[[ internal ]]
local function GetEvaluationNextScreenInternal( sNextScreen, sFailedScreen, sEndScreen )

	if GAMESTATE:IsEventMode() then
		return sNextScreen
	end

	local bIsExtraStage = GAMESTATE:IsAnExtraStage()
	-- Not in event mode.  If failed, go to the game over screen.
	if STATSMAN:GetCurStageStats():AllFailed() and not bIsExtraStage then
		return sFailedScreen
	end

	local sIsStage = not GetTopScreenMetric( "Summary" ) and not GAMESTATE:IsCourseMode()
	if sIsStage then
		local bLastStage = GAMESTATE:GetSmallestNumStagesLeftForAnyHumanPlayer() <= 0
		if not bLastStage then
			return sNextScreen
		end
	end

	return sEndScreen
end

--[[ not internal ]]
function ScreenSelectStyleNextScreen()
	if IsNetConnected() then ReportStyle() end
	if IsNetSMOnline() or IsNetConnected() then
		-- if we're online, only normal works.
		GAMESTATE:ApplyGameCommand("playmode,regular");
		return ScreenNetSelectPlayMode()
	end
	return "ScreenSelectPlayMode"
end;

function ScreenNetSelectPlayMode()
	if IsNetSMOnline() then return SMOnlineScreen() end
	if IsNetConnected() then return "ScreenNetSelectMusic" end
	return "ScreenSelectMusic"
end;

function SongSelectionScreen()
	local pm = GAMESTATE:GetPlayMode()

	if pm ~= "PlayMode_Regular" and IsNetConnected()	then
		SCREENMAN:SystemMessage( THEME:GetString("NetworkSyncManager","Not Supported") )
	end

	if pm == "PlayMode_Nonstop"	then return "ScreenSelectCourseNonstop" end
	if pm == "PlayMode_Oni"		then return "ScreenSelectCourseOni" end
	if pm == "PlayMode_Endless"	then return "ScreenSelectCourseEndless" end
	if IsNetConnected() then ReportStyle() end
	if IsNetSMOnline() then return SMOnlineScreen() end
	if IsNetConnected() then return "ScreenNetSelectMusic" end
	return "ScreenSelectMusic"
end

function ScreenEvalNextScreen()
	-- Always save profile after eval.
	-- this might be handled differently later, depending on stages.
	return "ScreenProfileSave"
end

function ScreenProfileSaveNextScreen()
	local sNextScreen;
	local sFailedScreen = "ScreenGameOver";
	local sEndScreen = "ScreenGameOver";

	if IsNetSMOnline() then sNextScreen = "ScreenNetRoom"
	elseif( IsNetConnected() ) then sNextScreen = "ScreenNetSelectMusic"
	else sNextScreen = SongSelectionScreen()
	end;

	return GetEvaluationNextScreenInternal( sNextScreen, sFailedScreen, sEndScreen );
end

function NextNetworkScreen()
	return "ScreenTitleMenu"
end