--[[ general color functions ]]
function ColorLightTone(c)
	return { c[1]+(c[1]/2), c[2]+(c[2]/2), c[3]+(c[3]/2), c[4] };
end;

function ColorMidTone(c)
	return { c[1]/1.5, c[2]/1.5, c[3]/1.5, c[4] };
end;

function ColorDarkTone(c)
	return { c[1]/2, c[2]/2, c[3]/2, c[4] };
end;

--[[ player color functions ]]

function PlayerColor( pn )
	if pn == PLAYER_1 then return color("0,0.8,1,1") end		-- light blue
	if pn == PLAYER_2 then return color("0,0.8,0.431,1") end	-- green
	return color("1,1,1,1")
end

function PlayerMidColor( pn )
	return ColorMidTone( PlayerColor(pn) );
end;

function PlayerDarkColor( pn )
	return ColorDarkTone( PlayerColor(pn) );
end;

--[[ difficulty color ]]
local CustomDifficultyColors = {
	Beginner	= color("0.0,0.9,1.0,1"),	-- light blue
	Easy		= color("0,0.8,0,1"),	-- green*
	Medium		= color("1,0.8,0,1"),	-- orange-ish*
	Hard		= color("1,0,0,1"),	-- red*
	Challenge	= color("0,0,1,1"),	-- blue*
	Edit		= color("0.5,0.5,0.5,1"),	-- dark gray*
	Couple		= color("0,0,0,1"),
	Routine		= color("0,0,0,1"),
};

-- todo: customize more [names with * are customized]
local DifficultyColors = {
	Difficulty_Beginner	= color("0.0,0.9,1.0,1"),	-- light blue
	Difficulty_Easy		= color("0,0.8,0,1"),	-- green*
	Difficulty_Medium	= color("1,0.8,0,1"),	-- orange-ish*
	Difficulty_Hard		= color("1,0,0,1"),	-- red*
	Difficulty_Challenge	= color("0,0,1,1"),	-- blue*
	Difficulty_Edit		= color("0.5,0.5,0.5,1"),	-- dark gray*
}
function DifficultyColor( dc ) return DifficultyColors[dc] end

function DifficultyLightColor( dc )
	return ColorLightTone( DifficultyColor(dc) );
end;

function DifficultyDarkColor( dc )
	return ColorDarkTone( DifficultyColor(dc) );
end;

--[[ judgment colors ]]
local JudgeColors = {
	TapNoteScore_W1 = color("#FFFFCC"),   -- Marvelous / light goldish
	TapNoteScore_W2 = color("#FFDD00"),   -- Perfect / gold
	TapNoteScore_W3 = color("#00DD00"),   -- Great / green
	TapNoteScore_W4 = color("#00C0FF"),   -- Good / aj blue
	TapNoteScore_W5 = color("#CC00FF"),   -- Boo / purple
	TapNoteScore_Miss = color("#DB2122"), -- Miss / red
};
function JudgeColor( jc ) return JudgeColors[jc] end

-- (c) 2005-2008 Chris Danford, AJ 187
-- All rights reserved.
-- 
-- see some other file for the copyright notice