#include "windows.h"
#include "Decoder.h"
#include <stdio.h>
#include <stdlib.h>

#ifdef __cplusplus
extern "C"
{
#endif

int ogg_open( FILE* infile) ;
int ogg_getrate() ;
int ogg_getchannels() ;
int ogg_read( char *buf, int bufsize ) ;
int ogg_percentdone() ;

#ifdef __cplusplus
}
#endif

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Decoder::Decoder()
{
	m_pMp3BufferData = NULL ;

	m_mp3BufSize = 0 ;

	wavinfile = NULL ;
	m_bytesInBuffer = 0 ;

	m_nType = -1 ;

	m_nPercentDone = 0 ;
	m_nWavBytesRead = 0 ;

}
 
// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Decoder::~Decoder()
{
}



int Decoder::findframe(  )
{
	int found ;
	int bitrate ;
	unsigned int skip ;
	IN_OUT x ;
	char dummybuf[PCM_BUFBYTES] ;


	found = 0 ;

	while (!found && ( m_mp3BytesInBuf > 0 ) )
	{
		m_framebytes = head_info3( m_mp3ReadDataPos, m_mp3BytesInBuf, &m_head, &bitrate, &skip);

		if (m_framebytes == 0) 
		{
			m_mp3ReadDataPos += (skip+1) ;
			m_mp3BytesInBuf -= (skip+1) ;
			continue ;
		}

		if (! audio_decode_init(&m_m, &m_head, m_framebytes, 0, 0, 0, 44100))
		{
			m_mp3ReadDataPos += (skip+1) ;
			m_mp3BytesInBuf -= (skip+1) ;
			continue ;
		}

		audio_decode_info(&m_m, &m_decinfo);

		cvt_to_wave_init(m_decinfo.bits);

		x = audio_decode(&m_m, m_mp3ReadDataPos+skip, (short *) (dummybuf ));

		if (x.in_bytes <= 0) 
		{
			m_mp3ReadDataPos += (skip+1) ;
			m_mp3BytesInBuf -= (skip+1) ;
			continue ;
		}

		m_bytesPerFrame = x.out_bytes ;

		m_mp3ReadDataPos += x.in_bytes;
		m_mp3BytesInBuf -= x.in_bytes;

		m_mp3ReadDataPos += skip;
		m_mp3BytesInBuf -= skip ;

		if ( m_mp3BytesInBuf >= 0 )
			found = 1 ;
		else
			found = 0 ;
	}

	return ( ! found ) ;

}


int Decoder::loadFile( char *filename )
{
	int      filesize ;
	char *ext ;
	FILE  *infile ;


	ext = strrchr( filename, '.' ) ;

	if ( ext == NULL )
	{
		return 1 ;
	}

	if ( stricmp( ext, ".MP3" ) == 0 )
	{
		infile = fopen( filename, "rb" ) ;

		if ( ! infile )
		{
			return 1 ;
		}

		fseek( infile, 0, SEEK_END ) ;
		filesize = ftell( infile ) ;
		fseek( infile, 0, SEEK_SET ) ;

		if ( m_pMp3BufferData )
		{
			free( m_pMp3BufferData ) ;
			m_pMp3BufferData = NULL ;
		}

		m_pMp3BufferData = (byte*)malloc( filesize + 64 ) ;

		m_mp3BufSize = fread( m_pMp3BufferData, 1, filesize, infile ) ;
		fclose(infile) ;


		m_mp3BytesInBuf = m_mp3BufSize ;
		m_mp3ReadDataPos = m_pMp3BufferData ;

		memset( &m_head, 0, sizeof(m_head) ) ;

		mpeg_init(&m_m, 1);

		if ( findframe(  ) )
		{
			return 1 ;
		}

		m_mp3BytesInBuf = m_mp3BufSize - ( m_framebytes  ) ;
		m_mp3ReadDataPos = m_pMp3BufferData + ( m_framebytes  ) ;


		if ( findframe(  ) )
		{
			return 1 ;
		}

		m_nBits = m_decinfo.bits;
		m_nSampleRate = m_decinfo.samprate;
		m_nChannels = m_decinfo.channels;
		m_nType = 0 ;

	}
	else if ( stricmp( ext, ".WAV" ) == 0 )
	{
		if ( wavinfile )
		{
			delete wavinfile ;
			wavinfile = NULL ;
		}

		wavinfile = new WavInFile( filename ) ;

		m_nSampleRate = wavinfile->getSampleRate() ;
		m_nBits = wavinfile->getNumBits() ;
		m_nChannels = wavinfile->getNumChannels() ;
		m_nType = 1 ;

	}
	else if ( stricmp( ext, ".OGG" ) == 0 )
	{
		infile = fopen( filename, "rb" ) ;

		if ( ! infile )
		{
			return 1 ;
		}

		if ( ogg_open( infile ) == 0 )
		{
			fclose( infile ) ;
			return 1 ;
		}


		m_nSampleRate = ogg_getrate() ;
		m_nChannels = ogg_getchannels() ;
		m_nBits = 16 ;
		m_nType = 2 ;
		

	}
	else
	{
		return 1 ;
	}

	return 0 ;
}


void convert16( unsigned char *dst, int numbytes )
{
	unsigned char src[PCM_BUFBYTES] ;

	memcpy( src, dst, numbytes ) ;
	memset( dst, 0, numbytes*2 ) ;

	for ( int i = 0 ; i < numbytes ; i++ )
	{
		if ( src[i] > 0x7F )
			dst[i*2] = src[i] - 0x80 ;
		else
			dst[i*2] = src[i] + 0x80 ;
	}

}

int Decoder::processData( ) 
{
	char szfilename[1024] ;

	m_bytesInBuffer = 0 ;

	if ( m_nType == 0 )
	{
		IN_OUT x ;

		if ( m_mp3BytesInBuf < m_framebytes)
		{
			m_bytesInBuffer = 0 ;
			return 0 ;
		}

		x = audio_decode(&m_m, m_mp3ReadDataPos, (short *) (m_pcm_buffer));

		if (x.in_bytes <= 0) 
		{
			m_bytesInBuffer = 0 ;
			return 0 ;
		}

		m_mp3ReadDataPos += x.in_bytes;
		m_mp3BytesInBuf -= x.in_bytes;

		m_bytesInBuffer= x.out_bytes ; 

		m_nPercentDone = 100 - ( (m_mp3BytesInBuf*100) / m_mp3BufSize );

	}
	else if ( m_nType == 1 )
	{
		m_bytesInBuffer = wavinfile->read(m_pcm_buffer, 1378*4);
		m_nWavBytesRead += m_bytesInBuffer ;

		m_nPercentDone = (m_nWavBytesRead * 100 ) / wavinfile->getDataSizeInBytes() ;

	}
	else if ( m_nType == 2 )
	{
		int bitStream = 0 ;

		m_bytesInBuffer = ogg_read((char*)m_pcm_buffer, 1378*4 ) ;

		m_nPercentDone = ogg_percentdone() ;
	}

	if ( m_nBits == 8 )
	{
		convert16( m_pcm_buffer, m_bytesInBuffer ) ;
	}

	return m_bytesInBuffer ;
}

unsigned char* Decoder::getBuffer() 
{
	return m_pcm_buffer ;
}

int Decoder::getBufferSize() 
{
	return m_bytesInBuffer ;
}


int Decoder::processReal(  )
{
	DWORD          playPos  ;
	DWORD          bytesToEnd ;
	DWORD          distWritePlay ;
    unsigned int pcm_bufbytes;
	char          xmsg[200] ;


	{

			//pcm_bufbytes = getData( m_pcm_buffer, 0 );

			if ( pcm_bufbytes == 0 )
			{
				return 0 ;
			}


	}



	return 0 ;
}
