#ifndef DECODER_HXX
#define DECODER_HXX

//#include "windows.h"
#include <stdio.h>
#include "decode\mhead.h"
#include "decode\port.h"
#include "wavfile.h"


#define PCM_BUFBYTES (1152 * 4 * 4 * 2)
#define byte unsigned char

typedef struct WAVEHEADER
{
	char id[4] ;
	unsigned int chunksize ;
	char format[4] ;
	char subchunkid[4] ;
	unsigned int subchunksize ;
	unsigned short audioformat ;
	unsigned short numchannels ;
	unsigned int samplerate ;
	unsigned int byterate ;
	unsigned short blockalign ;
	unsigned short bitspersample ;
	char subchunkid2[4] ;
	unsigned int datalen ;
} waveheader ;


class Decoder 
{
  public:
    Decoder();
    virtual ~Decoder();
	int processReal( ) ;
	virtual int loadFile( char *filename ) ;
	int findframe( );
	int processData() ;
	unsigned char* getBuffer() ;
	int getBufferSize() ;


  public: 

	int					m_nBits ;
	int					m_nSampleRate ;
	int					m_nChannels ;
	int					m_nType ;

	WavInFile			*wavinfile ;

	unsigned int        m_nFrameOffset ;
	unsigned int        m_nNumFrames ;
	int					m_nPercentDone ;
	int					m_nWavBytesRead ;

	byte				*m_pMp3BufferData ;
	byte				*m_mp3ReadDataPos ;
	unsigned int        m_mp3BytesInBuf ;
	unsigned int        m_mp3BufSize ;
	unsigned int        m_bytesPerFrame ;
	int                 m_bytesInBuffer ;

    MPEG_HEAD    m_head;
    MPEG         m_m;
    DEC_INFO     m_decinfo;
	unsigned int m_framebytes ;
	unsigned char	 m_pcm_buffer[PCM_BUFBYTES] ;

};
#endif

