/*clear all steps
place left arrow on all whole beats
randomize existing
randomize new

random settings : liklihood of jumping, max number of successive jumps
probability of jumps on half beats

select note range (via edit boxes?) combobox "Action" - +/- 1half beat, 
+/- 1whole beat, clear, randomize

interpret dancong monk step creation

right click -> set start/end range, select start/end freeze, 
insert bar, delete bar, clear bar, cut/copy/paste,
paste insert, paste merge, paste replc
option to snap bars to whole, half, quarter
interpret [], {}, etc markations for step files, and freeze arrows, store step data diff. 
mirror bar (swap L-R), flip bar (swap U-D), turn bar 90deg clockwise
2p edit, save data for all steps in DWI file
beat editor with more discrete markings like xstep - 
swap display mode on custom display


4th  - 40404040
8th  - 44444444
12th - [404040404040404040404040]
16th - (4444444444444444)
24th - [444444444444444444444444]
32nd - {4040404040404040404040404040404040404040404040404040404040404040}
48th - `400040004000400040004000400040004000400040004000400040004000400040004000400040004000400040004000400040004000400040004000400040004000400040004000400040004000400040004000400040004000400040004000'
64th - {4444444444444444444444444444444444444444444444444444444444444444}
40404040
;

() = 16 notes per bar
[] = 24notes per bar
`` = 48notes per bar
{} = 64 notes per bar
<> = notes encased in this indicate seemingly invalid footcombos 
like <2468> means press all feet pads simultaneously


*/

// ddr_dwi_creatorDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ddr_dwi_creator.h"
#include "ddr_dwi_creatorDlg.h"
#include ".\ddr_dwi_creatordlg.h"
#include <mmsystem.h> // Multimedia Funktionen
#include "afxwin.h"
#include "BPMDetect.h"
#include "Decoder.h"
#include "PleaseWaitDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

CRITICAL_SECTION g_critSection ;

// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

// Implementation
protected:
	DECLARE_MESSAGE_MAP()
public:
	CEdit m_edInformation;
	virtual BOOL OnInitDialog();
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_EDIT_INFO, m_edInformation);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
END_MESSAGE_MAP()


// Cddr_dwi_creatorDlg dialog



Cddr_dwi_creatorDlg::Cddr_dwi_creatorDlg(CWnd* pParent /*=NULL*/)
	: CDialog(Cddr_dwi_creatorDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

	m_bTapping = FALSE ;

}

void Cddr_dwi_creatorDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_MEDIAPLAYER1, m_mediaPlayer);
	DDX_Control(pDX, IDC_STATIC_BPM, m_staticBPM);
	DDX_Control(pDX, IDC_STATIC_ELAPSEDSECS, m_staticElapsedSecs);
	DDX_Control(pDX, IDC_STATIC_LAST_HIT, m_staticLastHit);
	DDX_Control(pDX, IDC_EDIT1, m_caption);
	DDX_Control(pDX, IDC_EDIT_BPM, m_edBPM);
	DDX_Control(pDX, IDC_SPIN_BPM2, m_spinBPM);
	DDX_Control(pDX, IDC_EDIT_GAP, m_edGap);
	DDX_Control(pDX, IDC_SPIN_GAP, m_spinGap);
	DDX_Control(pDX, IDC_CUSTOM1, m_stepDisplay);
	DDX_Control(pDX, IDC_ED_SONGSPEED, m_edSongSpeed);
	DDX_Control(pDX, IDC_EDIT_TITLE, m_edTitle);
	DDX_Control(pDX, IDC_EDIT_ARTIST, m_edArtist);
	DDX_Control(pDX, IDC_COMBO_DIFFICULTY, m_comboDifficulty);
	DDX_Control(pDX, IDC_COMBO_FOOTRATING, m_comboFootRating);
	DDX_Control(pDX, IDC_SPIN_SONGSPEED, m_spinSongSpeed);
	DDX_Control(pDX, IDC_EDIT_RANGESTART, m_edRangeStart);
	DDX_Control(pDX, IDC_EDIT_RANGEEND, m_edRangeEnd);
	DDX_Control(pDX, IDC_COMBO3, m_comboRangeAction);
	DDX_Control(pDX, IDC_EDIT_JUMPPROB, m_edJumpProbability);
	DDX_Control(pDX, IDC_SPIN_JUMPPROB, m_spinJumpProbability);
	DDX_Control(pDX, IDC_EDIT_JUMPSTRING, m_edJumpString);
	DDX_Control(pDX, IDC_SPIN_JUMPSTRING, m_spinJumpString);
	DDX_Control(pDX, IDC_EDIT_SAMPLESTART, m_edSampleStart);
	DDX_Control(pDX, IDC_EDIT_SAMPLEEND, m_edSampleEnd);
}

BEGIN_MESSAGE_MAP(Cddr_dwi_creatorDlg, CDialog)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
//	ON_WM_CHAR()
//	ON_WM_KEYDOWN()
//	ON_WM_DEADCHAR()
//ON_WM_TIMER()
ON_NOTIFY(UDN_DELTAPOS, IDC_SPIN_BPM2, OnDeltaposSpinBpm2)
ON_NOTIFY(UDN_DELTAPOS, IDC_SPIN_GAP, OnDeltaposSpinGap)
ON_BN_CLICKED(IDC_BTN_PLUSGAP, OnBnClickedBtnPlusgap)
ON_BN_CLICKED(IDC_BTN_MINUS_GAP, OnBnClickedBtnMinusGap)
ON_BN_CLICKED(IDC_BTN_SONGSPEED05, OnBnClickedBtnSongspeed05)
ON_BN_CLICKED(IDC_BTN_SONGSPEED_075, OnBnClickedBtnSongspeed075)
ON_BN_CLICKED(IDC_BTN_SONGSPEED_10, OnBnClickedBtnSongspeed10)
ON_BN_CLICKED(IDC_BTN_SONGSPEED_15, OnBnClickedBtnSongspeed15)
ON_NOTIFY(UDN_DELTAPOS, IDC_SPIN_SONGSPEED, OnDeltaposSpinSongspeed)
ON_BN_CLICKED(IDC_BUTTON_DOIT, OnBnClickedButtonDoit)
ON_BN_CLICKED(IDC_BUTTON_BPMDOUBLE, OnBnClickedButtonBpmdouble)
ON_BN_CLICKED(IDC_BUTTON_BPMHALF, OnBnClickedButtonBpmhalf)
ON_BN_CLICKED(IDC_BUTTON_SET_SAMPLE_START, OnBnClickedButtonSetSampleStart)
ON_BN_CLICKED(IDC_BUTTON_SET_SAMPLE_END, OnBnClickedButtonSetSampleEnd)
END_MESSAGE_MAP()

UINT DisplayTimingThread( LPVOID pParam )
{
	Cddr_dwi_creatorDlg *dlg = (Cddr_dwi_creatorDlg *)pParam ;

	while ( dlg->m_syncThreads == 0 )
	{
		Sleep( 16 ) ;
		dlg->m_stepDisplay.Invalidate(0) ;
	}

	(dlg->m_syncThreads)++ ;

	return 0 ;
}


UINT PlinkThread( LPVOID pParam )
{
	Cddr_dwi_creatorDlg *dlg = (Cddr_dwi_creatorDlg *)pParam ;
	DWORD count = 0 ;

	while ( dlg->m_syncThreads == 0 )
	{
		//if ( dlg->m_bTapping && dlg->m_bPlayMetronome )
		if ( dlg->m_bPlayMetronome )
		{

			EnterCriticalSection(&g_critSection) ;
			double iteration = 60.0f /  dlg->m_fBpm  ;
			double pos = dlg->m_mediaPlayer.get_CurrentPosition() ;

			if ( dlg->m_dNextPlinkPos < pos )
			{
				PlaySound( "PLINK.WAV", NULL, SND_FILENAME|SND_ASYNC|SND_NOSTOP ) ; 
				dlg->m_dNextPlinkPos += iteration ;
			}

			LeaveCriticalSection(&g_critSection) ;

			/*
			QueryPerformanceCounter((LARGE_INTEGER*)&(dlg->m_perfEnd));
			DWORD d = (dlg->m_perfEnd - dlg->m_perfStart) ;
			DWORD d2 = dlg->m_perfTicks ;

			//fprintf(outfile, "%u %u\r\n", d2, d ) ;
			if ((dlg->m_perfEnd - dlg->m_perfStart) >= dlg->m_perfTicks )
			{
				DWORD d3 = (dlg->m_perfEnd - dlg->m_perfStart) ;
				float f = d3 ;
				float f2 = dlg->m_perfFreq ;
				float f3 = f/f2 ;

				fprintf(outfile, "%f plink\r\n", f3 ) ;
				fflush(outfile) ;
				dlg->m_perfStart += dlg->m_perfTicks ;
				PlaySound( "PLINK.WAV", NULL, SND_FILENAME|SND_ASYNC|SND_NOSTOP ) ; 

			}
			*/
		}

		count++ ;

		if ( count%100 == 0 )
		{
			
			Sleep(1) ;
		}
	}

	(dlg->m_syncThreads)++ ;
	return 1 ;
}

BOOL Cddr_dwi_creatorDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	if (!QueryPerformanceFrequency((LARGE_INTEGER*)&m_perfFreq))
	{
		AfxMessageBox("This computer does not support QueryPerformanceFrequency." ) ;
		m_bPerf = FALSE ;
		//return -1;  // error hardware doesn't support performance counter
	}
	else
	{
		m_bPerf = TRUE ;
	}
	
	//m_mediaPlayer.put_AutoStart( FALSE ) ;

	m_mediaPlayer.put_PlayCount( 1000000 ) ;
	m_fBpm = 0.01f;
	m_fGap = 0.0f ;
	m_fElapsed = 0.0f;
	m_fLasthit = 0.0f;
	m_fsumbpm  = 0.0f;
	m_numbpm   = 0 ;
	m_fSampleStart = m_fSampleEnd = 0.0f ;
	m_bTapping = FALSE ;
	m_bPlayMetronome = TRUE ;
	m_dNextPlinkPos = 999 ;
	m_mode = 1 ; //tap tempo
	m_nSongSpeed = 100 ;
	m_edSongSpeed.SetWindowText( "100" ) ;
	m_comboDifficulty.SetCurSel( 0 ) ;
	m_comboFootRating.SetCurSel( 0 ) ;
	m_comboRangeAction.SetCurSel( 0 ) ;
	m_edRangeStart.SetWindowText( "1" ) ;
	m_edRangeEnd.SetWindowText( "0" ) ;
	m_nRangeStart = 1 ;
	m_nRangeEnd = 0 ;
	m_spinJumpProbability.SetRange( 1, 100 ) ;
	m_spinJumpString.SetRange( 1, 100 ) ;
	m_spinJumpProbability.SetPos( 1 ) ;
	m_spinJumpString.SetPos( 1 ) ;
	m_edJumpProbability.SetWindowText( "1" ) ;
	m_edJumpString.SetWindowText( "1" ) ;
	m_edSampleStart.SetWindowText( "0.0" ) ;
	m_edSampleEnd.SetWindowText( "5.0" ) ;
	m_fSampleStart = 0.0f ;
	m_fSampleEnd = 5.0f ;

	m_dwiSteps = "" ;

	/*
	m_dwiSteps.Append( "40404040404040" ) ;
	m_dwiSteps.Append( "20202020202020" ) ;
	m_dwiSteps.Append( "80808080808080" ) ;
	m_dwiSteps.Append( "40404040404040" ) ;
	m_dwiSteps.Append( "20202020202020" ) ;
	m_dwiSteps.Append( "80808080808080" ) ;
	m_dwiSteps.Append( "40404040404040" ) ;
	m_dwiSteps.Append( "20202020202020" ) ;
	m_dwiSteps.Append( "80808080808080" ) ;
	m_dwiSteps.Append( "40404040404040" ) ;
	m_dwiSteps.Append( "20202020202020" ) ;
	m_dwiSteps.Append( "80808080808080" ) ;
	m_dwiSteps.Append( "40404040404040" ) ;
	m_dwiSteps.Append( "20202020202020" ) ;
	m_dwiSteps.Append( "80808080808080" ) ;
	m_dwiSteps.Append( "40404040404040" ) ;
	m_dwiSteps.Append( "20202020202020" ) ;
	m_dwiSteps.Append( "80808080808080" ) ;

	for ( int i = 0 ; i < 100 ; i++ )
		m_dwiSteps.Append( "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000" ) ;
*/

	//m_mediaPlayer.Open( "c:\\audio_work\\ari ari.mp3" ) ;
	//m_mediaPlayer.put_Rate( 0.75f ) ;

	m_caption.SetWindowText( "Open a music file from the main menu." ) ;

	m_staticBPM.SetFont(_T("Fixedsys"), 35, TRUE);
	m_staticBPM.SetWindowText( "000.0" ) ;
	m_staticBPM.SetTextColor( RGB( 0,0,0), TRUE ) ;
	m_staticBPM.SetBackgroundColor(RGB(255,255,255), TRUE);

	m_staticElapsedSecs.SetFont(_T("Fixedsys"), 16, TRUE);
	m_staticElapsedSecs.SetWindowText( "000.0" ) ;
	m_staticElapsedSecs.SetTextColor( RGB( 0,0,0), TRUE ) ;
	m_staticElapsedSecs.SetBackgroundColor(RGB(255,255,255), TRUE);

	m_staticLastHit.SetFont(_T("Fixedsys"), 16, TRUE);
	m_staticLastHit.SetWindowText( "000.0" ) ;
	m_staticLastHit.SetTextColor( RGB( 0,0,0), TRUE ) ;
	m_staticLastHit.SetBackgroundColor(RGB(255,255,255), TRUE);

	m_edBPM.SetWindowText( "0.0" ) ;
	m_edGap.SetWindowText( "0.00" ) ;

	m_syncThreads = 0 ;

	m_spinGap.SetRange( 0, 100 ) ;
	m_spinBPM.SetRange( 0, 100 ) ;
	m_spinSongSpeed.SetRange(1, 300 ) ;
	m_spinSongSpeed.SetPos( 100 ) ;

	InitializeCriticalSection(&g_critSection);

	AfxBeginThread(PlinkThread, this) ;
	AfxBeginThread(DisplayTimingThread, this) ;

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void Cddr_dwi_creatorDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void Cddr_dwi_creatorDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR Cddr_dwi_creatorDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

char Cddr_dwi_creatorDlg::MergeSteps(char existing, char add, int toggle )
{
	switch (existing)
	{
		case '0' : return add ;
		case '2' :
		{
			switch ( add )
			{
				case '4' : return '1' ;
				case '6' : return '3' ;
				case '8' : return 'A' ;
				case '2' : if ( toggle ) return '0' ;
				default : break ;
			}
		}
		case '4' :
		{
			switch ( add )
			{
				case '2' : return '1' ;
				case '4' : if ( toggle ) return '0' ;
				case '6' : return 'B' ;
				case '8' : return '7' ;
				default : break ;
			}
		}
		case '6' :
		{
			switch ( add )
			{
				case '2' : return '3' ;
				case '4' : return 'B' ;
				case '6' : if ( toggle ) return '0' ;
				case '8' : return '9' ;
				default : break ;
			}
		}
		case '8' :
		{
			switch ( add )
			{
				case '2' : return 'A' ;
				case '4' : return '7' ;
				case '6' : return '9' ;
				case '8' : if ( toggle ) return '0' ;
				default : break ;
			}
		}
		case '1' :
		{
			if ( toggle )
			{
				switch ( add )
				{
					case '2' : return '4' ;
					case '4' : return '2' ;
					default : return existing ;
				}
			}
		}
		case '3' :
		{
			if ( toggle )
			{
				switch ( add )
				{
					case '2' : return '6' ;
					case '6' : return '2' ;
					default : return existing ;
				}
			}
		}
		case '9' :
		{
			if ( toggle )
			{
				switch ( add )
				{
					case '8' : return '6' ;
					case '6' : return '8' ;
					default : return existing ;
				}
			}
		}
		case '7' :
		{
			if ( toggle )
			{
				switch ( add )
				{
					case '8' : return '4' ;
					case '4' : return '8' ;
					default : return existing ;
				}
			}
		}
		case 'A' :
		{
			if ( toggle )
			{
				switch ( add )
				{
					case '8' : return '2' ;
					case '2' : return '8' ;
					default : return existing ;
				}
			}
		}
		case 'B' :
		{
			if ( toggle )
			{
				switch ( add )
				{
					case '6' : return '4' ;
					case '4' : return '6' ;
					default : return existing ;
				}
			}
		}
		default : break ;
	}

	return existing ;
}

void Cddr_dwi_creatorDlg::AddStep(DWORD keystroke)
{
	double pos = m_mediaPlayer.get_CurrentPosition() - m_fGap;
	double iteration = 30.0f /  m_fBpm  ;
	int offset = 0 ;
	char existing ;

	if ( pos < 0 )
		return ;

	while ( pos > iteration )
	{
		pos -= iteration ;
		offset++ ;
	}

	if ( ( pos / iteration ) > .50f )
	{
		offset++ ;
	}

	while ( m_dwiSteps.GetLength() < offset+1 )
	{
		m_dwiSteps.Append( "0" ) ;
	}

	existing = m_dwiSteps.GetAt( offset ) ;

	switch( keystroke )
	{
		case 39 :
		case 102: //right
		{
			m_dwiSteps.SetAt( offset, MergeSteps( existing, '6', 0 ) ) ;
			break ;
		}
		case 38 :
		case 104: //up
		{
			m_dwiSteps.SetAt( offset, MergeSteps( existing, '8', 0 ) ) ;
			break ;
		}
		case 37 :
		case 100: //left
		{
			m_dwiSteps.SetAt( offset, MergeSteps( existing, '4', 0 ) ) ;
			break ;
		}
		case 40 :
		case 98: //down
		{
			m_dwiSteps.SetAt( offset, MergeSteps( existing, '2', 0 ) ) ;
			break ;
		}
		case 32: //space, clear
		{
			m_dwiSteps.SetAt( offset, '0' ) ;
			break ;
		}
		default :
		{
			break ;
		}
	}

}

BOOL Cddr_dwi_creatorDlg::PreTranslateMessage(MSG* pMsg)
{
	if( pMsg->message == WM_KEYDOWN )
	{
		switch ( pMsg->wParam )
		{
			case VK_ESCAPE : break ;
			case VK_RETURN : 
			{
				if ( m_mediaPlayer.get_FileName().GetLength() > 0 )
				{
					double pos = m_mediaPlayer.get_CurrentPosition() ;
					double duration = m_mediaPlayer.get_Duration() ;

					if ( pos < 0 )
						pos = 0 ;

					double amtover = pos - m_fGap ;
					double iteration = 30.0f / m_fBpm  ;

					while ( amtover > iteration )
					{
						amtover -= iteration ;
					}
					if ( (iteration-amtover) > (0.15*iteration) )
					{
						pos += ( (iteration-amtover) - ( 0.1 * iteration) );
					}
					else
					{
						pos += iteration ;
					}

					if ( pos > duration )
					{
						pos = duration ;
					}

					m_mediaPlayer.put_CurrentPosition( pos ) ;
				}
				return TRUE ;
			}
			default :
			{
				if ( m_mode == 1 )
				{
					QueryPerformanceCounter((LARGE_INTEGER*)&m_perfStart);
					if ( m_bTapping )
					{
						char szbuf[30] ;

						EnterCriticalSection( &g_critSection ) ;

						DWORD currtick = GetTickCount() ;
						DWORD lengthTap = currtick - m_dwTimeLastTap;

						m_numbpm++ ;
						m_fsumbpm += lengthTap ;
						m_fLasthit = 60.0f / ( (float)lengthTap/1000.0f ) ;
						m_fBpm = 60.0f /  ( ( m_fsumbpm/(float)m_numbpm ) /1000.0f ) ;


						m_dwTimeLastTap = currtick ;

						m_perfLastHit = m_perfStart ;
						//m_perfTicks = (m_perfFreq * ((_int64)( m_fsumbpm/(float)m_numbpm ))) / 1000 ;
						m_perfTicks = ((m_perfFreq * (_int64)( m_fsumbpm))/(_int64)m_numbpm )  / (_int64)1000 ;

						double pos = m_mediaPlayer.get_CurrentPosition() ;
						double iteration = 60.0f /  m_fBpm  ;
						double duration = m_mediaPlayer.get_Duration() ;

						m_fGap = pos ;

						while ( m_fGap > iteration )
						{
							m_fGap -= iteration ;
						}

						m_dNextPlinkPos = m_fGap ;

						while ( m_dNextPlinkPos < pos )
						{
							m_dNextPlinkPos += iteration ;
						}

						m_dNextPlinkPos += iteration ;
						m_dNextPlinkPos += iteration ;

						LeaveCriticalSection( &g_critSection ) ;

						sprintf( szbuf, "%3.1f", m_fBpm ) ;
						m_staticBPM.SetWindowText( szbuf ) ;
						m_edBPM.SetWindowText( szbuf ) ;
						m_staticBPM.Invalidate(1) ;

						sprintf( szbuf, "%3.1f", m_fLasthit ) ;
						m_staticLastHit.SetWindowText( szbuf ) ;
						m_staticLastHit.Invalidate(1) ;

						sprintf( szbuf, "%3.1f", (float)(currtick - m_dwTimeStartTap)/1000.0f ) ;
						m_staticElapsedSecs.SetWindowText( szbuf ) ;
						m_staticElapsedSecs.Invalidate(1) ;

						sprintf( szbuf, "%1.2f", m_fGap ) ;
						m_edGap.SetWindowText( szbuf ) ;
					}
					else
					{
						m_fBpm = 0.01f;
						m_fElapsed  = 0.0f;
						m_fLasthit  = 0.0f;
						m_fsumbpm  = 0.0f;
						m_numbpm  = 0;
						m_dwTimeStartTap = m_dwTimeLastTap = GetTickCount() ;
						m_dNextPlinkPos = 999 ;
						m_bTapping = TRUE ;

						m_caption.SetWindowText( "Fine tune BPM/Gap with the controls below, then select \"Step Data Input\" from the Mode menu to disable keypresses being interpreted as tempo entry." ) ;
						
					}
				}
				else
				{
					AddStep( pMsg->wParam ) ;
				}
				break ;
			}
		}

	}

	return CDialog::PreTranslateMessage(pMsg);
}

void Cddr_dwi_creatorDlg::OnCancel()
{
	if ( MessageBox("Are you sure you want to quit?", "Confirm Exit", MB_YESNO ) == IDNO )
	{
		return ;
	}

	m_mediaPlayer.Stop() ;
	m_syncThreads = 1 ;

	while ( m_syncThreads != 3 )
	{
		Sleep(1) ;
	}

	CDialog::OnCancel();
}

void Cddr_dwi_creatorDlg::PreCalcBPM( LPCTSTR infile )
{
	Decoder decoder ;
	CPleaseWaitDlg dlg ;
	char szbuf[30] ;

	dlg.Create( IDD_DIALOG_PLEASEWAIT, this ) ;
	dlg.ShowWindow( SW_SHOW ) ;
	dlg.m_calcBPM.SetWindowText( "Calculating BPM...0%" ) ;

	decoder.loadFile( (char*)infile ) ;

    BPMDetect bpm( decoder.m_nChannels, decoder.m_nSampleRate, decoder.m_nBits ) ;

	while ( decoder.processData() > 0 )
	{
		bpm.inputSamples( (short*)decoder.getBuffer(), decoder.getBufferSize() / ( decoder.m_nChannels * (decoder.m_nBits/8) ) ) ;
		sprintf( szbuf, "Calculating BPM...%u%%", decoder.m_nPercentDone ) ;
		dlg.m_calcBPM.SetWindowText( szbuf ) ;
		dlg.UpdateWindow() ;
	}


	m_fBpm = bpm.getBpm() ;

	if ( m_fBpm < 100.0 )
		m_fBpm = m_fBpm * 2.0f ;

}

void Cddr_dwi_creatorDlg::OpenMusicFile()
{
	char szbuf[30] ;

	CFileDialog odlg ( TRUE, 0, 0, OFN_FILEMUSTEXIST, 0, 0, sizeof(OPENFILENAME) ) ;

	INT_PTR nResponse = odlg.DoModal();
	if (nResponse == IDOK)
	{
		PreCalcBPM( odlg.GetFileName() ) ;
		m_mediaPlayer.Open( odlg.GetFileName() ) ;
		m_mediaPlayer.put_Rate( (float)m_nSongSpeed / 100.0f ) ;

		m_dwiFilename = "" ;

		m_caption.SetWindowText( "Use the controls to adjust the BPM/Gap or start tapping keys to manually calculate the BPM/Gap." ) ;
		
		EnterCriticalSection( &g_critSection ) ;

		m_dNextPlinkPos = 0.0f ;

		double iteration = 60.0f /  m_fBpm  ;
		double pos = m_mediaPlayer.get_CurrentPosition() ;

		while ( m_dNextPlinkPos < pos )
		{
			m_dNextPlinkPos += iteration ;
		}

		m_dNextPlinkPos += iteration ;

		m_bTapping = TRUE ;



		//m_fBpm = 0.01f;
		m_fGap = 0.0f ;
		m_fElapsed = 0.0f;
		m_fLasthit = 0.0f;
		m_fsumbpm  = 0.0f;
		m_numbpm   = 0 ;
		//m_dNextPlinkPos = 999 ;
		m_mode = 1 ; //tempo tap

		LeaveCriticalSection( &g_critSection ) ;

		//m_staticBPM.SetWindowText( "000.0" ) ;
		m_staticElapsedSecs.SetWindowText( "000.0" ) ;
		m_staticLastHit.SetWindowText( "000.0" ) ;
		m_edGap.SetWindowText( "0.00" ) ;
		//m_edBPM.SetWindowText( "000.0" ) ;

		//m_staticBPM.Invalidate( 1 ) ;
		m_staticElapsedSecs.Invalidate( 1 ) ;
		m_staticLastHit.Invalidate( 1 ) ;

		sprintf( szbuf, "%3.1f", m_fBpm ) ;
		m_staticBPM.SetWindowText( szbuf ) ;
		m_edBPM.SetWindowText( szbuf ) ;
		m_staticBPM.Invalidate(1) ;

	}
	else if (nResponse == IDCANCEL)
	{
	}
    
}
BEGIN_EVENTSINK_MAP(Cddr_dwi_creatorDlg, CDialog)
	ON_EVENT(Cddr_dwi_creatorDlg, IDC_MEDIAPLAYER1, 3002, EndOfStreamMediaplayer1, VTS_I4)
	ON_EVENT(Cddr_dwi_creatorDlg, IDC_MEDIAPLAYER1, 3011, OpenStateChangeMediaplayer1, VTS_I4 VTS_I4)
	ON_EVENT(Cddr_dwi_creatorDlg, IDC_MEDIAPLAYER1, 3012, PlayStateChangeMediaplayer1, VTS_I4 VTS_I4)
	ON_EVENT(Cddr_dwi_creatorDlg, IDC_MEDIAPLAYER1, 2, PositionChangeMediaplayer1, VTS_R8 VTS_R8)
END_EVENTSINK_MAP()

void Cddr_dwi_creatorDlg::EndOfStreamMediaplayer1(long Result)
{
	//m_mediaPlayer.Stop() ;
	m_mediaPlayer.put_CurrentPosition( 0.0 ) ;

	EnterCriticalSection( &g_critSection ) ;

	m_dNextPlinkPos = m_fGap ;

	LeaveCriticalSection( &g_critSection ) ;

	m_mediaPlayer.Play() ;
	m_mediaPlayer.put_Rate( (float)m_nSongSpeed / 100.0f ) ;
}

void Cddr_dwi_creatorDlg::OpenStateChangeMediaplayer1(long OldState, long NewState)
{
	//AfxMessageBox( "opened") ;
	// TODO: Add your message handler code here
}

void Cddr_dwi_creatorDlg::PlayStateChangeMediaplayer1(long OldState, long NewState)
{
	//2=play, 1=pause, 0=stop

	if ( NewState == 2 )
	{
		m_mediaPlayer.put_Rate( (float)m_nSongSpeed / 100.0f ) ;
		EnterCriticalSection( &g_critSection ) ;

		double iteration = 60.0f /  m_fBpm  ;
		double m_dNextPlinkPos = m_fGap ;
		double pos = m_mediaPlayer.get_CurrentPosition() ;

		while ( m_dNextPlinkPos < pos )
		{
			m_dNextPlinkPos += iteration ;
		}

		LeaveCriticalSection( &g_critSection ) ;
	}
}

void Cddr_dwi_creatorDlg::PositionChangeMediaplayer1(double oldPosition, double newPosition)
{
	EnterCriticalSection( &g_critSection ) ;

	double iteration = 60.0f /  m_fBpm  ;

	m_dNextPlinkPos = m_fGap ;

	while ( m_dNextPlinkPos < newPosition )
	{
		m_dNextPlinkPos += iteration ;
	}

	m_dNextPlinkPos += iteration ;

	LeaveCriticalSection( &g_critSection ) ;
}


LRESULT Cddr_dwi_creatorDlg::WindowProc(UINT message, WPARAM wParam, LPARAM lParam)
{
	LRESULT res = CDialog::WindowProc(message, wParam, lParam);
/*
	if ( m_bTapping )
	{
		QueryPerformanceCounter((LARGE_INTEGER*)&(m_perfEnd));
		DWORD d = (m_perfEnd - m_perfStart) ;
		DWORD d2 = m_perfTicks ;

		//fprintf(outfile, "%u %u\r\n", d2, d ) ;
		if ((m_perfEnd - m_perfStart) >= m_perfTicks )
		{
			DWORD d3 = (m_perfEnd - m_perfStart) ;
			float f = d3 ;
			float f2 = m_perfFreq ;
			float f3 = f/f2 ;

			fprintf(outfile, "%f plink\r\n", f3 ) ;
			fflush(outfile) ;
			m_perfStart += m_perfTicks ;
			PlaySound( "PLINK.WAV", NULL, SND_FILENAME|SND_ASYNC|SND_NOSTOP ) ; 

		}
	}
*/
	return res ;
}

void Cddr_dwi_creatorDlg::OnDeltaposSpinBpm2(NMHDR *pNMHDR, LRESULT *pResult)
{
	char szbuf[30] ;
	LPNMUPDOWN pNMUpDown = reinterpret_cast<LPNMUPDOWN>(pNMHDR);
	// TODO: Add your control notification handler code here

	EnterCriticalSection( &g_critSection ) ;

	float newbpm = m_fBpm + ( ( (float)pNMUpDown->iDelta ) * 0.1f ) ;

	if ( newbpm < 0 )
		m_fBpm = .01f ;
	else
		m_fBpm = newbpm ;


	double pos = m_mediaPlayer.get_CurrentPosition() ;
	double iteration = 60.0f /  m_fBpm  ;
	double duration = m_mediaPlayer.get_Duration() ;
	double m_dNextPlinkPos = m_fGap ;

	while ( m_dNextPlinkPos < pos )
	{
		m_dNextPlinkPos += iteration ;
	}

	LeaveCriticalSection( &g_critSection ) ;

	*pResult = 0;

	sprintf( szbuf, "%3.1f", m_fBpm ) ;
	m_edBPM.SetWindowText( szbuf );
	m_staticBPM.SetWindowText( szbuf ) ;
	m_staticBPM.Invalidate(1) ;

}

void Cddr_dwi_creatorDlg::OnDeltaposSpinGap(NMHDR *pNMHDR, LRESULT *pResult)
{
	char szbuf[30] ;
	double iteration = 60.0f /  m_fBpm  ;

	LPNMUPDOWN pNMUpDown = reinterpret_cast<LPNMUPDOWN>(pNMHDR);

	float newgap = m_fGap + ( ( (float)pNMUpDown->iDelta ) * 0.01f ) ;

	EnterCriticalSection( &g_critSection ) ;

	if ( newgap < 0 )
		m_fGap = 0.0f ;
	else
		m_fGap = newgap ;

	m_dNextPlinkPos = m_fGap ;

	double pos = m_mediaPlayer.get_CurrentPosition() ;

	while ( m_dNextPlinkPos < pos )
	{
		m_dNextPlinkPos += iteration ;
	}

	m_dNextPlinkPos += iteration ;

	LeaveCriticalSection( &g_critSection ) ;

	*pResult = 0;

	sprintf( szbuf, "%1.2f", m_fGap ) ;
	m_edGap.SetWindowText( szbuf );

}

void Cddr_dwi_creatorDlg::OnBnClickedBtnPlusgap()
{
	char szbuf[30] ;
	double halfiteration = 30.0f /  m_fBpm  ;
	double iteration = 60.0f /  m_fBpm  ;

	EnterCriticalSection( &g_critSection ) ;

	m_fGap += halfiteration ;

	m_dNextPlinkPos = m_fGap ;

	double pos = m_mediaPlayer.get_CurrentPosition() ;

	while ( m_dNextPlinkPos < pos )
	{
		m_dNextPlinkPos += iteration ;
	}

	m_dNextPlinkPos += iteration ;

	LeaveCriticalSection( &g_critSection ) ;

	sprintf( szbuf, "%1.2f", m_fGap ) ;
	m_edGap.SetWindowText( szbuf );

}

void Cddr_dwi_creatorDlg::OnBnClickedBtnMinusGap()
{
	char szbuf[30] ;
	double halfiteration = 30.0f /  m_fBpm  ;
	double iteration = 60.0f /  m_fBpm  ;

	EnterCriticalSection( &g_critSection ) ;

	m_fGap -= halfiteration ;

	if ( m_fGap < 0 )
		m_fGap = 0 ;

	m_dNextPlinkPos = m_fGap ;

	double pos = m_mediaPlayer.get_CurrentPosition() ;

	while ( m_dNextPlinkPos < pos )
	{
		m_dNextPlinkPos += iteration ;
	}

	m_dNextPlinkPos += iteration ;

	LeaveCriticalSection( &g_critSection ) ;

	sprintf( szbuf, "%1.2f", m_fGap ) ;
	m_edGap.SetWindowText( szbuf );
}

void Cddr_dwi_creatorDlg::InitMode(int mode)
{
	EnterCriticalSection( &g_critSection ) ;

	switch ( mode )
	{
		case 1 : 
		{
			m_bTapping = FALSE ;
			m_mode = mode ;
			m_fBpm = 0.01f;
			m_fGap = 0.0f ;
			m_fElapsed = 0.0f;
			m_fLasthit = 0.0f;
			m_fsumbpm  = 0.0f;
			m_numbpm   = 0 ;
			m_dNextPlinkPos = 999 ;
			m_caption.SetWindowText( "Press any key to begin tapping out the BPM/tempo" ) ;
			m_staticBPM.SetWindowText( "000.0" ) ;
			m_staticElapsedSecs.SetWindowText( "000.0" ) ;
			m_staticLastHit.SetWindowText( "000.0" ) ;
			m_edGap.SetWindowText( "0.00" ) ;
			m_edBPM.SetWindowText( "000.0" ) ;

			m_staticBPM.Invalidate( 1 ) ;
			m_staticElapsedSecs.Invalidate( 1 ) ;
			m_staticLastHit.Invalidate( 1 ) ;

			break ;
		}
		case 2 : 
		{
			m_mode = mode ;
			m_bTapping = FALSE ;
			m_caption.SetWindowText( "Use the arrow keys to enter step data into the scrolling window on the right.  Use space key to erase step data at current location." ) ;
			break ;
		}
		default : break ;
	}

	LeaveCriticalSection( &g_critSection ) ;

}


void Cddr_dwi_creatorDlg::ImportDWI() 
{
	static char BASED_CODE szFilter[] = "DWI Files (*.dwi)|*.dwi||" ;

	if ( m_mediaPlayer.get_FileName().GetLength() == 0 )
	{
		AfxMessageBox( "First load your song file, then import the DWI data." ) ;
		return ;
	}

	CFileDialog odlg ( TRUE, 0, 0, OFN_FILEMUSTEXIST, szFilter, 0, sizeof(OPENFILENAME) ) ;

	INT_PTR nResponse = odlg.DoModal();
	if (nResponse == IDOK)
	{
		if ( odlg.GetFileExt().CompareNoCase( "DWI" ) == 0 )
		{
			FILE *infile ;
			int  filesize ;
			char *dwidata ;
			char *ptr ;
			char *line ;
			char *endpos ;
			BOOL foundStep = FALSE ;

			m_dwiFilename = odlg.GetFileName() ;

			infile = fopen( odlg.GetFileName(), "rb" ) ;
			fseek( infile, 0, SEEK_END ) ;
			filesize = ftell( infile ) ;
			fseek( infile, 0, SEEK_SET ) ;

			dwidata = (char*)malloc( filesize+1 ) ;

			memset( dwidata, 0, filesize+1 ) ;

			fread( dwidata, 1, filesize, infile ) ;
			fclose( infile ) ;

			ptr = dwidata ;

			if ( ptr[0] == '#' )
				line = ptr ;
			else
				line = strstr( ptr, "\n#" ) ;

			while ( line  )
			{
				endpos = strchr( line, ':' ) ;
				if ( endpos )
				{
					*endpos = 0 ;

					if ( line[0] == '\n' )
						line++ ;

					if ( stricmp( line+1, "TITLE" ) == 0 )
					{
						line = endpos+1 ;
						endpos = strchr( line, ';' ) ;
						if ( endpos )
						{
							*endpos = 0 ;
							m_dwiTitle = line ;
							line = endpos+1 ;
						}
					}
					else if ( stricmp( line+1, "ARTIST" ) == 0 )
					{
						line = endpos+1 ;
						endpos = strchr( line, ';' ) ;
						if ( endpos )
						{
							*endpos = 0 ;
							m_dwiArtist = line ;
							line = endpos+1 ;
						}
					}
					else if ( stricmp( line+1, "BPM" ) == 0 )
					{
						line = endpos+1 ;
						endpos = strchr( line, ';' ) ;
						if ( endpos )
						{
							*endpos = 0 ;
							m_fBpm = atof( line );
							line = endpos+1 ;
						}
					}
					else if ( stricmp( line+1, "GAP" ) == 0 )
					{
						line = endpos+1 ;
						endpos = strchr( line, ';' ) ;
						if ( endpos )
						{
							*endpos = 0 ;
							m_fGap = atof( line ) / 1000.0f ;
							line = endpos+1 ;
						}
					}
					else if ( ( stricmp( line+1, "SINGLE" ) == 0 ) && ( foundStep == FALSE ) )
					{
						line = endpos+1 ;
						endpos = strchr( line, ':' ) ;
						if ( endpos )
						{
							*endpos = 0 ;
							m_dwiDifficulty = line ;
							line = endpos+1 ;

							endpos = strchr( line, ':' ) ;
							if ( endpos )
							{
								*endpos = 0 ;
								m_dwiFootRating = atoi( line ) ;
								line = endpos + 1 ;

								endpos = strchr( line, ';' ) ;
								if ( endpos )
								{
									char msgbuf[1000] ;

									sprintf( msgbuf, "Found: Difficulty - %s ; FootRating - %u.\r\nUse these steps?  (You can only select one.)", m_dwiDifficulty, m_dwiFootRating ) ;

									if ( MessageBox( msgbuf, "Select Steps", MB_YESNO ) == IDYES )
									{
										*endpos = 0 ;

										foundStep = TRUE ;
										
										CString cstr = line ;

										m_dwiSteps = "" ;

										char charbuf[3] ;
										charbuf[1] = 0 ;
										BOOL foundInvalid = FALSE ;

										for ( int i = 0 ; i < cstr.GetLength() ; i++ )
										{
											charbuf[0] = cstr.GetAt( i ) ;
											switch ( charbuf[0] )
											{
												case '0' :
												case '1' :
												case '2' :
												case '3' :
												case '4' :
												case '6' :
												case '7' :
												case '8' :
												case '9' :
												case 'A' :
												case 'B' : m_dwiSteps.Append( charbuf ) ; break ;
												case '!' : 
												case '(' :
												case ')' :
												case '[' :
												case ']' :
												case '`' :
												case '\'' :
												case '{' :
												case '}' :
												case '<' :
												case '>' :
												{
													if ( foundInvalid == FALSE )
													{
														foundInvalid = TRUE ;
														AfxMessageBox( "Found freeze arrow or steps smaller than half-beats.\r\nNeither of these features are supported (yet).\r\nThese imported steps will probably be screwy." ) ;
													}
													break ;
												}
												default : break ;
											}
										}
									}

									line = endpos +1 ;
								}
							}
						}
					}
					else
					{
						line = endpos+1 ;
					}
				}
				else
				{
					line = line + 2 ;
				}

				ptr = line ;
				line = strstr( ptr, "\n#" ) ;
			}

			free( dwidata ) ;
			
			theApp.OnModeStepdatainput() ;

			char szbuf[30] ;

			sprintf( szbuf, "%3.1f", m_fBpm ) ;
			m_staticBPM.SetWindowText( szbuf ) ;
			m_staticBPM.Invalidate(1) ;
			m_edBPM.SetWindowText( szbuf ) ;

			sprintf( szbuf, "%1.2f", m_fGap ) ;
			m_edGap.SetWindowText( szbuf ) ;

			EnterCriticalSection( &g_critSection ) ;

			m_dNextPlinkPos  = m_fGap ;

			double iteration = 60.0f /  m_fBpm  ;
			double mppos = m_mediaPlayer.get_CurrentPosition() ;

			while ( m_dNextPlinkPos < mppos )
			{
				m_dNextPlinkPos += iteration ;
			}

			m_dNextPlinkPos += iteration ;

			LeaveCriticalSection( &g_critSection ) ;

			m_edArtist.SetWindowText( m_dwiArtist ) ;
			m_edTitle.SetWindowText( m_dwiTitle ) ;
			INT pos = m_comboDifficulty.FindString( -1, m_dwiDifficulty ) ;
			if ( pos >= 0 )
			{
				m_comboDifficulty.SetCurSel( pos ) ;
			}

			pos = m_comboFootRating.FindString( -1, itoa( m_dwiFootRating, szbuf, 10 ) ) ;
			if ( pos >= 0 )
			{
				m_comboFootRating.SetCurSel( pos ) ;
			}
		}
		else
		{
			AfxMessageBox( "File does not have a DWI extension." ) ;
		}
	}
}

void Cddr_dwi_creatorDlg::Save( BOOL newfile ) 
{
	if ( m_mediaPlayer.get_FileName().GetLength() == 0 )
	{
		AfxMessageBox( "You must first load a music file." ) ;
		return ;
	}

	if ( newfile || ( m_dwiFilename.GetLength() == 0 ) )
	{
		static char BASED_CODE szFilter[] = "DWI Files (*.dwi)|*.dwi||" ;
		CFileDialog odlg ( FALSE, "DWI", 0, OFN_OVERWRITEPROMPT, szFilter, 0, sizeof(OPENFILENAME) ) ;
		INT_PTR nResponse = odlg.DoModal();
		if (nResponse != IDOK)
		{
			return ;
		}

		m_dwiFilename = odlg.GetFileName() ;
	}

	FILE *outfile ;

	CString cstr ;

	m_edTitle.GetWindowText( cstr ) ;
	m_dwiTitle = cstr ;

	m_edArtist.GetWindowText( cstr ) ;
	m_dwiArtist = cstr ;

	m_comboDifficulty.GetWindowText( cstr ) ;
	m_dwiDifficulty = cstr ;

	m_comboFootRating.GetWindowText( cstr ) ;
	m_dwiFootRating = atoi( cstr ) ;


	double duration = m_mediaPlayer.get_Duration() - m_fGap;
	double iteration = 30.0f /  m_fBpm  ;
	int offset = 0 ;

	while ( duration > iteration )
	{
		duration -= iteration ;
		offset++ ;
	}

	offset += 2 ;

	while ( m_dwiSteps.GetLength() < offset+1 )
	{
		m_dwiSteps.Append( "0" ) ;
	}


	float samplelength ;

	samplelength = m_fSampleEnd - m_fSampleStart ;

	if ( samplelength < 0 )
		samplelength = 5.0f ;

	outfile = fopen( m_dwiFilename, "wb" ) ;
	fprintf( outfile, "#STATUS:NEW\r\n" ) ;
	fprintf( outfile, "#TITLE:%s;\r\n", m_dwiTitle ) ;
	fprintf( outfile, "#ARTIST:%s;\r\n", m_dwiArtist ) ;
	fprintf( outfile, "#BPM:%3.6f;\r\n", m_fBpm ) ;
	fprintf( outfile, "#GAP:%5.3f;\r\n\r\n", m_fGap * 1000.0f ) ;
	fprintf( outfile, "#SAMPLESTART:%3.5f;\r\n", m_fSampleStart ) ;
	fprintf( outfile, "#SAMPLELENGTH:%3.5f;\r\n", samplelength ) ;
	fprintf( outfile, "#SINGLE:%s:%u:%s;\r\n", m_dwiDifficulty, m_dwiFootRating, m_dwiSteps ) ;

	fclose( outfile ) ;

}

void Cddr_dwi_creatorDlg::OnBnClickedBtnSongspeed05()
{
	m_nSongSpeed = 50 ;
	m_edSongSpeed.SetWindowText( "50" ) ;
	m_mediaPlayer.put_Rate( (float)m_nSongSpeed / 100.0f ) ;
}

void Cddr_dwi_creatorDlg::OnBnClickedBtnSongspeed075()
{
	m_nSongSpeed = 75 ;
	m_edSongSpeed.SetWindowText( "75" ) ;
	m_mediaPlayer.put_Rate( (float)m_nSongSpeed / 100.0f ) ;
}

void Cddr_dwi_creatorDlg::OnBnClickedBtnSongspeed10()
{
	m_nSongSpeed = 100 ;
	m_edSongSpeed.SetWindowText( "100" ) ;
	m_mediaPlayer.put_Rate( 1 ) ;
}

void Cddr_dwi_creatorDlg::OnBnClickedBtnSongspeed15()
{
	m_nSongSpeed = 150 ;
	m_edSongSpeed.SetWindowText( "150" ) ;
	m_mediaPlayer.put_Rate( (float)m_nSongSpeed / 100.0f ) ;
}

void Cddr_dwi_creatorDlg::OnDeltaposSpinSongspeed(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMUPDOWN pNMUpDown = reinterpret_cast<LPNMUPDOWN>(pNMHDR);

	char szbuf[30] ;
	m_nSongSpeed = pNMUpDown->iPos ;

	sprintf( szbuf, "%u", m_nSongSpeed ) ;
	m_edSongSpeed.SetWindowText( szbuf ) ;
	m_mediaPlayer.put_Rate( (float)m_nSongSpeed / 100.0f ) ;


	*pResult = 0;
}

void Cddr_dwi_creatorDlg::OnBnClickedButtonDoit()
{
	if ( m_nRangeStart > m_nRangeEnd )
	{
		AfxMessageBox( "Range start is greater than range end.\r\nUse the left and right mouse buttons to click on the\r\nstarting end ending beats to select a range." ) ;
		return ;
	}

	int selection = m_comboRangeAction.GetCurSel() ;

	switch ( selection )
	{
		case 0 :
		{
			m_dwiSteps.Insert( m_nRangeStart, "0" ) ;
			m_dwiSteps.Delete( m_nRangeEnd+2, 1 ) ;

			char szbuf[30] ;

			m_nRangeStart++ ;
			sprintf( szbuf, "%u", m_nRangeStart ) ;
			m_edRangeStart.SetWindowText( szbuf ) ;

			m_nRangeEnd++ ;
			sprintf( szbuf, "%u", m_nRangeEnd ) ;
			m_edRangeEnd.SetWindowText( szbuf ) ;
			break ;
		}
		case 1 :
		{
			if ( m_nRangeStart > 0 )
			{
				m_dwiSteps.Insert( m_nRangeEnd+1, "0" ) ;
				m_dwiSteps.Delete( m_nRangeStart-1, 1 ) ;
				char szbuf[30] ;

				m_nRangeStart-- ;
				sprintf( szbuf, "%u", m_nRangeStart ) ;
				m_edRangeStart.SetWindowText( szbuf ) ;

				m_nRangeEnd-- ;
				sprintf( szbuf, "%u", m_nRangeEnd ) ;
				m_edRangeEnd.SetWindowText( szbuf ) ;
			}
			break ;
		}
		case 2 :
		{
			if ( MessageBox( "Are you sure you want to erase the selected range of beats?", "Confirm Erase", MB_YESNO ) == IDYES )
			{
				for ( int i = m_nRangeStart ; i < m_nRangeEnd+1 ; i++ )
				{
					m_dwiSteps.SetAt( i, '0' ) ;
				}
			}
			break ;
		}
		case 3 :
		{
			if ( MessageBox( "Are you sure you want to randomize the selected range of beats?", "Confirm Randomize", MB_YESNO ) == IDYES )
			{
				Randomize() ;
			}
			break ;
		}
	}


	
}

char validsteps[14][14] =
{
	{ 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, '4' },
	{ 0, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, '8' },
	{ 0, 0, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, '2' },
	{ 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 0, '6' },
	{ 1, 0, 1, 0, 1, 0, 1, 1, 1, 1, 0, 1, 1, '8' },
	{ 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, '2' },
	{ 1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, '7' },
	{ 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, '1' },
	{ 1, 0, 0, 1, 0, 0, 1, 1, 1, 1, 0, 1, 0, 'B' },
	{ 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, '9' },
	{ 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 'A' },
	{ 1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, '3' },
	{ 1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 'A' }
} ;

//0 = Left foot L
//1 = Left foot up
//2 = Left foot down
//3 = Right foot right
//4 = right foot up
//5 = right foot down
//6 = L,L R,U
//7 = L,L R,D
//8 = L,L R,R
//9 = L,U R,R
//10 = L,U R,D
//11 = L,D R,R
//12 = L,D R,U


void Cddr_dwi_creatorDlg::Randomize()
{

	int firststep = -1 ;

	for ( int i = m_nRangeStart; i < m_dwiSteps.GetLength() ; i++ ) 
	{
		if ( m_dwiSteps.GetAt( i ) != '0' )
		{
			firststep = i ;
			break ;
		}
	}

	if ( firststep < 0 )
		return ;

	int jumpstringlen = 0 ;
	int randstep = 0 ;
	int laststep = 0 ;

	if ( m_dwiSteps.GetAt( firststep+1 ) != '0' )
	{
		laststep = rand()%6 ;
		m_dwiSteps.SetAt(firststep, validsteps[laststep][13] );
	}
	else
	{
		laststep = rand()%13 ;
		m_dwiSteps.SetAt(firststep, validsteps[laststep][13] );

		if ( laststep > 5 )
		{
			jumpstringlen++ ;
		}
	} 

#define RANDOM_NON_JUMP \
				do \
				{\
					randstep = rand()%6 ;\
				} while ( validsteps[laststep][randstep] == 0 ) ;\
				m_dwiSteps.SetAt( i, validsteps[randstep][13]) ;\
				laststep = randstep ;\
				jumpstringlen = 0 ;

#define RANDOM_JUMP \
				do \
				{\
					randstep = (rand()%7) + 6 ;\
				} while ( validsteps[laststep][randstep] == 0 ) ;\
				m_dwiSteps.SetAt( i, validsteps[randstep][13]) ;\
				laststep = randstep ;\
				jumpstringlen++ ;

#define RANDOM_ANY \
	do\
	{\
		randstep = rand()%13 ;\
	} while ( validsteps[laststep][randstep] == 0 ) ;\
	m_dwiSteps.SetAt( i, validsteps[randstep][13]) ;\
	laststep = randstep ;\
	if ( randstep > 5 )\
	{\
		jumpstringlen++ ;\
	}\
	else\
	{\
		jumpstringlen = 0 ;\
	}


	for ( int i = firststep+1 ; i < m_nRangeEnd+1 ; i++ )
	{
		if ( m_dwiSteps[i] != '0' )
		{
			if ( m_dwiSteps[i+1] != '0' )
			{
				RANDOM_NON_JUMP ;
			}
			else
			{
				if ( m_dwiSteps[i-1] != '0' )
				{
					RANDOM_NON_JUMP ;
				}
				else
				{
					if ( jumpstringlen > m_spinJumpString.GetPos() )
					{
						RANDOM_NON_JUMP ;
					}
					else
					{
						if ( jumpstringlen )
						{
							RANDOM_ANY ;
						}
						else
						{
							if ( (rand()*100)/RAND_MAX > ( 100 - m_spinJumpProbability.GetPos() ) )
							{
								RANDOM_ANY ;
							}
							else
							{
								RANDOM_NON_JUMP ;
							}
						}
					}
				}
			}
		}
		else
		{
			jumpstringlen = 0 ; 
		}
	}
}

BOOL CAboutDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	m_edInformation.SetWindowText( "Questions or comments?  Please read the README.TXT file included with this package.  If you still have question or comment, please email me at scarlberg@nc.rr.com\r\nIf that email is no longer working, search for my name on google and find my current homepage.  My current email address will be on it." ) ;

	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

void Cddr_dwi_creatorDlg::OnBnClickedButtonBpmdouble()
{
	char szbuf[30] ;
	
	EnterCriticalSection( &g_critSection ) ;

	m_fBpm = m_fBpm * 2.0f ;

	double iteration = 60.0f /  m_fBpm  ;
	double pos = m_mediaPlayer.get_CurrentPosition() ;

	m_dNextPlinkPos = 0.0f ;


	while ( m_dNextPlinkPos < pos )
	{
		m_dNextPlinkPos += iteration ;
	}

	m_dNextPlinkPos += iteration ;

	LeaveCriticalSection( &g_critSection ) ;

	sprintf( szbuf, "%3.1f", m_fBpm ) ;
	m_staticBPM.SetWindowText( szbuf ) ;
	m_edBPM.SetWindowText( szbuf ) ;
	m_staticBPM.Invalidate(1) ;


}

void Cddr_dwi_creatorDlg::OnBnClickedButtonBpmhalf()
{
	char szbuf[30] ;
	
	EnterCriticalSection( &g_critSection ) ;

	m_fBpm = m_fBpm / 2.0f ;

	double iteration = 60.0f /  m_fBpm  ;
	double pos = m_mediaPlayer.get_CurrentPosition() ;

	m_dNextPlinkPos = 0.0f ;


	while ( m_dNextPlinkPos < pos )
	{
		m_dNextPlinkPos += iteration ;
	}

	m_dNextPlinkPos += iteration ;

	LeaveCriticalSection( &g_critSection ) ;

	sprintf( szbuf, "%3.1f", m_fBpm ) ;
	m_staticBPM.SetWindowText( szbuf ) ;
	m_edBPM.SetWindowText( szbuf ) ;
	m_staticBPM.Invalidate(1) ;
}

void Cddr_dwi_creatorDlg::OnBnClickedButtonSetSampleStart()
{
	char szbuf[30] ;
	m_fSampleStart = m_mediaPlayer.get_CurrentPosition() ;

	if ( m_fSampleStart < 0 )
		m_fSampleStart = 0.0f ;

	sprintf( szbuf, "%3.2f", m_fSampleStart ) ;

	m_edSampleStart.SetWindowText( szbuf ) ;
}

void Cddr_dwi_creatorDlg::OnBnClickedButtonSetSampleEnd()
{
	char szbuf[30] ;
	m_fSampleEnd = m_mediaPlayer.get_CurrentPosition() ;

	if ( m_fSampleEnd < 0 )
		m_fSampleEnd = 0.0f ;

	sprintf( szbuf, "%3.2f", m_fSampleEnd ) ;

	m_edSampleEnd.SetWindowText( szbuf ) ;
}
