// ddr_dwi_creatorDlg.h : header file
//

#pragma once
#include "mediaplayer1.h"
#include "afxcmn.h"
#include "afxwin.h"
#include "xcolorstatic.h"
#include "customdisplay.h"

// Cddr_dwi_creatorDlg dialog
class Cddr_dwi_creatorDlg : public CDialog
{
// Construction
public:
	Cddr_dwi_creatorDlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	enum { IDD = IDD_DDR_DWI_CREATOR_DIALOG };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support


// Implementation
protected:
	HICON m_hIcon;

	// Generated message map functions
	virtual BOOL OnInitDialog();
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	DECLARE_MESSAGE_MAP()
public:
	CMediaplayer1 m_mediaPlayer;
	CXColorStatic m_staticBPM;
//	afx_msg void OnChar(UINT nChar, UINT nRepCnt, UINT nFlags);
//	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
//	afx_msg void OnDeadChar(UINT nChar, UINT nRepCnt, UINT nFlags);
protected:
//	virtual BOOL OnWndMsg(UINT message, WPARAM wParam, LPARAM lParam, LRESULT* pResult);
public:
	void PreCalcBPM( LPCTSTR infile );
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	virtual void OpenMusicFile() ;
	void AddStep(DWORD keystroke) ;
protected:
	virtual void OnCancel();
public:
	CXColorStatic m_staticElapsedSecs;
	CXColorStatic m_staticLastHit;

	float  m_fBpm ;
	float  m_fGap ;
	float  m_fElapsed ;
	float  m_fLasthit ;
	float  m_fsumbpm ;
	float  m_fSampleStart ;
	float  m_fSampleEnd ;
	double m_dNextPlinkPos ;
	UINT   m_numbpm ;
	BOOL   m_bTapping ;
	BOOL   m_bPlayMetronome ;
	DWORD  m_dwTimeLastTap ;
	DWORD  m_dwTimeStartTap ;
	_int64 m_perfStart, m_perfEnd, m_perfFreq, m_perfTicks, m_perfLastHit ;
	BOOL   m_bPerf ;
	int    m_syncThreads ;
	int    m_mode ;

	UINT  m_timer ;

	DECLARE_EVENTSINK_MAP()
	void EndOfStreamMediaplayer1(long Result);
	void OpenStateChangeMediaplayer1(long OldState, long NewState);
	void PositionChangeMediaplayer1(double oldPosition, double newPosition);
//	afx_msg void OnTimer(UINT nIDEvent);
	CEdit m_caption;
protected:
	virtual LRESULT WindowProc(UINT message, WPARAM wParam, LPARAM lParam);
public:
	void PlayStateChangeMediaplayer1(long OldState, long NewState);
	afx_msg void OnDeltaposSpinBpm2(NMHDR *pNMHDR, LRESULT *pResult);
	CEdit m_edBPM;
	CSpinButtonCtrl m_spinBPM;
	CEdit m_edGap;
	CSpinButtonCtrl m_spinGap;
	afx_msg void OnDeltaposSpinGap(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnBnClickedBtnPlusgap();
	afx_msg void OnBnClickedBtnMinusGap();
	void InitMode(int mode);
	char MergeSteps(char existing, char add, int toggle);
	void ImportDWI() ;
	void Randomize();
	void Save( BOOL newfile ) ;
	CCustomDisplay m_stepDisplay;
	CString m_dwiFilename ;
	CString m_dwiArtist ;
	CString m_dwiTitle ;
	CString m_dwiDifficulty ;
	int     m_dwiFootRating ;
	CString m_dwiSteps ;
	int		m_nRangeStart ;
	int		m_nRangeEnd ;
	afx_msg void OnBnClickedBtnSongspeed05();
	afx_msg void OnBnClickedBtnSongspeed075();
	afx_msg void OnBnClickedBtnSongspeed10();
	afx_msg void OnBnClickedBtnSongspeed15();
	afx_msg void OnDeltaposSpinSongspeed(NMHDR *pNMHDR, LRESULT *pResult);
	CEdit m_edSongSpeed;
	CEdit m_edTitle;
	CEdit m_edArtist;
	CComboBox m_comboDifficulty;
	CComboBox m_comboFootRating;
	int     m_nSongSpeed ;
	CSpinButtonCtrl m_spinSongSpeed;
	afx_msg void OnBnClickedButtonDoit();
	CEdit m_edRangeStart;
	CEdit m_edRangeEnd;
	CComboBox m_comboRangeAction;
	CEdit m_edJumpProbability;
	CSpinButtonCtrl m_spinJumpProbability;
	CEdit m_edJumpString;
	CSpinButtonCtrl m_spinJumpString;
	afx_msg void OnBnClickedButtonBpmdouble();
	afx_msg void OnBnClickedButtonBpmhalf();
	CEdit m_edSampleStart;
	CEdit m_edSampleEnd;
	afx_msg void OnBnClickedButtonSetSampleStart();
	afx_msg void OnBnClickedButtonSetSampleEnd();
};
