#include "vorbis\vorbisfile.h"

OggVorbis_File		g_oggFile;
int g_rate ;
int g_channels ;

int ogg_open( FILE *infile )
{
	vorbis_info *pInfo;

	if ( g_oggFile.datasource )
	{
		ov_clear( &g_oggFile ) ;
		g_oggFile.datasource = NULL ;
		return 1 ;
	}

	if ( ov_open(infile, &g_oggFile, NULL, 0) == 0 )
	{
	}

	pInfo = ov_info(&g_oggFile, -1);

	if ( pInfo == NULL )
	{
		ov_clear( &g_oggFile ) ;
		g_oggFile.datasource = NULL;
		return 1 ;
	}

	g_rate = pInfo->rate ;
	g_channels = pInfo->channels ;

}

int ogg_getrate() 
{
	return g_rate ;
}

int ogg_getchannels()
{
	return g_channels ;
}

int ogg_read( char *buf, int bufsize )
{
	int bitStream = 0 ;

	return ov_read(&g_oggFile, buf, bufsize, 0, 2, 1, &bitStream);
}

int ogg_percentdone()
{
	return ( ov_pcm_tell( &g_oggFile ) * 100 ) / ov_pcm_total( &g_oggFile, -1 ) ;
}

