// CustomDisplay.cpp : implementation file
//

#include "stdafx.h"
#include "CustomDisplay.h"
#include "resource.h"
#include "ddr_dwi_creatorDlg.h"
#include "math.h"
#include ".\customdisplay.h"
#include "memdc.h"

#define CUSTOMDISPLAY_CLASSNAME    _T("MFCCustomDisplayCtrl")  // Window class name

#define ARROW_LEFT   32
#define ARROW_UP     0
#define ARROW_DOWN   16
#define ARROW_RIGHT  48

#define ARROW_BLANK  0
#define ARROW_RED    16
#define ARROW_BLUE   32
#define ARROW_GREEN  48

#define ARROW_LEFT_X  20
#define ARROW_DOWN_X  52
#define ARROW_UP_X    84
#define ARROW_RIGHT_X 116

Cddr_dwi_creatorDlg *m_dlg ;

// CCustomDisplay

IMPLEMENT_DYNAMIC(CCustomDisplay, CWnd)
CCustomDisplay::CCustomDisplay()
{
	RegisterWindowClass();

	m_arrows.LoadBitmap( IDB_BITMAP_ARROW_GRID_INVERSE ) ;
	m_bmScrollUp.LoadBitmap( IDB_BITMAP_SCROLLUP ) ;
	m_bmScrollDown.LoadBitmap( IDB_BITMAP_SCROLLDOWN ) ;
	//m_arrows.LoadBitmap( IDB_BITMAP_ARROW_GRID ) ;

	for ( int i  = 0 ; i < 310 ; i++ )
	{
		m_pointMapping[i] = 0 ;
	}
	for ( int i  = 0 ; i < 34 ; i++ )
	{
		m_pointMapping[i] = 1 ;
	}
	for ( int i  = 36 ; i < 70 ; i++ )
	{
		m_pointMapping[i] = 2 ;
	}
	for ( int i  = 72 ; i < 106 ; i++ )
	{
		m_pointMapping[i] = 3 ;
	}
	for ( int i  = 194 ; i < 228 ; i++ )
	{
		m_pointMapping[i] = 4 ;
	}
	for ( int i  = 230 ; i < 264 ; i++ )
	{
		m_pointMapping[i] = 5 ;
	}
	for ( int i  = 266 ; i < 300 ; i++ )
	{
		m_pointMapping[i] = 6 ;
	}

}

BOOL CCustomDisplay::Create(CWnd* pParentWnd, const RECT& rect, UINT nID, DWORD dwStyle /*=WS_VISIBLE*/)
{
	BOOL res ;

	res = CWnd::Create(CUSTOMDISPLAY_CLASSNAME, _T(""), dwStyle, rect, pParentWnd, nID);

	m_dlg = (Cddr_dwi_creatorDlg*)(this->GetParent()) ;

	return res ;
}

BOOL CCustomDisplay::RegisterWindowClass()
{
    WNDCLASS wndcls;
    HINSTANCE hInst = AfxGetInstanceHandle();

    if (!(::GetClassInfo(hInst, CUSTOMDISPLAY_CLASSNAME, &wndcls)))
    {
        // otherwise we need to register a new class
        wndcls.style            = CS_HREDRAW | CS_VREDRAW;
        wndcls.lpfnWndProc      = ::DefWindowProc;
        wndcls.cbClsExtra       = wndcls.cbWndExtra = 0;
        wndcls.hInstance        = hInst;
        wndcls.hIcon            = NULL;
        wndcls.hCursor          = AfxGetApp()->LoadStandardCursor(IDC_ARROW);
        wndcls.hbrBackground    = (HBRUSH) (COLOR_3DFACE + 1);
        wndcls.lpszMenuName     = NULL;
        wndcls.lpszClassName    = CUSTOMDISPLAY_CLASSNAME;

        if (!AfxRegisterClass(&wndcls))
        {
            AfxThrowResourceException();
            return FALSE;
        }
    }

    return TRUE;
}

CCustomDisplay::~CCustomDisplay()
{
}


BEGIN_MESSAGE_MAP(CCustomDisplay, CWnd)
	ON_WM_ERASEBKGND()
	ON_WM_PAINT()
	ON_WM_LBUTTONDOWN()
	ON_WM_RBUTTONDOWN()
	ON_COMMAND(ID_TOP_SETRANGESTART, OnTopSetrangestart)
	ON_COMMAND(ID_STEPOPTIONS_SETRANGEENDATTHISSTEP, OnStepoptionsSetrangeendatthisstep)
END_MESSAGE_MAP()



// CCustomDisplay message handlers


BOOL CCustomDisplay::OnEraseBkgnd(CDC* pDC)
{
	// TODO: Add your message handler code here and/or call default

	return FALSE ;
	return CWnd::OnEraseBkgnd(pDC);
}
BOOL CCustomDisplay::BlitArrows( int offset, int y, CDC *src, CDC *dst)
{
	BOOL gotarrow = FALSE ;
	BOOL gotfreeze = FALSE ;

	if ( offset < 0 )
		return FALSE ;

	while ( m_dlg->m_dwiSteps.GetLength() < offset+1 )
	{
		m_dlg->m_dwiSteps.Append( "0" ) ;
	}

	char c = m_dlg->m_dwiSteps.GetAt( offset ) ;

	int  color = ( (offset%2)==0 ? ARROW_RED : ARROW_BLUE ) ;
		

	//while ( gotarrow == FALSE )
	{
		switch ( c )
		{
			case '1' :
			{
				dst->BitBlt(ARROW_LEFT_X,  y, 16,16, src, ARROW_LEFT, color, SRCAND);
				dst->BitBlt(ARROW_DOWN_X,  y, 16,16, src, ARROW_DOWN, color, SRCAND);
				gotarrow = TRUE ;
				break ;
			}
			case '2' :
			{
				dst->BitBlt(ARROW_DOWN_X,  y, 16,16, src, ARROW_DOWN, color, SRCAND);
				gotarrow = TRUE ;
				break ;
			}
			case '3' :
			{
				dst->BitBlt(ARROW_RIGHT_X,  y, 16,16, src, ARROW_RIGHT, color, SRCAND);
				dst->BitBlt(ARROW_DOWN_X,  y, 16,16, src, ARROW_DOWN, color, SRCAND);
				gotarrow = TRUE ;
				break ;
			}
			case '4' :
			{
				dst->BitBlt(ARROW_LEFT_X,  y, 16,16, src, ARROW_LEFT, color, SRCAND);
				gotarrow = TRUE ;
				break ;
			}
			case '6' :
			{
				dst->BitBlt(ARROW_RIGHT_X,  y, 16,16, src, ARROW_RIGHT, color, SRCAND);
				gotarrow = TRUE ;
				break ;
			}
			case '7' :
			{
				dst->BitBlt(ARROW_LEFT_X,  y, 16,16, src, ARROW_LEFT, color, SRCAND);
				dst->BitBlt(ARROW_UP_X,  y, 16,16, src, ARROW_UP, color, SRCAND);
				gotarrow = TRUE ;
				break ;
			}
			case '8' :
			{
				dst->BitBlt(ARROW_UP_X,  y, 16,16, src, ARROW_UP, color, SRCAND);
				gotarrow = TRUE ;
				break ;
			}
			case '9' :
			{
				dst->BitBlt(ARROW_UP_X,  y, 16,16, src, ARROW_UP, color, SRCAND);
				dst->BitBlt(ARROW_RIGHT_X,  y, 16,16, src, ARROW_RIGHT, color, SRCAND);
				gotarrow = TRUE ;
				break ;
			}
			case 'A' :
			{
				dst->BitBlt(ARROW_UP_X,  y, 16,16, src, ARROW_UP, color, SRCAND);
				dst->BitBlt(ARROW_DOWN_X,  y, 16,16, src, ARROW_DOWN, color, SRCAND);
				gotarrow = TRUE ;
				break ;
			}
			case 'B' :
			{
				dst->BitBlt(ARROW_LEFT_X,  y, 16,16, src, ARROW_LEFT, color, SRCAND);
				dst->BitBlt(ARROW_RIGHT_X,  y, 16,16, src, ARROW_RIGHT, color, SRCAND);
				gotarrow = TRUE ;
				break ;
			}
			/*
			case '!' :
			{
				c = m_dlg->m_dwiSteps.GetAt( offset+1 ) ;
				color = ARROW_GREEN ;
				gotfreeze = TRUE ;
				break ;
			}
			*/
			default : break ;

		}
	}

	return gotfreeze ;
}

void CCustomDisplay::OnPaint()
{

	//CPaintDC dc(this); // device context for painting
	CPaintDC pdc(this); // device context for painting
	CMemDC dc(&pdc);

	//int vrefresh = dc.GetDeviceCaps( VREFRESH ) ;
    // Get Size of Display area
    CRect rect;
	CPen pen( PS_SOLID, 2, RGB(0,0,0) ) ;
	CPen *oldpen ;
	//CPen pen( PS_SOLID, 2, RGB(255,255,255) ) ;

    GetClientRect(rect);
	oldpen = (CPen*)dc.SelectObject(&pen) ;


	dc.FillSolidRect (rect, RGB(255,255,255));


	//return ;

	//dc.SetBkColor( RGB(255,255,255) ) ;
	//dc.SetBkMode() ;
	//dc.FillSolidRect (rect, RGB(0,0,0));
	

	CDC MemDC;

    if (!MemDC.CreateCompatibleDC(&dc))
        return;


	double pos = m_dlg->m_mediaPlayer.get_CurrentPosition() ;

	if ( pos < 0 )
		pos = 0 ;

	double currpos = pos ;
	double iteration = 60.0f /  m_dlg->m_fBpm  ;
    
	int offset = 0 ;

	pos -= m_dlg->m_fGap ;

	while ( pos > iteration )
	{
		pos -= iteration ;
		offset++ ;
	}

	offset *= 2 ;

	//float offsetf = ((currpos - m_dlg->m_fGap )/(iteration/2.0)) ;
	//int offset = offsetf ;

	//offsetf -= offset ;

	//if ( offsetf > .50000000 )
		//offset++ ;

	int startpos = 16-(pos*18.0f/iteration)  ;

	if ( startpos < 16 )
	{
		startpos += 18 ;
		offset += 1 ;
	}
	else
	{
	}

    // Draw the bitmap
    CBitmap* pOldBitmap = (CBitmap*) MemDC.SelectObject(&m_arrows);

	if( ( offset%2 ) == 0 )
	{
		for ( int i = 0 ; i < 16 ; i++ )
		{
			int y = startpos + (i*18);

			dc.MoveTo (0, y);
			dc.LineTo (150, y);

			BlitArrows( offset, y-8, &MemDC, &dc  ) ;
			BlitArrows( offset+1, y+1, &MemDC, &dc ) ;

			offset+=2 ;
		}
	}
	else
	{
		for ( int i = 0 ; i < 16 ; i++ )
		{
			int y = startpos + (i*18);

			dc.MoveTo (0, y);
			dc.LineTo (150, y);

			BlitArrows( offset, y-17, &MemDC, &dc  ) ;
			BlitArrows( offset+1, y-8, &MemDC, &dc ) ;

			offset+=2 ;
		}
	}

    dc.BitBlt(20,  8, 16,16, &MemDC, ARROW_LEFT, ARROW_BLANK, SRCAND);
    dc.BitBlt(52,  8, 16,16, &MemDC, ARROW_DOWN, ARROW_BLANK, SRCAND);
    dc.BitBlt(84,  8, 16,16, &MemDC, ARROW_UP, ARROW_BLANK, SRCAND);
    dc.BitBlt(116, 8, 16,16, &MemDC, ARROW_RIGHT, ARROW_BLANK, SRCAND);

    MemDC.SelectObject(&m_bmScrollUp);
    dc.BitBlt(160,  0, 32,106, &MemDC, 0, 0, SRCAND);
	
    MemDC.SelectObject(&m_bmScrollDown);
    dc.BitBlt(160,  194, 32,106, &MemDC, 0, 0, SRCAND);
	

    MemDC.SelectObject(pOldBitmap);      
	dc.SelectObject(oldpen) ;

	//dc.FillSolidRect( rect, RGB( 255,0,0) ) ;

}

void CCustomDisplay::PreSubclassWindow()
{
	// TODO: Add your specialized code here and/or call the base class

	m_dlg = (Cddr_dwi_creatorDlg*)(this->GetParent()) ;
	CWnd::PreSubclassWindow();
}


BOOL CCustomDisplay::Create(LPCTSTR lpszClassName, LPCTSTR lpszWindowName, DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID, CCreateContext* pContext)
{
	BOOL res ;
	res = CWnd::Create(lpszClassName, lpszWindowName, dwStyle, rect, pParentWnd, nID, pContext);

	m_dlg = (Cddr_dwi_creatorDlg*)(this->GetParent()) ;

	return res ;
}

void CCustomDisplay::OnLButtonDown(UINT nFlags, CPoint point)
{

	char szbuf[70] ;

	if ( m_dlg->m_mediaPlayer.get_FileName().GetLength() > 0 )
	{
		if ( ( point.x > 159 ) && ( point.x < 192 ) )
		{
			double pos = m_dlg->m_mediaPlayer.get_CurrentPosition() ;
			double duration = m_dlg->m_mediaPlayer.get_Duration() ;

			if ( pos < 0 )
				pos = 0 ;

			double amtover = pos - m_dlg->m_fGap ;
			double iteration = 30.0f /  m_dlg->m_fBpm  ;

			while ( amtover > iteration )
			{
				amtover -= iteration ;
			}


			switch ( m_pointMapping[point.y] )
			{
				case 1 : 
				{
					//AfxMessageBox( "clicked up1" ) ; 

					if ( amtover < (0.85*iteration) )
					{
						pos -= (amtover + ( 0.1 * iteration) );
					}
					else
					{
						pos -= iteration ;
					}

					if ( pos < 0 )
					{
						pos = 0 ;
					}

					//sprintf( szbuf, "new pos %3.5f", pos ) ;
					//AfxMessageBox (szbuf ) ;
					m_dlg->m_mediaPlayer.put_CurrentPosition( pos ) ;
					break ;
				}
				case 2 : 
				{
					//AfxMessageBox( "clicked up1" ) ; 

					if ( amtover < (0.85*iteration) )
					{
						pos -= (amtover + ( 0.1 * iteration) );
						pos -= iteration ;
					}
					else
					{
						pos -= iteration ;
						pos -= iteration ;
					}

					if ( pos < 0 )
					{
						pos = 0 ;
					}

					//sprintf( szbuf, "new pos %3.5f", pos ) ;
					//AfxMessageBox (szbuf ) ;
					m_dlg->m_mediaPlayer.put_CurrentPosition( pos ) ;
					break ;
				}
				case 3 : 
				{
					//AfxMessageBox( "clicked up1" ) ; 

					if ( amtover < (0.85*iteration) )
					{
						pos -= (amtover + ( 0.1 * iteration) );
						pos -= 29.0*iteration ;
					}
					else
					{
						pos -= 30.0*iteration ;
					}

					if ( pos < 0 )
					{
						pos = 0 ;
					}

					//sprintf( szbuf, "new pos %3.5f", pos ) ;
					//AfxMessageBox (szbuf ) ;
					m_dlg->m_mediaPlayer.put_CurrentPosition( pos ) ;
					break ;
				}
				case 4 : 
				{
					//AfxMessageBox( "clicked up1" ) ; 

					if ( (iteration-amtover) > (0.15*iteration) )
					{
						pos += ( (iteration-amtover) - ( 0.1 * iteration) );
						pos += 29.0 * iteration ;
					}
					else
					{
						pos += 30.0*iteration ;
					}

					if ( pos > duration )
					{
						pos = duration ;
					}

					//sprintf( szbuf, "new pos %3.5f", pos ) ;
					//AfxMessageBox (szbuf ) ;
					m_dlg->m_mediaPlayer.put_CurrentPosition( pos ) ;
					break ;
				}
				case 5 : 
				{
					//AfxMessageBox( "clicked up1" ) ; 

					if ( (iteration-amtover) > (0.15*iteration) )
					{
						pos += ( (iteration-amtover) - ( 0.1 * iteration) );
						pos += iteration ;
					}
					else
					{
						pos += iteration ;
						pos += iteration ;
					}

					if ( pos > duration )
					{
						pos = duration ;
					}

					//sprintf( szbuf, "new pos %3.5f", pos ) ;
					//AfxMessageBox (szbuf ) ;
					m_dlg->m_mediaPlayer.put_CurrentPosition( pos ) ;
					break ;
				}
				case 6 : 
				{
					//AfxMessageBox( "clicked up1" ) ; 

					if ( (iteration-amtover) > (0.15*iteration) )
					{
						pos += ( (iteration-amtover) - ( 0.1 * iteration) );
					}
					else
					{
						pos += iteration ;
					}

					if ( pos > duration )
					{
						pos = duration ;
					}

					//sprintf( szbuf, "new pos %3.5f", pos ) ;
					//AfxMessageBox (szbuf ) ;
					m_dlg->m_mediaPlayer.put_CurrentPosition( pos ) ;
					break ;
				}
				default : break ;
			}

		}
		else if ( ( point.x > 19 ) && ( point.x < 132 ) && ( point.y > 10 ) )
		{
			ClickNote( point.x, point.y ) ;

		}
	}

	CWnd::OnLButtonDown(nFlags, point);
}

int CCustomDisplay::LineToStepOffset( int y )
{
	double pos = m_dlg->m_mediaPlayer.get_CurrentPosition() ;

	if ( pos < 0 )
		pos = 0 ;

	double iteration = 30.0f /  m_dlg->m_fBpm  ;
	double pixels = y - 10 ;

	pos = pos + ( ( pixels/9.0 ) * iteration ) ;

	int offset = 0 ;

	pos -= m_dlg->m_fGap ;

	while ( pos > iteration )
	{
		pos -= iteration ;
		offset++ ;
	}

	return offset ;
}

void CCustomDisplay::ClickNote( int x, int y )
{
	char add ;
	char existing ;

	if ( ( x > 19 ) && ( x < 36 ) )
	{
		add = '4' ;
	}
	else if ( ( x > 51 ) && ( x < 68 ) )
	{
		add = '2' ;
	}
	else if ( ( x > 83 ) && ( x < 100 ) )
	{
		add = '8' ;
	}
	else if ( ( x > 115 ) && ( x < 132 ) )
	{
		add = '6' ;
	}
	else
	{
		return ;
	}


	int offset = LineToStepOffset( y ) ;

	while ( m_dlg->m_dwiSteps.GetLength() < offset+1 )
	{
		m_dlg->m_dwiSteps.Append( "0" ) ;
	}

	existing = m_dlg->m_dwiSteps.GetAt( offset ) ;

	m_dlg->m_dwiSteps.SetAt( offset, m_dlg->MergeSteps( existing, add, 1 ) );


}

void CCustomDisplay::OnRButtonDown(UINT nFlags, CPoint point)
{

	if ( m_dlg->m_mediaPlayer.get_FileName().GetLength() > 0 )
	{
		if ( ( point.x > 19 ) && ( point.x < 132 ) && ( point.y > 10 ) )
		{
			int offset = LineToStepOffset( point.y ) ;


			CMenu contextMenu;
			CRect rect ;

			contextMenu.LoadMenu(IDR_MENU_CUSTOMFLOAT);

			CMenu *psubContextMenu = contextMenu.GetSubMenu(0);
			ASSERT(psubContextMenu);

			GetClientRect(rect);
			ClientToScreen( rect ) ;

			psubContextMenu->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON, point.x + rect.TopLeft().x , point.y + rect.TopLeft().y , this);


			m_currentOffset = offset ;
		}
	}

	CWnd::OnRButtonDown(nFlags, point);
}

void CCustomDisplay::OnTopSetrangestart()
{
	m_dlg->m_nRangeStart = m_currentOffset ;

	char szbuf[30] ;

	sprintf( szbuf, "%u", m_currentOffset ) ;
	m_dlg->m_edRangeStart.SetWindowText( szbuf ) ;
	m_dlg->m_nRangeStart = m_currentOffset ;
}

void CCustomDisplay::OnStepoptionsSetrangeendatthisstep()
{
	m_dlg->m_nRangeEnd = m_currentOffset ;

	char szbuf[30] ;

	sprintf( szbuf, "%u", m_currentOffset ) ;
	m_dlg->m_edRangeEnd.SetWindowText( szbuf ) ;
	m_dlg->m_nRangeEnd = m_currentOffset ;
}
